/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib.listEdit;

import gov.nist.healthcare.mdc.applib.box.panel.OKCancelPanel;
import gov.nist.healthcare.mdc.applib.listEdit.ListEditControl;
import gov.nist.healthcare.mdc.applib.listEdit.ListEditModel;
import gov.nist.healthcare.mdc.applib.listEdit.ListEditViewRenderer;
import gov.nist.healthcare.mdc.framework.StandaloneResourceManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ListEditView
extends OKCancelPanel
implements ActionListener {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private JButton addButton;
    private JButton removeButton;
    private JList destJList;
    private JList sourceJList;
    private JDialog dialog;
    private final ListEditControl listEditControl;

    public ListEditView(ListEditControl control) {
        this.listEditControl = control;
        this.interfaceBuilder();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        super.actionPerformed(arg0);
        if (arg0.getSource() == this.addButton) {
            this.addAction();
        } else if (arg0.getSource() == this.removeButton) {
            this.removeAction();
        }
    }

    protected void addAction() {
        for (Object select : this.sourceJList.getSelectedValues()) {
            ((ListEditModel)select).setInDestList(true);
        }
        this.sourceJList.getSelectionModel().clearSelection();
        this.sourceJList.setListData(this.listEditControl.geEditModeltList(false));
        this.destJList.setListData(this.listEditControl.geEditModeltList(true));
        this.sourceJList.updateUI();
        this.destJList.updateUI();
    }

    @Override
    protected void cancelButtonAction() {
        this.dialog.dispose();
    }

    @Override
    protected void okButtonAction() {
        this.dialog.dispose();
    }

    protected void removeAction() {
        for (Object select : this.destJList.getSelectedValues()) {
            ((ListEditModel)select).setInDestList(false);
        }
        this.destJList.getSelectionModel().clearSelection();
        this.sourceJList.setListData(this.listEditControl.geEditModeltList(false));
        this.destJList.setListData(this.listEditControl.geEditModeltList(true));
        this.sourceJList.updateUI();
        this.destJList.updateUI();
    }

    private void interfaceBuilder() {
        this.setLayout(new GridBagLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        this.addButton = new JButton("");
        this.addButton.setToolTipText("Add to list");
        this.addButton.addActionListener(this);
        this.addButton.setIcon(StandaloneResourceManager.getInstance().getImageIcon("LEFTICON"));
        this.removeButton = new JButton("");
        this.removeButton.setToolTipText("Remove from list");
        this.removeButton.addActionListener(this);
        this.removeButton.setIcon(StandaloneResourceManager.getInstance().getImageIcon("RIGHTICON"));
        this.sourceJList = new JList<ListEditModel>(this.listEditControl.geEditModeltList(false));
        this.destJList = new JList<ListEditModel>(this.listEditControl.geEditModeltList(true));
        this.sourceJList.getSelectionModel().clearSelection();
        ListEditViewRenderer listRenderer = new ListEditViewRenderer();
        this.sourceJList.setCellRenderer(listRenderer);
        this.destJList.setCellRenderer(listRenderer);
        JLabel sourceLabel = new JLabel(this.listEditControl.getSrcListLabel());
        mainPanel.add((Component)sourceLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, EMPTY_INSETS, 0, 0));
        mainPanel.add((Component)new JScrollPane(this.sourceJList), new GridBagConstraints(0, 1, 1, 5, 0.5, 1.0, 10, 1, EMPTY_INSETS, 0, 0));
        mainPanel.add((Component)this.addButton, new GridBagConstraints(1, 2, 1, 2, 0.0, 0.25, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        mainPanel.add((Component)this.removeButton, new GridBagConstraints(1, 4, 1, 2, 0.0, 0.25, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        JLabel destLabel = new JLabel(this.listEditControl.getDestListLabel());
        mainPanel.add((Component)destLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, EMPTY_INSETS, 0, 0));
        mainPanel.add((Component)new JScrollPane(this.destJList), new GridBagConstraints(2, 1, 1, 5, 0.5, 1.0, 10, 1, EMPTY_INSETS, 0, 0));
        this.add((Component)mainPanel, new GridBagConstraints(0, 0, 0, 1, 0.0, 1.0, 12, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.getButtonPanel(), new GridBagConstraints(-1, -1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.dialog = new JDialog(this.listEditControl.getFrame(), this.listEditControl.getTitle(), true);
        this.dialog.getContentPane().add((Component)this, "Center");
        this.dialog.setSize(480, 360);
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }
}

