/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib.box;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class CollapsablePanel
extends JPanel
implements ActionListener {
    private static Icon imIconMinus = UIManager.getIcon("Tree.expandedIcon");
    private static Icon imIconPlus = UIManager.getIcon("Tree.collapsedIcon");
    private static final long serialVersionUID = 1L;
    private JButton btnCollapse;
    private JComponent collapsablePane = null;
    private JPanel contentPanel;
    private JPanel headPanel = null;
    private boolean isExpanded = true;

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = Button.class.getResource(path);
        return new ImageIcon(imgURL);
    }

    public CollapsablePanel() {
        this.initializeWithLabel("");
    }

    public CollapsablePanel(String label) {
        this.initializeWithLabel(label);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.btnCollapse) {
            if (this.isExpanded) {
                this.collapse();
            } else {
                this.expand();
            }
        }
    }

    public void collapse() {
        if (this.isExpanded) {
            this.btnCollapse.setIcon(imIconPlus);
            this.contentPanel.remove(this.collapsablePane);
            this.isExpanded = false;
            this.updateUI();
        }
    }

    public void expand() {
        if (!this.isExpanded) {
            this.btnCollapse.setIcon(imIconMinus);
            this.contentPanel.add((Component)this.collapsablePane, "Center");
            this.isExpanded = true;
            this.updateUI();
        }
    }

    public JComponent getCollapsablePane() {
        return this.collapsablePane;
    }

    public JPanel getHeadPane() {
        return this.headPanel;
    }

    public void setCollapsablePane(JComponent collapsablePan) {
        if (collapsablePan != null) {
            this.contentPanel.remove(collapsablePan);
        }
        this.collapsablePane = collapsablePan;
        this.contentPanel.add((Component)collapsablePan, "Center");
    }

    public void setHeadPane(JComponent headerPanIn) {
        if (this.headPanel != null && headerPanIn != null) {
            this.headPanel.remove(headerPanIn);
        }
        this.headPanel.add((Component)headerPanIn, "Center");
    }

    private void initializeWithLabel(String label) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(label));
        this.headPanel = new JPanel();
        this.headPanel.setLayout(new BorderLayout());
        this.contentPanel = new JPanel();
        this.contentPanel.setFocusable(false);
        this.contentPanel.setLayout(new BorderLayout());
        JPanel panelTemp = new JPanel();
        JPanel panelTemp2 = new JPanel();
        panelTemp2.setLayout(new BoxLayout(panelTemp2, 2));
        panelTemp2.add(Box.createRigidArea(new Dimension(10, 0)));
        panelTemp2.add(panelTemp);
        panelTemp.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 0, Color.GRAY));
        this.contentPanel.add((Component)panelTemp2, "West");
        this.btnCollapse = new JButton();
        this.btnCollapse.setFocusable(false);
        this.btnCollapse.addActionListener(this);
        this.btnCollapse.setIcon(imIconMinus);
        this.btnCollapse.setPreferredSize(new Dimension(10, 10));
        JPanel p = new JPanel();
        p.add(this.btnCollapse);
        this.headPanel.add((Component)p, "West");
        this.add((Component)this.headPanel, "First");
        this.add((Component)this.contentPanel, "Center");
    }
}

