/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.applib.beanbinding;

import gov.nist.healthcare.dev.profile.control.app.DynamicProxyTest;
import gov.nist.healthcare.deviceProfile.domain.IMDObject;
import gov.nist.healthcare.deviceProfile.domain.common.TermcodeUtils;
import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceObject;
import gov.nist.healthcare.mdc.applib.beanbinding.BeanBinding;
import gov.nist.healthcare.mdc.applib.beanbinding.BeanBindingModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public abstract class BeanBindingImpl
extends BeanBindingModel
implements BeanBinding,
PropertyChangeListener {
    private static final Logger log = Logger.getLogger(BeanBindingImpl.class.getName());

    private static Object create(Class<?> clss) throws Exception {
        Constructor<?> ctor = clss.getDeclaredConstructor(new Class[0]);
        if (!ctor.isAccessible()) {
            try {
                ctor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return ctor.newInstance(new Object[0]);
    }

    public BeanBindingImpl() {
    }

    public BeanBindingImpl(Class bclss, String bindingFieldName) {
        this.fieldName = bindingFieldName;
        this.bindingClass = bclss;
    }

    @Override
    public String getObjectValue() {
        String txt = "";
        try {
            Field field = TermcodeUtils.getField(this.getBindingClass(), (String)this.getFieldName());
            field.setAccessible(true);
            if (this.getBindingObject() != null) {
                txt = (String)field.get(this.getBindingObject());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return txt;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.fieldName.equals(evt.getPropertyName())) {
            System.out.println("" + evt.getPropertyName() + " = [" + evt.getOldValue() + "->" + evt.getNewValue() + "]");
            this.updateView();
        }
    }

    @Override
    public void reset() {
        try {
            this.bindingObject = BeanBindingImpl.create(this.bindingClass);
            this.updateView();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setObjectValue(String txt) {
        try {
            Object proxy = this.bindingObject;
            if (this.bindingObject instanceof DeviceObject) {
                proxy = DynamicProxyTest.getDynObject((DeviceObject)((DeviceObject)this.bindingObject), null);
            }
            String methodName = this.fieldName.substring(0, 1).toUpperCase() + this.fieldName.substring(1);
            String setMethodName = "set" + methodName;
            Field field = TermcodeUtils.getField((Class)this.bindingClass, (String)this.fieldName);
            field.setAccessible(true);
            Method setMethod = this.bindingClass.getDeclaredMethod(setMethodName, field.getType());
            if (this.bindingObject instanceof DeviceObject) {
                setMethod = IMDObject.class.getDeclaredMethod(setMethodName, field.getType());
            }
            if (setMethod == null) {
                log.info(setMethodName);
            }
            if (proxy == null) {
                log.info("proxy == null");
            }
            setMethod.invoke(proxy, txt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setupBindingObject(Object obj) {
        if (obj != null) {
            this.reset();
            this.bindingObject = obj;
            if (obj instanceof DeviceObject) {
                IMDObject iMDObject = DynamicProxyTest.getDynObject((DeviceObject)((DeviceObject)obj), (PropertyChangeListener)this);
            }
            this.updateView();
        }
    }

    @Override
    public Boolean updateObject() {
        String value = this.getObjectValue();
        String txt = this.getViewText();
        if (txt != null) {
            if (value == null || !txt.equals(value)) {
                this.setObjectValue(txt);
            }
        } else {
            this.setObjectValue("");
        }
        return true;
    }

    @Override
    public Boolean updateView() {
        String value = this.getObjectValue();
        String txt = this.getViewText();
        if (value != null) {
            if (txt == null || !txt.equals(value)) {
                this.setViewText(value);
            }
        } else {
            this.setViewText("");
        }
        return true;
    }
}

