/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.sync;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import gov.nist.healthcare.dev.profile.control.dao.AllRestModule;
import gov.nist.healthcare.dev.profile.dao.DimDao;
import gov.nist.healthcare.dev.profile.dao.NomnDao;
import gov.nist.healthcare.dev.profile.dao.impl.x73.dim.DimDaoJPAImpl;
import gov.nist.healthcare.deviceProfile.domain.rtmms.nomenclature.Coded_term;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimAttribute;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.EntiCardinality;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class DimDBSync {
    private static final Logger log = Logger.getLogger(DimDBSync.class.getName());
    protected DimDao dimDao;
    protected NomnDao nomnDao;
    protected EntityManager em;

    public DimDBSync(String pu) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)pu);
        this.em = emf.createEntityManager();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AllRestModule()});
        this.dimDao = (DimDao)injector.getInstance(DimDao.class);
        this.nomnDao = (NomnDao)injector.getInstance(NomnDao.class);
    }

    public void rest_sync() {
        List objects = this.dimDao.getObjects();
        ArrayList<DimObject> persistList = new ArrayList<DimObject>();
        for (DimObject obj : objects) {
            DimObject ret = this.dimDao.getObject(obj);
            System.out.println(ret.toDump());
            persistList.add(ret);
        }
        for (DimObject obj : persistList) {
            for (EntiCardinality card : obj.getCardinalities()) {
                DimObject child = card.getChildObject();
                DimObject parent = card.getParentObject();
                child = this.getDimObjectFromList(child, persistList);
                parent = this.getDimObjectFromList(parent, persistList);
                card.setChildObject(child);
                card.setParentObject(parent);
            }
        }
        this.persistObjList(persistList);
    }

    private DimObject getDimObjectFromList(DimObject obj, List<DimObject> objList) {
        for (DimObject tmp : objList) {
            if (!tmp.getRefid().equals(obj.getRefid()) || !tmp.getName().equals(obj.getName())) continue;
            return tmp;
        }
        return null;
    }

    public void syncRemoteEJBtoLocalJPA() {
        try {
            InitialContext ctx = new InitialContext();
            DimDao dao = (DimDao)ctx.lookup(DimDao.class.getName());
            this.persistObjList(dao.getObjects());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void persistObjList(List<DimObject> dimObjList) {
        for (DimObject obj : dimObjList) {
            obj.setId(null);
            List terms = this.nomnDao.getTermsByReferenceId(obj.getRefid());
            if (terms.size() > 0) {
                Coded_term term = (Coded_term)terms.get(0);
                obj.setTermcode(term.toCFCode());
                System.out.println(term.toCFCode());
            }
            for (DimAttribute attr : obj.getDimAttributes()) {
                attr.setId(null);
            }
            for (DimAttribute attr : obj.getDimBehaviors()) {
                attr.setId(null);
            }
            for (DimAttribute attr : obj.getDimNotifications()) {
                attr.setId(null);
            }
            for (EntiCardinality card : obj.getCardinalities()) {
                card.setId(null);
            }
        }
        DimDaoJPAImpl local = new DimDaoJPAImpl(this.em);
        local.persistObjects(dimObjList);
    }
}

