/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd;

import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73Attribute;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73Behavior;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73DimObject;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73Notification;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73Numeric;
import gov.nist.healthcare.dev.profile.control.file.xmlv1.pcd.model.X73Unit;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class V1ObjectParser {
    V1ObjectParser() {
    }

    protected X73DimObject newInstance(Node inNode) {
        X73DimObject cur = inNode.getNodeName().equals("Numeric") ? new X73Numeric() : new X73DimObject();
        cur.setObjectName(inNode.getNodeName());
        return cur;
    }

    protected boolean parseMoc(X73DimObject curMOC, Node node) {
        if (node.getNodeName().equals("OBJECT_NAME")) {
            curMOC.setObjectName(node.getFirstChild().getNodeValue());
            Element elnode = (Element)node;
            curMOC.setObjectNameLabel(elnode.getAttribute("Label"));
        } else if (node.getNodeName().equals("OBJECT_ID")) {
            curMOC.setObjectId(node.getFirstChild().getNodeValue());
        } else if (node.getNodeName().equals("MOC_TYPE_ID")) {
            if (node.getFirstChild() == null) {
                curMOC.setMocTypeID("");
            } else {
                curMOC.setMocTypeID(node.getFirstChild().getNodeValue());
            }
        } else if (node.getNodeName().equals("MOC_TYPE_TERM_CODE")) {
            if (node.getFirstChild() == null) {
                curMOC.setTypeIDTermCode("");
            } else {
                curMOC.setTypeIDTermCode(node.getFirstChild().getNodeValue());
            }
        } else if (node.getNodeName().equals("TERM_CODE")) {
            curMOC.setMocTermCode(node.getFirstChild().getNodeValue());
        } else if (node.getNodeName().equals("Reference")) {
            if (node.getFirstChild() == null || node.getFirstChild().getNodeValue() == "") {
                curMOC.setReference("");
                curMOC.setPrivate(true);
            } else {
                curMOC.setReference(node.getFirstChild().getNodeValue());
                curMOC.setPrivate(false);
            }
        } else if (node.getNodeName().equals("MOC_RESTRICTIONS")) {
            if (node.getFirstChild() == null) {
                curMOC.setMocRestrictions("");
            } else {
                curMOC.setMocRestrictions(node.getFirstChild().getNodeValue());
            }
        } else if (node.getNodeName().equals("MOC_APPLICATION_GUIDANCE")) {
            if (node.getFirstChild() == null) {
                curMOC.setMocApplicationGuidance("");
            } else {
                curMOC.setMocApplicationGuidance(node.getFirstChild().getNodeValue());
            }
        } else if (node.getNodeName().equals("MOC_SERVICES_SUPPORTED")) {
            if (node.getFirstChild() == null) {
                curMOC.setMocServicesSupported("");
            } else {
                curMOC.setMocServicesSupported(node.getFirstChild().getNodeValue());
            }
        } else if (node.getNodeName().equals("MOC_COMMENT")) {
            if (node.getFirstChild() == null) {
                curMOC.setMocComment("");
            } else {
                curMOC.setMocComment(node.getFirstChild().getNodeValue());
            }
        } else {
            return true;
        }
        return false;
    }

    protected void parseMocAttribute(X73DimObject curMOC, Node node) {
        NodeList attrAChildren = node.getChildNodes();
        int attrKeyNumber = 0;
        for (int a = 0; a < attrAChildren.getLength(); ++a) {
            NodeList attrChildren = attrAChildren.item(a).getChildNodes();
            if (attrAChildren.item(a) == null) continue;
            if (attrAChildren.item(a).getNodeType() == 1 && attrAChildren.item(a).getNodeName().equals("External-Attribute")) {
                NodeList attrPrivChildren = attrAChildren.item(a).getChildNodes();
                for (int ap = 0; ap < attrPrivChildren.getLength(); ++ap) {
                    if (attrPrivChildren.item(ap).getNodeType() != 1) continue;
                    X73Attribute currentAtt = new X73Attribute();
                    NodeList attrPChildren = attrPrivChildren.item(ap).getChildNodes();
                    for (int k = 0; k < attrPChildren.getLength(); ++k) {
                        if (attrPChildren.item(k).getFirstChild() == null) continue;
                        if (attrPChildren.item(k).getNodeName().equals("ATTRIBUTE_NAME")) {
                            System.out.println(attrPChildren.item(k).getFirstChild().getNodeValue());
                            currentAtt.setBaseName(attrPChildren.item(k).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (attrPChildren.item(k).getNodeName().equals("ATTRIBUTE_ID")) {
                            currentAtt.setBaseRefId(attrPChildren.item(k).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (attrPChildren.item(k).getNodeName().equals("ATTRIBUTE_TYPE")) {
                            if (attrPChildren.item(k).getFirstChild() == null) continue;
                            currentAtt.setAttributeType(attrPChildren.item(k).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (attrPChildren.item(k).getNodeName().equals("TERM_CODE")) {
                            currentAtt.setBaseTermcode(attrPChildren.item(k).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (attrPChildren.item(k).getNodeName().equals("Reference")) {
                            if (attrPChildren.item(k).getFirstChild() == null) continue;
                            currentAtt.setBaseReference(attrPChildren.item(k).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (attrPChildren.item(k).getNodeName().equals("Qual")) {
                            currentAtt.setParaMode(attrPChildren.item(k).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (attrPChildren.item(k).getNodeName().equals("ATTRIBUTE_ACCESS")) {
                            if (attrPChildren.item(k).getFirstChild() == null) {
                                currentAtt.setAttributeAccess("");
                                continue;
                            }
                            currentAtt.setAttributeAccess(attrPChildren.item(k).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (attrPChildren.item(k).getNodeName().equals("ATTRIBUTE_VALUE_RANGE")) {
                            if (attrPChildren.item(k).getFirstChild() == null) {
                                currentAtt.setAttributeValueRange("");
                                continue;
                            }
                            currentAtt.setAttributeValueRange(attrChildren.item(k).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (attrPChildren.item(k).getNodeName().equals("ATTRIBUTE_STATIC_DYN")) {
                            if (attrPChildren.item(k).getFirstChild() == null) continue;
                            currentAtt.setAttrStaticDyn(attrPChildren.item(k).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (attrPChildren.item(k).getNodeName().equals("ATTRIBUTE_RESTRICTIONS")) {
                            if (attrPChildren.item(k).getFirstChild() == null) {
                                currentAtt.setExtRestrictions("");
                                continue;
                            }
                            currentAtt.setExtRestrictions(attrChildren.item(k).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (attrPChildren.item(k).getNodeName().equals("ATTRIBUTE_APPLICATION_GUIDANCE")) {
                            if (attrPChildren.item(k).getFirstChild() == null) {
                                currentAtt.setAttributeApplicationGuidance("");
                                continue;
                            }
                            currentAtt.setAttributeApplicationGuidance(attrChildren.item(k).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (!attrPChildren.item(k).getNodeName().equals("ATTRIBUTE_COMMENT")) continue;
                        if (attrPChildren.item(k).getFirstChild() == null) {
                            currentAtt.setExtComment("");
                            continue;
                        }
                        currentAtt.setExtComment(attrChildren.item(k).getFirstChild().getNodeValue());
                    }
                    currentAtt.setPrivate(true);
                    curMOC.addAttribute(currentAtt);
                }
                continue;
            }
            if (attrAChildren.item(a).getNodeType() != 1 || attrAChildren.item(a).getNodeName().equals("External-Attribute")) continue;
            X73Attribute currentAtt = new X73Attribute();
            Element attrElement = (Element)attrAChildren.item(a);
            currentAtt.setAttributeGroupName(attrElement.getAttribute("attrGrpName"));
            currentAtt.setAttributeGroupId(attrElement.getAttribute("attrGrpId"));
            currentAtt.setAttributeGroupTermCode(attrElement.getAttribute("attrGrpTermCode"));
            currentAtt.setAttributeDerivedFrom(attrElement.getAttribute("derivedFrom"));
            currentAtt.setKeynum(attrKeyNumber);
            ++attrKeyNumber;
            for (int k = 0; k < attrChildren.getLength(); ++k) {
                if (attrChildren.item(k).getFirstChild() == null) continue;
                if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_NAME")) {
                    currentAtt.setBaseName(attrChildren.item(k).getFirstChild().getNodeValue());
                    continue;
                }
                if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_ID")) {
                    currentAtt.setBaseRefId(attrChildren.item(k).getFirstChild().getNodeValue());
                    continue;
                }
                if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_TYPE")) {
                    if (attrChildren.item(k).getFirstChild() == null) continue;
                    currentAtt.setAttributeType(attrChildren.item(k).getFirstChild().getNodeValue());
                    continue;
                }
                if (attrChildren.item(k).getNodeName().equals("TERM_CODE")) {
                    currentAtt.setBaseTermcode(attrChildren.item(k).getFirstChild().getNodeValue());
                    continue;
                }
                if (attrChildren.item(k).getNodeName().equals("Reference")) {
                    if (attrChildren.item(k).getFirstChild() == null) continue;
                    currentAtt.setBaseReference(attrChildren.item(k).getFirstChild().getNodeValue());
                    continue;
                }
                if (attrChildren.item(k).getNodeName().equals("Qual")) {
                    currentAtt.setParaMode(attrChildren.item(k).getFirstChild().getNodeValue());
                    continue;
                }
                if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_ACCESS")) {
                    if (attrChildren.item(k).getFirstChild() == null) {
                        currentAtt.setAttributeAccess("");
                        continue;
                    }
                    currentAtt.setAttributeAccess(attrChildren.item(k).getFirstChild().getNodeValue());
                    continue;
                }
                if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_STATIC_DYN")) {
                    if (attrChildren.item(k).getFirstChild() == null) continue;
                    currentAtt.setAttrStaticDyn(attrChildren.item(k).getFirstChild().getNodeValue());
                    continue;
                }
                if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_VALUE_RANGE")) {
                    if (attrChildren.item(k).getFirstChild() == null) {
                        currentAtt.setAttributeValueRange("");
                        continue;
                    }
                    currentAtt.setAttributeValueRange(attrChildren.item(k).getFirstChild().getNodeValue());
                    continue;
                }
                if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_SAMPLE_VALUE")) {
                    if (currentAtt.getParaType().equals("") || !attrChildren.item(k).hasChildNodes()) continue;
                    NodeList list = attrChildren.item(k).getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        Node node1 = list.item(i);
                        if (node1.getNodeType() != 1) continue;
                    }
                    continue;
                }
                if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_RESTRICTIONS")) {
                    if (attrChildren.item(k).getFirstChild() == null) {
                        currentAtt.setExtRestrictions("");
                        continue;
                    }
                    currentAtt.setExtRestrictions(attrChildren.item(k).getFirstChild().getNodeValue());
                    continue;
                }
                if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_APPLICATION_GUIDANCE")) {
                    if (attrChildren.item(k).getFirstChild() == null) {
                        currentAtt.setAttributeApplicationGuidance("");
                        continue;
                    }
                    currentAtt.setAttributeApplicationGuidance(attrChildren.item(k).getFirstChild().getNodeValue());
                    continue;
                }
                if (!attrChildren.item(k).getNodeName().equals("ATTRIBUTE_COMMENT")) continue;
                if (attrChildren.item(k).getFirstChild() == null) {
                    currentAtt.setExtComment("");
                    continue;
                }
                currentAtt.setExtComment(attrChildren.item(k).getFirstChild().getNodeValue());
            }
            curMOC.addAttribute(currentAtt);
        }
    }

    protected void parseMocBehavoir(X73DimObject curMOC, Node node) {
        NodeList behavBChildren = node.getChildNodes();
        int behavKeyNumber = 0;
        for (int b = 0; b < behavBChildren.getLength(); ++b) {
            NodeList behavChildren = behavBChildren.item(b).getChildNodes();
            if (behavBChildren.item(b) == null) continue;
            if (behavBChildren.item(b).getNodeType() == 1 && behavBChildren.item(b).getNodeName() == "Private-Behaviour") {
                NodeList behavPrivateChildren = behavBChildren.item(b).getChildNodes();
                for (int i = 0; i < behavPrivateChildren.getLength(); ++i) {
                    if (behavPrivateChildren.item(i) == null || behavPrivateChildren.item(i).getNodeType() != 1) continue;
                    X73Behavior currentBeh = new X73Behavior();
                    currentBeh.setKeynum(behavKeyNumber);
                    ++behavKeyNumber;
                    behavChildren = behavPrivateChildren.item(i).getChildNodes();
                    for (int l = 0; l < behavChildren.getLength(); ++l) {
                        if (behavChildren.item(l) == null || behavChildren.item(l).getFirstChild() == null) continue;
                        if (behavChildren.item(l).getNodeName().equals("METHOD_NAME")) {
                            currentBeh.setBaseName(behavChildren.item(l).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (behavChildren.item(l).getNodeName().equals("METHOD_ID")) {
                            currentBeh.setBaseRefId(behavChildren.item(l).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (behavChildren.item(l).getNodeName().equals("BEHAVIOUR_ACTION_PARAMETER")) {
                            if (behavChildren.item(l).getFirstChild() == null) {
                                currentBeh.setBehaviourActionParameter("");
                                continue;
                            }
                            currentBeh.setBehaviourActionParameter(behavChildren.item(l).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (behavChildren.item(l).getNodeName().equals("BEHAVIOUR_ACTION_RESULT")) {
                            if (behavChildren.item(l).getFirstChild() == null) {
                                currentBeh.setBehaviourActionResult("");
                                continue;
                            }
                            currentBeh.setBehaviourActionResult(behavChildren.item(l).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (behavChildren.item(l).getNodeName().equals("TERM_CODE")) {
                            currentBeh.setBaseTermcode(behavChildren.item(l).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (behavChildren.item(l).getNodeName().equals("Reference")) {
                            currentBeh.setBaseReference(behavChildren.item(l).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (behavChildren.item(l).getNodeName().equals("Qual")) {
                            currentBeh.setParaMode(behavChildren.item(l).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (behavChildren.item(l).getNodeName().equals("BEHAVIOUR_RESTRICTIONS")) {
                            if (behavChildren.item(l).getFirstChild() == null) {
                                currentBeh.setExtRestrictions("");
                                continue;
                            }
                            currentBeh.setExtRestrictions(behavChildren.item(l).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (!behavChildren.item(l).getNodeName().equals("BEHAVIOUR_COMMENT")) continue;
                        if (behavChildren.item(l).getFirstChild() == null) {
                            currentBeh.setExtComment("");
                            continue;
                        }
                        currentBeh.setExtComment(behavChildren.item(l).getFirstChild().getNodeValue());
                    }
                    currentBeh.setPrivate(true);
                    curMOC.addBehaviour(currentBeh);
                }
                continue;
            }
            if (behavBChildren.item(b).getNodeType() != 1 || behavBChildren.item(b).getNodeName() == "Private-Behaviour") continue;
            X73Behavior currentBeh = new X73Behavior();
            currentBeh.setKeynum(behavKeyNumber);
            ++behavKeyNumber;
            for (int l = 0; l < behavChildren.getLength(); ++l) {
                if (behavChildren.item(l).getNodeName().equals("METHOD_NAME")) {
                    currentBeh.setBaseName(behavChildren.item(l).getFirstChild().getNodeValue());
                    continue;
                }
                if (behavChildren.item(l).getNodeName().equals("METHOD_ID")) {
                    currentBeh.setBaseRefId(behavChildren.item(l).getFirstChild().getNodeValue());
                    continue;
                }
                if (behavChildren.item(l).getNodeName().equals("BEHAVIOUR_ACTION_PARAMETER")) {
                    if (behavChildren.item(l).getFirstChild() == null) {
                        currentBeh.setBehaviourActionParameter("");
                        continue;
                    }
                    currentBeh.setBehaviourActionParameter(behavChildren.item(l).getFirstChild().getNodeValue());
                    continue;
                }
                if (behavChildren.item(l).getNodeName().equals("BEHAVIOUR_ACTION_RESULT")) {
                    if (behavChildren.item(l).getFirstChild() == null) {
                        currentBeh.setBehaviourActionResult("");
                        continue;
                    }
                    currentBeh.setBehaviourActionResult(behavChildren.item(l).getFirstChild().getNodeValue());
                    continue;
                }
                if (behavChildren.item(l).getNodeName().equals("TERM_CODE")) {
                    currentBeh.setBaseTermcode(behavChildren.item(l).getFirstChild().getNodeValue());
                    continue;
                }
                if (behavChildren.item(l).getNodeName().equals("Reference")) {
                    currentBeh.setBaseReference(behavChildren.item(l).getFirstChild().getNodeValue());
                    continue;
                }
                if (behavChildren.item(l).getNodeName().equals("Qual")) {
                    currentBeh.setParaMode(behavChildren.item(l).getFirstChild().getNodeValue());
                    continue;
                }
                if (behavChildren.item(l).getNodeName().equals("BEHAVIOUR_RESTRICTIONS")) {
                    if (behavChildren.item(l).getFirstChild() == null) {
                        currentBeh.setExtRestrictions("");
                        continue;
                    }
                    currentBeh.setExtRestrictions(behavChildren.item(l).getFirstChild().getNodeValue());
                    continue;
                }
                if (!behavChildren.item(l).getNodeName().equals("BEHAVIOUR_COMMENT")) continue;
                if (behavChildren.item(l).getFirstChild() == null) {
                    currentBeh.setExtComment("");
                    continue;
                }
                currentBeh.setExtComment(behavChildren.item(l).getFirstChild().getNodeValue());
            }
            curMOC.addBehaviour(currentBeh);
        }
    }

    protected void parseMocNotification(X73DimObject curMOC, Node node) {
        NodeList notiBChildren = node.getChildNodes();
        int notiKeyNumber = 0;
        for (int c = 0; c < notiBChildren.getLength(); ++c) {
            NodeList notiChildren = notiBChildren.item(c).getChildNodes();
            if (notiBChildren.item(c) == null) continue;
            if (notiBChildren.item(c).getNodeType() == 1 && notiBChildren.item(c).getNodeName() == "Private-Notification") {
                NodeList notiPrivateChildren = notiBChildren.item(c).getChildNodes();
                for (int i = 0; i < notiPrivateChildren.getLength(); ++i) {
                    if (notiPrivateChildren.item(i) == null || notiPrivateChildren.item(i).getNodeType() != 1) continue;
                    X73Notification currentNotf = new X73Notification();
                    currentNotf.setKeynum(notiKeyNumber);
                    ++notiKeyNumber;
                    notiChildren = notiPrivateChildren.item(i).getChildNodes();
                    for (int m = 0; m < notiChildren.getLength(); ++m) {
                        if (notiChildren.item(m).getFirstChild() == null) continue;
                        if (notiChildren.item(m).getNodeName().equals("NOTIFICATION_NAME")) {
                            currentNotf.setBaseName(notiChildren.item(m).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (notiChildren.item(m).getNodeName().equals("NOTIFICATION_ID")) {
                            currentNotf.setBaseRefId(notiChildren.item(m).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (notiChildren.item(m).getNodeName().equals("NOTIFICATION_EVENT_PARAMETER")) {
                            if (notiChildren.item(m).getFirstChild() == null) {
                                currentNotf.setNotificationEventParameter("");
                                continue;
                            }
                            currentNotf.setNotificationEventParameter(notiChildren.item(m).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (notiChildren.item(m).getNodeName().equals("NOTIFICATION_EVENT_REPLY")) {
                            if (notiChildren.item(m).getFirstChild() == null) continue;
                            currentNotf.setNotificationEventReply(notiChildren.item(m).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (notiChildren.item(m).getNodeName().equals("TERM_CODE")) {
                            currentNotf.setBaseTermcode(notiChildren.item(m).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (notiChildren.item(m).getNodeName().equals("Reference")) {
                            currentNotf.setBaseReference(notiChildren.item(m).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (notiChildren.item(m).getNodeName().equals("Qual")) {
                            currentNotf.setParaMode(notiChildren.item(m).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (notiChildren.item(m).getNodeName().equals("NOTIFICATION_RESTRICTIONS")) {
                            if (notiChildren.item(m).getFirstChild() == null) {
                                currentNotf.setExtRestrictions("");
                                continue;
                            }
                            currentNotf.setExtRestrictions(notiChildren.item(m).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (!notiChildren.item(m).getNodeName().equals("NOTIFICATION_COMMENT")) continue;
                        if (notiChildren.item(m).getFirstChild() == null) {
                            currentNotf.setExtComment("");
                            continue;
                        }
                        currentNotf.setExtComment(notiChildren.item(m).getFirstChild().getNodeValue());
                    }
                    currentNotf.setPrivate(true);
                    curMOC.addNotification(currentNotf);
                }
                continue;
            }
            if (notiBChildren.item(c).getNodeType() != 1 || notiBChildren.item(c).getNodeName() == "Private-Notification") continue;
            X73Notification currentNotf = new X73Notification();
            currentNotf.setKeynum(notiKeyNumber);
            ++notiKeyNumber;
            for (int m = 0; m < notiChildren.getLength(); ++m) {
                if (notiChildren.item(m).getFirstChild() == null) continue;
                if (notiChildren.item(m).getNodeName().equals("NOTIFICATION_NAME")) {
                    currentNotf.setBaseName(notiChildren.item(m).getFirstChild().getNodeValue());
                    continue;
                }
                if (notiChildren.item(m).getNodeName().equals("NOTIFICATION_ID")) {
                    currentNotf.setBaseRefId(notiChildren.item(m).getFirstChild().getNodeValue());
                    continue;
                }
                if (notiChildren.item(m).getNodeName().equals("NOTIFICATION_EVENT_PARAMETER")) {
                    if (notiChildren.item(m).getFirstChild() == null) {
                        currentNotf.setNotificationEventParameter("");
                        continue;
                    }
                    currentNotf.setNotificationEventParameter(notiChildren.item(m).getFirstChild().getNodeValue());
                    continue;
                }
                if (notiChildren.item(m).getNodeName().equals("NOTIFICATION_EVENT_REPLY")) {
                    if (notiChildren.item(m).getFirstChild() == null) continue;
                    currentNotf.setNotificationEventReply(notiChildren.item(m).getFirstChild().getNodeValue());
                    continue;
                }
                if (notiChildren.item(m).getNodeName().equals("TERM_CODE")) {
                    currentNotf.setBaseTermcode(notiChildren.item(m).getFirstChild().getNodeValue());
                    continue;
                }
                if (notiChildren.item(m).getNodeName().equals("Reference")) {
                    currentNotf.setBaseReference(notiChildren.item(m).getFirstChild().getNodeValue());
                    continue;
                }
                if (notiChildren.item(m).getNodeName().equals("Qual")) {
                    currentNotf.setParaMode(notiChildren.item(m).getFirstChild().getNodeValue());
                    continue;
                }
                if (notiChildren.item(m).getNodeName().equals("NOTIFICATION_RESTRICTIONS")) {
                    if (notiChildren.item(m).getFirstChild() == null) {
                        currentNotf.setExtRestrictions("");
                        continue;
                    }
                    currentNotf.setExtRestrictions(notiChildren.item(m).getFirstChild().getNodeValue());
                    continue;
                }
                if (!notiChildren.item(m).getNodeName().equals("NOTIFICATION_COMMENT")) continue;
                if (notiChildren.item(m).getFirstChild() == null) {
                    currentNotf.setExtComment("");
                    continue;
                }
                currentNotf.setExtComment(notiChildren.item(m).getFirstChild().getNodeValue());
            }
            curMOC.addNotification(currentNotf);
        }
    }

    protected void parseMocUnit(X73DimObject curMOC, Node node) {
        NodeList unitsChildren = node.getChildNodes();
        ArrayList<X73Unit> unitList = new ArrayList<X73Unit>();
        for (int c = 0; c < unitsChildren.getLength(); ++c) {
            if (unitsChildren.item(c) == null) continue;
            X73Unit curUnit = null;
            NodeList unitChildren = unitsChildren.item(c).getChildNodes();
            if (unitsChildren.item(c).getNodeType() != 1) continue;
            curUnit = new X73Unit();
            for (int m = 0; m < unitChildren.getLength(); ++m) {
                if (unitChildren.item(m).getFirstChild() == null) continue;
                if (unitChildren.item(m).getNodeName().equals("DIM")) {
                    curUnit.setDim(unitChildren.item(m).getFirstChild().getNodeValue());
                    continue;
                }
                if (unitChildren.item(m).getNodeName().equals("UOM_MDC")) {
                    curUnit.setUom_mdc(unitChildren.item(m).getFirstChild().getNodeValue());
                    continue;
                }
                if (unitChildren.item(m).getNodeName().equals("UOM_UCUM")) {
                    curUnit.setUom_ucum(unitChildren.item(m).getFirstChild().getNodeValue());
                    continue;
                }
                if (!unitChildren.item(m).getNodeName().equals("TERM_CODE")) continue;
                curUnit.setTerm_code(unitChildren.item(m).getFirstChild().getNodeValue());
            }
            unitList.add(curUnit);
        }
        ((X73Numeric)curMOC).setUnitList(unitList);
    }

    protected X73DimObject processNode(X73DimObject currentMoc, Node inNode) {
        if (inNode.getNodeName().equals("External-MOC")) {
            return this.newInstance(inNode);
        }
        boolean isNewMoc = false;
        if (inNode.getNodeName().equals("Attribute_Info")) {
            this.parseMocAttribute(currentMoc, inNode);
        } else if (inNode.getNodeName().equals("Behaviour_Info")) {
            this.parseMocBehavoir(currentMoc, inNode);
        } else if (inNode.getNodeName().equals("Notification_Info")) {
            this.parseMocNotification(currentMoc, inNode);
        } else if (inNode.getNodeName().equals("Units")) {
            this.parseMocUnit(currentMoc, inNode);
        } else {
            isNewMoc = this.parseMoc(currentMoc, inNode);
        }
        if (isNewMoc) {
            return this.newInstance(inNode);
        }
        return null;
    }
}

