/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.deviceProfile.domain.x73.dim.entities;

import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimObject;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@Entity
@Table(name="cardinalities")
public class EntiCardinality
implements Serializable,
Cloneable {
    @Column(name="cardinality", length=50)
    private String cardinality = "";
    @JoinColumn(name="child_id", nullable=false)
    private DimObject childObject;
    @Column(name="device_type", length=10)
    private String device_type = "";
    @Id
    @Column(name="id", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    private Integer id;
    @JoinColumn(name="parent_id", nullable=false)
    private DimObject parentObject;

    public EntiCardinality() {
    }

    public EntiCardinality(DimObject obj, DimObject sub) {
        this.setParentObject(obj);
        this.setChildObject(sub);
    }

    public Object clone() throws CloneNotSupportedException {
        EntiCardinality retCard = new EntiCardinality();
        DimObject child = new DimObject();
        child.setId(this.childObject.getId());
        child.setName(this.childObject.getName());
        child.setRefid(this.childObject.getRefid());
        DimObject parent = new DimObject();
        parent.setId(this.parentObject.getId());
        parent.setName(this.parentObject.getName());
        parent.setRefid(this.parentObject.getRefid());
        retCard.setCardinality(this.cardinality);
        retCard.setChildObject(child);
        retCard.setParentObject(parent);
        return retCard;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            EntiCardinality _card = (EntiCardinality)obj;
            if (this.getChildObject().getName().equals(_card.getChildObject().getName()) && this.getParentObject().getName().equals(_card.getParentObject().getName())) {
                return true;
            }
        }
        return false;
    }

    public String getCardinality() {
        return this.cardinality;
    }

    public DimObject getChildObject() {
        return this.childObject;
    }

    public String getDevice_type() {
        return this.device_type;
    }

    public Integer getId() {
        return this.id;
    }

    public DimObject getParentObject() {
        return this.parentObject;
    }

    public void setCardinality(String cardinality) {
        this.cardinality = cardinality;
    }

    public void setChildObject(DimObject childObject) {
        this.childObject = childObject;
    }

    public void setDevice_type(String device_type) {
        this.device_type = device_type;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setParentObject(DimObject parentObject) {
        this.parentObject = parentObject;
    }

    public String toString() {
        return this.getParentObject().getName() + "  " + this.getChildObject().getName() + "  " + this.getCardinality();
    }
}

