/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.deviceProfile.domain.device.object;

import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceUnit;
import gov.nist.healthcare.deviceProfile.domain.x73.rosetta.ICSEnum;
import gov.nist.healthcare.deviceProfile.domain.x73.rosetta.ICSEnumGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"enumGroup", "description", "enumValues"})
public class DeviceEnumGroup
implements Serializable {
    private String description;
    private String enumGroup;
    private List<String> enumValues;

    public DeviceEnumGroup() {
    }

    public DeviceEnumGroup(ICSEnumGroup icsGroup) {
        this.enumGroup = icsGroup.getEnum_group();
        this.description = icsGroup.getDescription();
        for (ICSEnum icsEnum : icsGroup.getEnums()) {
            String ret = this.getEnumValue(icsEnum);
            if (ret == null || ret.equals("") || this.getEnumValues().contains(ret)) continue;
            this.getEnumValues().add(ret);
        }
    }

    public DeviceEnumGroup(List<ICSEnum> enumList) {
        for (ICSEnum icsEnum : enumList) {
            String ret = this.getEnumValue(icsEnum);
            if (ret == null || ret.equals("") || this.getEnumValues().contains(ret)) continue;
            this.getEnumValues().add(ret);
        }
    }

    public DeviceEnumGroup(String enumGp, List<String> enumValues) {
        this.enumGroup = enumGp;
        this.enumValues = enumValues;
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o != null && o instanceof DeviceUnit && ((DeviceEnumGroup)o).getEnumGroup().equals(this.getEnumGroup())) {
            return true;
        }
        return ret;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEnumGroup() {
        return this.enumGroup;
    }

    public List<String> getEnumValues() {
        if (this.enumValues == null) {
            this.enumValues = new ArrayList<String>();
        }
        return this.enumValues;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnumGroup(String enumGroup) {
        this.enumGroup = enumGroup;
    }

    public void setEnumValues(List<String> enumValues) {
        this.enumValues = enumValues;
    }

    public String toSting() {
        return this.enumGroup;
    }

    private String getEnumValue(ICSEnum icsEnum) {
        String ret = null;
        String token = icsEnum.getToken();
        String refid = icsEnum.getRefid();
        ret = token != null && !token.equals("") ? token : refid;
        return ret;
    }
}

