/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.mdc.icsgenerator.control;

import gov.nist.healthcare.mdc.framework.action.ApplicationAction;
import gov.nist.healthcare.mdc.framework.lifecycle.AppLifecycleImpl;
import gov.nist.healthcare.mdc.framework.lifecycle.ApplicationLifeCycle;
import gov.nist.healthcare.mdc.icsgenerator.control.view.ICSViewController;
import java.awt.event.ActionEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;

public class ICSLifecycle
extends AppLifecycleImpl
implements ApplicationLifeCycle {
    private static final Logger log = Logger.getLogger(ICSLifecycle.class.getName());
    protected ICSViewController moduleControl;
    TimerTask task;
    Timer timer = new Timer();

    public ICSViewController getFrameControl() {
        return this.moduleControl;
    }

    @Override
    public void initialize() {
        this.moduleControl.initialize();
        super.initialize();
    }

    @Override
    public void launch() {
        super.launch();
        this.setActionMap();
        this.moduleControl = ICSViewController.getInstance();
        this.initialize();
    }

    @Override
    public void ready() {
        super.ready();
    }

    @Override
    public void refresh() {
        int s = 500;
        if (this.task != null) {
            this.task.cancel();
            this.timer.purge();
        }
        this.task = new RefreshTask();
        this.timer.schedule(this.task, s);
        super.refresh();
    }

    @Override
    public void reset() {
        this.moduleControl.reset();
        super.reset();
    }

    public void setActionMap() {
        ApplicationAction.actionMap.put("Views", new AbstractAction("Views"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ICSLifecycle.this.addRemoveModuleTabPanel(e);
            }
        });
    }

    private void addRemoveModuleTabPanel(ActionEvent e) {
        AbstractButton ab = (AbstractButton)e.getSource();
        String moduleTitle = ab.getText();
        this.moduleControl.showView(moduleTitle);
    }

    class RefreshTask
    extends TimerTask {
        RefreshTask() {
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    log.info("Refresh Task");
                    ICSLifecycle.this.moduleControl.refresh();
                }
            });
        }
    }
}

