/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.common;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class XmlXsltTool {
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public boolean bValidationError = false;
    public Document document;
    public SAXParseException saxParseException = null;

    public static String DomToString(Document doc) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamResult result2 = new StreamResult(stream);
            XmlXsltTool.domTransfer(new DOMSource(doc), result2);
            return stream.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void domTransfer(DOMSource source, StreamResult result2) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result2);
    }

    public void domToFile(Document doc, File file) {
        try {
            XmlXsltTool.domTransfer(new DOMSource(doc), new StreamResult(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void domTransform(Source source, String styleSheet, Result result) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            File fStyleSheet = new File(styleSheet);
            StreamSource styleSource = new StreamSource(fStyleSheet);
            Transformer transformer = factory.newTransformer(styleSource);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getStringDocumentDoubleTransformedFromDom(Document doc, String styleSheet1, String styleSheet2) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.printDocumentDoubleTransformedFromDom(doc, styleSheet1, styleSheet2, new StreamResult(stream));
        return stream.toString();
    }

    public String getStringDocumentTransformed(String dataSrc, String styleSheet) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.printDocumentTransformed(dataSrc, styleSheet, new StreamResult(stream));
        return stream.toString();
    }

    public String getStringDocumentTransformedFromDoc(Document doc, String styleSheet) {
        this.document = doc;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.printDocumentTransformedFromDoc(doc, styleSheet, new StreamResult(stream));
        return stream.toString();
    }

    public String getStringDocumentTransformedFromStringXML(String dataSrc, String styleSheet) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.printDocumentTransformedFromXMLString(dataSrc, styleSheet, new StreamResult(stream));
        return stream.toString();
    }

    public void printDocument() {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(System.out);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printDocumentDoubleTransformed(String dataSrc, String styleSheet1, String styleSheet2, StreamResult result) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(dataSrc));
            InputSource input = new InputSource(bis);
            SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            File fStyleSheet1 = new File(styleSheet1);
            File fStyleSheet2 = new File(styleSheet2);
            StreamSource styleSource1 = new StreamSource(fStyleSheet1);
            StreamSource styleSource2 = new StreamSource(fStyleSheet2);
            XMLFilter filter1 = factory.newXMLFilter(styleSource1);
            XMLFilter filter2 = factory.newXMLFilter(styleSource2);
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            filter1.setParent(reader);
            filter2.setParent(filter1);
            Transformer transformer = factory.newTransformer();
            SAXSource transformSource = new SAXSource(filter2, input);
            transformer.transform(transformSource, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printDocumentDoubleTransformedFromDom(Document doc, String styleSheet1, String styleSheet2, StreamResult result) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            File fStyleSheet1 = new File(styleSheet1);
            StreamSource styleSource1 = new StreamSource(fStyleSheet1);
            XMLFilter filter1 = factory.newXMLFilter(styleSource1);
            filter1.setParent(reader);
            File fStyleSheet2 = new File(styleSheet2);
            StreamSource styleSource2 = new StreamSource(fStyleSheet2);
            XMLFilter filter2 = factory.newXMLFilter(styleSource2);
            filter2.setParent(filter1);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer1 = tFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamResult result2 = new StreamResult(stream);
            transformer1.transform(source, result2);
            String str = stream.toString();
            str = str.replaceFirst("<DIM xmlns=\"http://www.nist.X73.gov\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-Instance\" xsi:noNameSpaceLocation=\"c:/ICS/xml/ICS-Tool$$.xsd\">", "<DIM>");
            InputSource input = new InputSource(new StringReader(str));
            Transformer transformer = factory.newTransformer();
            SAXSource transformSource = new SAXSource(filter2, input);
            transformer.transform(transformSource, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printDocumentTransformed(String xmlFilenName, String styleSheet, StreamResult result) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            File fStyleSheet = new File(styleSheet);
            StreamSource styleSource = new StreamSource(fStyleSheet);
            Transformer transformer = factory.newTransformer(styleSource);
            DOMSource source = new DOMSource(this.xmlFileToDom(xmlFilenName));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printDocumentTransformedFromDoc(Document doc, String styleSheet, StreamResult result) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            File fStyleSheet = new File(styleSheet);
            StreamSource styleSource = new StreamSource(fStyleSheet);
            Transformer transformer = factory.newTransformer(styleSource);
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printDocumentTransformedFromXMLString(String XMLSrc, String styleSheet, StreamResult result) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            File fStyleSheet = new File(styleSheet);
            this.xmlStringToDom(XMLSrc);
            StreamSource styleSource = new StreamSource(fStyleSheet);
            Transformer transformer = factory.newTransformer(styleSource);
            DOMSource source = new DOMSource(this.document);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public void saveDocumentTransformed(String dataSrc, String styleSheet, String fileName) {
        this.printDocumentTransformed(dataSrc, styleSheet, new StreamResult(new File(fileName)));
    }

    public Document xmlFileToDom(String fileName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            File file = new File(fileName);
            Document document = builder.parse(file);
            return document;
        }
        catch (SAXParseException spe) {
        }
        catch (SAXException sxe) {
        }
        catch (ParserConfigurationException pce) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Document xmlInputStreamToDom(InputStream strXML) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(strXML);
            return document;
        }
        catch (SAXParseException spe) {
        }
        catch (SAXException sxe) {
        }
        catch (ParserConfigurationException pce) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Document xmlStringToDom(String strXML) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(strXML);
            return document;
        }
        catch (SAXParseException spe) {
        }
        catch (SAXException sxe) {
        }
        catch (ParserConfigurationException pce) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

