/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.deviceProfile.domain.x73.dim.entities;

import gov.nist.healthcare.deviceProfile.domain.x73.dim.DimCommonObject;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimAttribute;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimBehavior;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.DimNotification;
import gov.nist.healthcare.deviceProfile.domain.x73.dim.entities.EntiCardinality;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlType(name="DimObject", propOrder={"id", "name", "refid", "termcode", "clause", "derived_from", "name_binding", "obj_abstract", "obj_package", "dimAttributes", "dimBehaviors", "dimNotifications", "cardinalities"})
@Entity
@Table(name="dimobjects")
public class DimObject
implements DimCommonObject {
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, mappedBy="parentObject", fetch=FetchType.EAGER)
    private List<EntiCardinality> cardinalities = new ArrayList<EntiCardinality>();
    @Column(name="object_clause", length=100, nullable=true)
    private String clause;
    @Column(name="derived_from", length=100, nullable=true)
    private String derived_from;
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="objects_attributes", joinColumns={@JoinColumn(name="obj_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="attribute_id", referencedColumnName="id")})
    private List<DimAttribute> dimAttributes = new ArrayList<DimAttribute>();
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="objects_behaviors", joinColumns={@JoinColumn(name="obj_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="behavior_id", referencedColumnName="id")})
    private List<DimBehavior> dimBehaviors = new ArrayList<DimBehavior>();
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="objects_notifications", joinColumns={@JoinColumn(name="obj_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="notification_id", referencedColumnName="id")})
    private List<DimNotification> dimNotifications = new ArrayList<DimNotification>();
    @Id
    @Column(name="id", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    private Integer id;
    @Column(name="object_name", length=300, nullable=true)
    private String name;
    @Column(name="name_binding", length=100, nullable=true)
    private String name_binding;
    @Column(name="abstract", length=10, nullable=true)
    private String obj_abstract;
    @Column(name="package", length=100, nullable=true)
    private String obj_package;
    @Column(name="object_reference_id", length=300, nullable=true)
    private String refid;
    @Column(name="object_termcode", length=100, nullable=true)
    private String termcode;

    public DimObject() {
        this("", "");
    }

    public DimObject(String name) {
        this.setName(name);
        this.setRefid("");
    }

    public DimObject(String name, String refid) {
        this.setName(name);
        this.setRefid(refid);
    }

    public void addCardinality(EntiCardinality _card) {
        if (!this.cardinalities.contains(_card)) {
            this.cardinalities.add(_card);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DimObject objClone = (DimObject)super.clone();
        objClone.setDimAttributes(new ArrayList<DimAttribute>());
        for (DimAttribute attr : this.dimAttributes) {
            objClone.getDimAttributes().add((DimAttribute)attr.clone());
        }
        objClone.setDimBehaviors(new ArrayList<DimBehavior>());
        for (DimBehavior behv : this.dimBehaviors) {
            objClone.getDimBehaviors().add((DimBehavior)behv.clone());
        }
        objClone.setDimNotifications(new ArrayList<DimNotification>());
        for (DimNotification notif : this.dimNotifications) {
            objClone.getDimNotifications().add((DimNotification)notif.clone());
        }
        objClone.setCardinalities(new ArrayList<EntiCardinality>());
        for (EntiCardinality card : this.cardinalities) {
            EntiCardinality cloneCard = (EntiCardinality)card.clone();
            objClone.getCardinalities().add(cloneCard);
        }
        return objClone;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            DimObject x73obj = (DimObject)obj;
            if (this.getName().equals(x73obj.getName()) && this.getRefid().equals(x73obj.getRefid()) && this.getTermcode().equals(x73obj.getTermcode())) {
                return true;
            }
        }
        return false;
    }

    @XmlElementWrapper(name="cards")
    @XmlElement(name="card")
    public List<EntiCardinality> getCardinalities() {
        return this.cardinalities;
    }

    @Override
    public String getClause() {
        return this.clause;
    }

    public String getDerived_from() {
        return this.derived_from;
    }

    @XmlElementWrapper(name="dim_attributes")
    @XmlElement(name="dim_attribute")
    public List<DimAttribute> getDimAttributes() {
        return this.dimAttributes;
    }

    @XmlElementWrapper(name="dim_behaviors")
    @XmlElement(name="dim_behavior")
    public List<DimBehavior> getDimBehaviors() {
        return this.dimBehaviors;
    }

    @XmlElementWrapper(name="dim_notifications")
    @XmlElement(name="dim_notification")
    public List<DimNotification> getDimNotifications() {
        return this.dimNotifications;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getName_binding() {
        return this.name_binding;
    }

    public String getObj_abstract() {
        return this.obj_abstract;
    }

    public String getObj_package() {
        return this.obj_package;
    }

    @Override
    public String getRefid() {
        return this.refid;
    }

    @Override
    public String getTermcode() {
        return this.termcode;
    }

    public void setCardinalities(List<EntiCardinality> cardinalities) {
        this.cardinalities = cardinalities;
    }

    @Override
    public void setClause(String object_clause) {
        this.clause = object_clause;
    }

    public void setDerived_from(String derived_from) {
        this.derived_from = derived_from;
    }

    public void setDimAttributes(List<DimAttribute> _dimAttributes) {
        this.dimAttributes = _dimAttributes;
    }

    public void setDimBehaviors(List<DimBehavior> _dimBehaviors) {
        this.dimBehaviors = _dimBehaviors;
    }

    public void setDimNotifications(List<DimNotification> _dimNotifications) {
        this.dimNotifications = _dimNotifications;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public void setName(String object_name) {
        this.name = object_name;
    }

    public void setName_binding(String name_binding) {
        this.name_binding = name_binding;
    }

    public void setObj_abstract(String obj_abstract) {
        this.obj_abstract = obj_abstract;
    }

    public void setObj_package(String obj_package) {
        this.obj_package = obj_package;
    }

    @Override
    public void setRefid(String object_reference_id) {
        this.refid = object_reference_id;
    }

    @Override
    public void setTermcode(String object_termcode) {
        this.termcode = object_termcode;
    }

    public String toDump() {
        return new String("=>" + this.getName() + "\t\t" + this.getRefid() + "\t\t" + this.getTermcode() + "\t\t" + this.getClause() + "\t\t" + this.derived_from + "<=");
    }

    public String toString() {
        return this.getName();
    }

    public void toSystemOut() {
        System.out.format("%-35s %-45s %-10s %-10s %-10s %-10s %-10s %-10s %n", this.getName(), this.getRefid(), this.getTermcode(), this.getClause(), this.derived_from, this.name_binding, this.obj_abstract, this.obj_package);
    }
}

