/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.deviceProfile.domain.device.object;

import gov.nist.healthcare.deviceProfile.domain.device.object.DeviceUnit;
import gov.nist.healthcare.deviceProfile.domain.x73.rosetta.ICSUnit;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"unitGroup", "units"})
public class DeviceUnitGroup {
    private String unitGroup;
    private List<DeviceUnit> units = new ArrayList<DeviceUnit>();

    public static DeviceUnit MDUnitFactory(ICSUnit u) {
        DeviceUnit unit = new DeviceUnit();
        unit.setCFUCODE10(u.toCFCode());
        unit.setUOMMDC(u.getRefid());
        unit.setUOMUCUM(u.getUcums());
        return unit;
    }

    public static List<DeviceUnit> MDUnitFactory(List<ICSUnit> units) {
        ArrayList<DeviceUnit> ret = new ArrayList<DeviceUnit>();
        for (ICSUnit unit : units) {
            DeviceUnit mdUnit = DeviceUnitGroup.MDUnitFactory(unit);
            if (ret.contains(mdUnit)) continue;
            ret.add(mdUnit);
        }
        return ret;
    }

    public DeviceUnitGroup() {
    }

    public DeviceUnitGroup(List<ICSUnit> icsUnits) {
        for (DeviceUnit mdUnit : DeviceUnitGroup.MDUnitFactory(icsUnits)) {
            if (this.units.contains(mdUnit)) continue;
            this.units.add(mdUnit);
        }
    }

    public DeviceUnitGroup(String unitGroup, List<DeviceUnit> units) {
        this.unitGroup = unitGroup;
        this.units = units;
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o != null && o instanceof DeviceUnit && ((DeviceUnitGroup)o).getUnitGroup().equals(this.getUnitGroup())) {
            return true;
        }
        return ret;
    }

    public String getUnitGroup() {
        return this.unitGroup;
    }

    public List<DeviceUnit> getUnits() {
        return this.units;
    }

    public void setUnitGroup(String unitGroup) {
        this.unitGroup = unitGroup;
    }

    public void setUnits(List<DeviceUnit> units) {
        this.units = units;
    }

    public String toString() {
        return this.unitGroup;
    }
}

