/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.healthcare.dev.profile.common;

import java.awt.Image;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class ResourceManager {
    private static final Logger log = Logger.getLogger(ResourceManager.class.getName());
    protected ClassLoader ResourceControllerClassLoader = this.getClass().getClassLoader();
    protected ResourceBundle rssBundle;

    public static ResourceManager newInstance() {
        return new ResourceManager();
    }

    public static ResourceBundle GetRssBundle(String path) {
        try {
            return ResourceBundle.getBundle(path);
        }
        catch (MissingResourceException e) {
            log.info("Can't locate resource " + path);
            return null;
        }
    }

    public static ResourceManager newInstance(String path) {
        ResourceManager instance = ResourceManager.newInstance();
        ResourceBundle rss = ResourceManager.GetRssBundle(path);
        if (rss != null) {
            instance.setRssBundle(rss);
            return instance;
        }
        return null;
    }

    public Image getImage(String key) {
        return this.getImageIcon(key).getImage();
    }

    public ImageIcon getImageIcon(String key) {
        String path = this.rssBundle.getString(key);
        return new ImageIcon(this.ResourceControllerClassLoader.getResource(path));
    }

    public InputStream getInputStream(String path) {
        return this.ResourceControllerClassLoader.getResourceAsStream(path);
    }

    public ResourceBundle getRssBundle() {
        return this.rssBundle;
    }

    public String getBundleTxt(String resourceText) {
        return this.rssBundle.getString(resourceText);
    }

    public void setRssBundle(ResourceBundle rssBundle) {
        this.rssBundle = rssBundle;
    }
}

