package modifyIcs;

import icsDyn.MVCArg;
import icsTables.ErrorDialog;
import icsTables.ICSTableModel;
import icsTables.XMlXSLTClass;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JPanel;

import org.w3c.dom.Document;

public abstract class ICSViewPanel extends JPanel implements Observer {
	
    public ICSDocuments icsDocs;
    protected JPanelLoad jPanelLoad;
    protected JPanelICSTable jPanelICSTable;
    protected JPanelGeneration jPanelGen;
    protected Document doc;
    protected ICSTableModel icsTable;
    
    protected String schemaSource = "C:\\ICS\\xsd\\GeneralICS.xsd";
    
    /** Creates a new instance*/
    public ICSViewPanel() { 
    	
    }
    /**
     * setICSDocs
     * @param obj
     */
     public void setICSDocs(ICSDocuments obj)
    {
        icsDocs = obj;
        icsDocs.addObserver(this);
        jPanelLoad.setICSDocs(icsDocs);
        jPanelGen.setICSDocs(icsDocs);
    }
     /**
      * initComponants
      *
      */
    protected void initComponants()
    {
        java.awt.GridBagConstraints gridBagConstraints;
        setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;


         jPanelLoad = new JPanelLoad(icsTable);
         add(jPanelLoad, gridBagConstraints);


         gridBagConstraints = new java.awt.GridBagConstraints();
         gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
         gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
         gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
         gridBagConstraints.weightx = 1.0;
         gridBagConstraints.weighty = 3.0;
         
         jPanelICSTable = new JPanelICSTable();
         add(jPanelICSTable, gridBagConstraints);
         
         jPanelGen = new JPanelGeneration();
    }
    /**
     * 
     * @see Observer#update(java.util.Observable, java.lang.Object)
     */
    public void update(Observable o, Object arg) {
         if(o instanceof ICSDocuments) {	
		    if(arg instanceof MVCArg) {
		        if("save".equals(((MVCArg)arg).getName())) {
		           doc = jPanelICSTable.saveTable();
		           jPanelGen.setDocument(doc);
		           icsDocs.setDocGeneral(doc);
		        }
		        if("xmlFile".equals(((MVCArg)arg).getName()))
                {
                	Object obj = ((MVCArg)arg).getOValue();
                	File xmlFile = (File) obj;
                	XMlXSLTClass xClass = new XMlXSLTClass();
                	boolean validate = false;
                	Vector Error;
                	Error = xClass.XmlFileValidate(xmlFile, schemaSource);
                	if(Error.size() == 0)
                		validate =true;
                	if(validate)
                	{
                		jPanelLoad.disableButtons();
                		icsTable.setDocumentFromXML(xmlFile.getAbsolutePath());
                		doc = icsTable.getDocument();
                		icsDocs.setDocService(doc);
                		addGenerationPanel();
                	}
                	else
                	{
                		//error message
                		
                		ErrorMessage(xmlFile.getAbsolutePath(),Error);
                	}
                }
	        }
        }
    }
    
    /**
     * ErrorMessage
     * @param message
     */
    public void ErrorMessage(String message, Vector error)
    {
    	ErrorDialog d = new ErrorDialog(this, message, error);
    	d.setVisible(true);
        jPanelLoad.init();
        doc = null;
    }
    
    abstract public void addGenerationPanel();
    
}

