/**
 *	ICSDocuments	
 * @author maria
 */

package modifyIcs;

import icsDyn.MVCArg;
import java.io.File;
import java.util.Observable;
import org.w3c.dom.Document;


/**
 * @author  maria
 */
public class ICSDocuments extends Observable
{
    
    /**
	 * @uml.property  name="doc"
	 */
    private Document doc;
    /**
	 * @uml.property  name="docGeneral"
	 */
    private Document docGeneral;
    /**
	 * @uml.property  name="docService"
	 */
    private Document docService;
    /**
	 * @uml.property  name="xMLFile"
	 */
    private Document docTransport;
    private File XMLFile;
	   
	/** Creates a new instance of ICSDocuments */
	public ICSDocuments() {
	}
	/**
	* Fire an event
	* @param arg An MVCArg object
	*/
	public void fireEvent(MVCArg arg) {
        setChanged();
        notifyObservers(arg);
    }
	/**
	 * setDoc
	 * @param  docIn
	 * @uml.property  name="doc"
	 */
	public void setDoc(Document docIn)
	{
       doc = docIn;
       setChanged();
       notifyObservers(new MVCArg("updateDoc", doc));
	}
	/**
	 * setXMLFile
	 * @param  file
	 * @uml.property  name="xMLFile"
	 */
	public void setXMLFile(File file)
	{
		XMLFile = file;
		setChanged();
		notifyObservers(new MVCArg("xmlFile", XMLFile));
	}
	/**
	 * setDocGeneral
	 * @param  docGen
	 * @uml.property  name="docGeneral"
	 */
	public void setDocGeneral(Document docGen)
	{
       docGeneral = docGen;
       setChanged();
       notifyObservers(new MVCArg("updateDocGeneral", docGeneral));
	}
	/**
	 * setDocService
	 * @param  docSrv
	 * @uml.property  name="docService"
	 */
	public void setDocService(Document docSrv)
	{
       docService = docSrv;
       setChanged();
       notifyObservers(new MVCArg("updateDocService", docService));
	}
	public void setDocTransport(Document docT)
	{
       docTransport = docT;
       setChanged();
       notifyObservers(new MVCArg("updateDocService", docService));
	}
	/**
	 * setDocument
	 * @param tableTitle
	 * @param document
	 */
	public void setDocument(String tableTitle, Document document)
	{
       if(tableTitle == "doc")
               setDoc(document);
       else if(tableTitle == "General ICS")
               setDocGeneral(document);
       else if(tableTitle == "Service Support ICS")
               setDocService(document);
       else if(tableTitle == "Transport ICS")
           setDocTransport(document);
   	}
	/**
	 * setSave
	 *
	 */
	public void setSave()
	{
       setChanged();
       notifyObservers(new MVCArg("save", true));
  	 }
	/**
	 * getDoc
	 * @return
	 * @uml.property  name="doc"
	 */
	public Document getDoc()
	{
       return doc;
	}
	/**
	 * getDocGeneral
	 * @return
	 * @uml.property  name="docGeneral"
	 */
	public Document getDocGeneral()
	{
       return docGeneral;
	}
	/**
	 * getDocService
	 * @return
	 * @uml.property  name="docService"
	 */
	public Document getDocService()
  	{
       return docService;
  	}
	/**
	 * getXMLFile
	 * @return
	 * @uml.property  name="xMLFile"
	 */
	public File getXMLFile()
	{
		return XMLFile;
	}
}
