package drawing;

import icsDyn.MVCArg;
import icsTables.HTMLFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import modifyIcs.ICSDocuments;
import org.w3c.dom.Document;

/**
 * this class manages the uml diagram drawing feature
 * @author  maria
 */
public class DrawingView  extends JPanel implements ActionListener, Observer{
	/**
	 * the parent frame
	 */
	private JFrame parent;
	private JButton btnDraw;
	private JButton btnSave;
	private ScrollablePicture picture;
	private JScrollPane pnlButtom;
	/**
	 * the dom document representing the JTree
	 */
	private Document doc;
	
	private BuilderDiagram builder;
	private JComboBox cbRoot;

	/**
	 * constructor
	 * @param p
	 */
	public DrawingView(JFrame p){
		super();
		parent = p;
		initComponents();
	}
	/**
	 * initializes the components
	 *
	 */
	private void initComponents(){
		setLayout(new BorderLayout());
		
		//the top panel
		JPanel pnlTop = new JPanel();
		pnlTop.setLayout(new BoxLayout(pnlTop, BoxLayout.LINE_AXIS));
		pnlTop.setBorder(BorderFactory.createEmptyBorder(20,20,20,20));
		
		//combobox
		cbRoot = new JComboBox();
		cbRoot.addActionListener(this);
		
		//label
		JLabel label = new JLabel("Select a root :");
		
		
		//drawing button
		btnDraw = new JButton("Draw UML Diagram");
		btnDraw.setBackground(new Color(204, 204, 255));
		btnDraw.addActionListener(this);
		btnDraw.setEnabled(false);
		
		//saving button
		btnSave = new JButton("Export image...");
		btnSave.setBackground(new Color(204, 204, 255));
		btnSave.addActionListener(this);
		btnSave.setEnabled(false);
		
		pnlTop.add(label);
		pnlTop.add(Box.createRigidArea(new Dimension(20, 0)));
		pnlTop.add(cbRoot);
		pnlTop.add(Box.createRigidArea(new Dimension(20, 0)));
		pnlTop.add(btnDraw);
		pnlTop.add(Box.createRigidArea(new Dimension(20, 0)));
		pnlTop.add(btnSave);
		
		add(pnlTop, BorderLayout.PAGE_START);
		
		pnlButtom = new JScrollPane();
		add(pnlButtom, BorderLayout.CENTER);
	}
	
	/**
	 * @see ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent arg0) {
		if(arg0.getSource() == btnDraw)
		{
			btnSave.setEnabled(true);
			draw();
		}
		else if(arg0.getSource() == btnSave){
			JFileChooser chooser = new javax.swing.JFileChooser();
	        //chooser.setApproveButtonText("Save");
	        chooser.setDialogType(JFileChooser.SAVE_DIALOG);
	        chooser.setCurrentDirectory(new File("C:\\ICS"));
	        chooser.setFileFilter(new PNGFileFilter());
	        int returnVal = chooser.showSaveDialog(this);
	        if( returnVal == JFileChooser.APPROVE_OPTION)
	        {
	        try{
	                boolean save = true;
	                File selFile = chooser.getSelectedFile();
	                if(!selFile.getPath().endsWith(".png"))
	                    selFile = new File(selFile.getPath() + ".png");
	                if(selFile.exists())
	                {
	                   save = false;     
	                   returnVal = JOptionPane.showConfirmDialog(chooser, selFile.getAbsolutePath()+" already exists. Do you want to replace it?","Warning",JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
	                   if(returnVal == JOptionPane.OK_OPTION)
	                       save = true;
	                }
	                if(save)
	                {
	                    builder.dia.save(selFile, "png");
	                }
	            }
	            catch(Exception e)
	            {
	                e.printStackTrace();
	            }
	        }        
		}
		
		
	}
	/**
	 * @see Observer#update(java.util.Observable, java.lang.Object)
	 */
	public void update(Observable o, Object arg) {
		 if(o instanceof ICSDocuments) 
	        {
	            if(arg instanceof MVCArg) 
	            {
	                if("updateDoc".equals(((MVCArg)arg).getName())) 
	                {			
	                    Object obj = ((MVCArg)arg).getOValue();
	                    doc = (Document) obj;
	                    btnDraw.setEnabled(true);
	                    builder = new BuilderDiagram(doc);
	                    Vector list = builder.dia.getClassNames();
	                    cbRoot.setModel(new DefaultComboBoxModel(list));
	                    cbRoot.setSelectedIndex(list.indexOf("DIM"));
	                }
	            }
	        }
		
	}
	/**
	 * draws the diagram
	 *
	 */
	private void draw(){
		builder.dia.draw(cbRoot.getSelectedItem().toString());
		Image im = builder.dia.img;
		//im = im.getScaledInstance(1800, 500, Image.SCALE_SMOOTH);
		picture = new ScrollablePicture(new ImageIcon(im) , 1);
		pnlButtom.setViewportView(picture);
		pnlButtom.validate();
	}

}
