
package icsTables;

import icsDyn.*;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import modifyIcs.ICSDocuments;
import org.w3c.dom.Document;

/**
 * JPanelICSTables represents the specific panel for ICS Tables in the ICSManagement View 
 * @author   maria
 */
public class ViewICSTablesPanel extends JPanel implements Observer 
{	
	private JButton btnViewTables;
	private ICSManagementView parentView;
    private Document doc;
    private Document docGeneral;
    private Document docService;
    private ICSDocuments icsDocs;
    
    /**
     * creates new instance of JPanelICSTables
     * @param parentIn
     */
	public ViewICSTablesPanel(ICSManagementView parentIn)
	{
		super();
        parentView = parentIn;
        initComponents();
        docGeneral = null;
        docService = null;
                
	}
     /**
      * initComponents,
      * initialize the components
      *
      */  
	 private void initComponents() 
	 {
        setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));

        JPanel p0 = new JPanel();
        p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));

        JLabel lbl = new JLabel("ICS Tables:");
	    p0.add(lbl);
	    p0.add(Box.createRigidArea(new Dimension(10, 0)));	
	    btnViewTables = new JButton("View...");
	    btnViewTables.setBackground(new Color(204, 204, 255));
	    p0.add(btnViewTables);
	    btnViewTables.addMouseListener(new java.awt.event.MouseAdapter() {
	        public void mousePressed(java.awt.event.MouseEvent evt) {
	            btnViewTableMousePressed(evt);
		}
		});	
		add(p0);
		setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        
		btnViewTables.setEnabled(false);
     }
	 /**
	  * btnViewTableMousePressed
	  * @param evt
	  */
     private void btnViewTableMousePressed(MouseEvent evt) 
     {
        if(btnViewTables.isEnabled())
        {
//            parentView.igp.generateXML();
//            doc = parentView.igp.doc;
//            parentView.im.fireEvent(new MVCArg("generateXML", doc));

            new ICSSelectorFrame(parentView, doc, docGeneral, docService).setVisible(true);
        }
      }
     /**
      * update
      */
	public void update(Observable o, Object arg) 
	{
		if(o instanceof ICSModel) 
        {
		   if(arg instanceof MVCArg) 
           {
                if("mdsType".equals(((MVCArg)arg).getName())) 
                {			
                    btnViewTables.setEnabled(true);
                }
                if("NewDom".equals(((MVCArg)arg).getName())) {
                	doc = parentView.igp.doc;                   
	                icsDocs.setDoc(doc);
                }
		   }
        }
        if(o instanceof ICSDocuments) 
        {
            if(arg instanceof MVCArg) 
            {
                if("updateDocGeneral".equals(((MVCArg)arg).getName())) 
                {			
                    Object obj = ((MVCArg)arg).getOValue();
                    docGeneral = (Document) obj;
                }
                if("updateDocService".equals(((MVCArg)arg).getName())) 
                {			
                	Object obj = ((MVCArg)arg).getOValue();
                	docService = (Document) obj;
                }
            }
	    }
		
	}
	/**
	 * setICSDocs
	 * @param obj
	 */
    public void setICSDocs(ICSDocuments obj)
    {
        icsDocs = obj;
    }

}
