/**
 * This class is a Panel for the XML View of a message
 */


// JDK
package icsDyn;

import java.io.StringWriter;


// Swing
import javax.swing.JTextArea;



// XSL
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

// DOM
import org.w3c.dom.Document;

public class XMLView extends JTextArea {

    /**
     * Constructor
     */
    public XMLView() {
	setEditable(false);
    }

    /**
     * Display the message from a Document object
     * @param doc The document
     */
    public void displayMessage(Document doc) {
    	reset();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.setOutputProperty(OutputKeys.METHOD, "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty(OutputKeys.INDENT, "yes");
            transformer.transform(source, result);
            this.setText(sw.toString());
            moveCaretPosition(0);
        }
        catch(TransformerConfigurationException tce) {
            System.err.println("TransformerConfigurationException " + tce.getMessage());
            tce.printStackTrace();
        }
        catch(TransformerException te) {
            System.err.println("TransformerException " + te.getMessage());
            te.printStackTrace();
        }
    }


    /**
     * Reset the display
     */
    public void reset() {
	setText("");
    }
}

