package icsDyn;

import java.io.IOException;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

import modifyIcs.GeneralICSManagementView;
import modifyIcs.ICSDocuments;
import modifyIcs.ServiceICSManagementView;

import org.xml.sax.SAXException;

import transport.TransportICS;
import transport.transportManagementViewPanel;

import comparingDevices.comparaisonManagementView;
import drawing.DrawingView;

public class ManagementView {
	 private static boolean useSystemLookAndFeel = false;
	 private static boolean DEBUG = false;
	/**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     * @throws ParserConfigurationException
     * @throws IOException
     * @throws SAXException
     */
    private static void createAndShowGUI() throws SAXException, IOException, ParserConfigurationException, TransformerException, TransformerConfigurationException {
        if (useSystemLookAndFeel) {
            try {
                UIManager.setLookAndFeel(
                    UIManager.getSystemLookAndFeelClassName());
            } catch (Exception e) {
                System.err.println("Couldn't use system look and feel.");
            }
        }
          

        //Create and set up the window.
        JFrame frame = new JFrame("ICSGENERATOR");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); 
        
       

        //Create and set up the content pane.
        ICSManagementView newContentPane = new ICSManagementView();    
        //newContentPane.setOpaque(true); //content panes must be opaque
        
        
        JTabbedPane jTabbedPane1 = new javax.swing.JTabbedPane();   
        frame.getContentPane().add(jTabbedPane1);
        jTabbedPane1.add("DIM ICS", newContentPane); 
        
        
        GeneralICSManagementView viewGeneral = new GeneralICSManagementView();
        jTabbedPane1.add("General ICS",viewGeneral);
        
        ServiceICSManagementView viewService = new ServiceICSManagementView();
        jTabbedPane1.add("Service Support ICS",viewService);
        
        transportManagementViewPanel viewTransport = new transportManagementViewPanel(null);
        jTabbedPane1.add("Transport ICS",viewTransport);
        
        DrawingView viewDrawing = new DrawingView(frame);
        jTabbedPane1.add("UML Diagram", viewDrawing);
        
        
        comparaisonManagementView viewComp = new comparaisonManagementView();
        jTabbedPane1.add("Compare devices",viewComp);
        
        
        ICSDocuments icsDocs = new ICSDocuments();
        icsDocs.addObserver(newContentPane.icsTablepanel);                
        viewGeneral.setICSDocs(icsDocs);
        icsDocs = new ICSDocuments();
        icsDocs.addObserver(newContentPane.icsTablepanel);
        viewService.setICSDocs(icsDocs);
        icsDocs = new ICSDocuments();
        icsDocs.addObserver(viewService);
        icsDocs = new ICSDocuments();
        viewTransport.setICSDocs(icsDocs);
        icsDocs.addObserver(viewTransport);
        newContentPane.icsTablepanel.setICSDocs(icsDocs);
        icsDocs.addObserver(viewDrawing);
        
        
             

        //Display the window.
        frame.setSize(800, 800);
        //frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) throws SAXException, IOException, ParserConfigurationException, TransformerConfigurationException, TransformerException{
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                try {
					createAndShowGUI();
				} catch (SAXException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (ParserConfigurationException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (TransformerException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();

				}
            }
        });
    }

}
