<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<axsl:stylesheet xmlns:axsl="http://www.w3.org/1999/XSL/Transform" xmlns:sch="http://www.ascc.net/xml/schematron" version="1.0">
<axsl:output method="text"/>
<axsl:template mode="schematron-get-full-path" match="*|@*">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:if test="count(. | ../@*) = count(../@*)">@</axsl:if>
<axsl:value-of select="name()"/>
<axsl:text>[</axsl:text>
<axsl:value-of select="1+count(preceding-sibling::*[name()=name(current())])"/>
<axsl:text>]</axsl:text>
</axsl:template>
<axsl:template match="/">
<axsl:apply-templates mode="M0" select="/"/>
<axsl:apply-templates mode="M1" select="/"/>
<axsl:apply-templates mode="M2" select="/"/>
<axsl:apply-templates mode="M3" select="/"/>
<axsl:apply-templates mode="M4" select="/"/>
<axsl:apply-templates mode="M5" select="/"/>
<axsl:apply-templates mode="M6" select="/"/>
<axsl:apply-templates mode="M7" select="/"/>
<axsl:apply-templates mode="M8" select="/"/>
<axsl:apply-templates mode="M9" select="/"/>
<axsl:apply-templates mode="M10" select="/"/>
</axsl:template>
<axsl:template mode="M0" priority="4000" match="DIM">
<axsl:choose>
<axsl:when test="count(Simple_MDS)&lt;2"/>
<axsl:otherwise>In pattern count(Simple_MDS)&lt;2:
   Simple_MDS should appear at most once( 0 or 1)
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Hydra_MDS)&lt;2"/>
<axsl:otherwise>In pattern count(Hydra_MDS)&lt;2:
   Hydra_MDS should appear at most once( 0 or 1)
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M0"/>
</axsl:template>
<axsl:template mode="M0" priority="-1" match="text()"/>
<axsl:template mode="M1" priority="4000" match="Multipatient_Archive">
<axsl:choose>
<axsl:when test="count(OBJECT_NAME)=1"/>
<axsl:otherwise>In pattern count(OBJECT_NAME)=1:
   OBJECT_NAME must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(OBJECT_ID)=1"/>
<axsl:otherwise>In pattern count(OBJECT_ID)=1:
   OBJECT_id in Multipatient_Archive must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(TERM_CODE)=1"/>
<axsl:otherwise>In pattern count(TERM_CODE)=1:
   TERM_CODE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_TERM_CODE)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_TERM_CODE)&lt;2:
   MOC_TYPE_TERM_CODE in Multipatient Archive should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_ID)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_ID)&lt;2:
   MOC_TYPE in Multipatient Archive should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Reference)=1"/>
<axsl:otherwise>In pattern count(Reference)=1:
   Reference must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_RESTRICTIONS)=1"/>
<axsl:otherwise>In pattern count(MOC_RESTRICTIONS)=1:
   MOC_RESTRICTIONS must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_APPLICATION_GUIDANCE)=1"/>
<axsl:otherwise>In pattern count(MOC_APPLICATION_GUIDANCE)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_COMMENT)=1"/>
<axsl:otherwise>In pattern count(MOC_COMMENT)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Attribute_Info)=1"/>
<axsl:otherwise>In pattern count(Attribute_Info)=1:
   Attribute_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Notification_Info)=1"/>
<axsl:otherwise>In pattern count(Notification_Info)=1:
   Notification_Infomust appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M1"/>
</axsl:template>
<axsl:template mode="M1" priority="-1" match="text()"/>
<axsl:template mode="M2" priority="4000" match="Simple_MDS">
<axsl:choose>
<axsl:when test="count(OBJECT_NAME)=1"/>
<axsl:otherwise>In pattern count(OBJECT_NAME)=1:
   OBJECT_NAME must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(OBJECT_ID)=1"/>
<axsl:otherwise>In pattern count(OBJECT_ID)=1:
   OBJECT_ID in Simlple_MDS must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(TERM_CODE)=1"/>
<axsl:otherwise>In pattern count(TERM_CODE)=1:
   TERM_CODE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_TERM_CODE)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_TERM_CODE)&lt;2:
   MOC_TYPE_TERM_CODE in Simple_MDS should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_ID)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_ID)&lt;2:
   MOC_TYPE in Simple_MDS should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Reference)=1"/>
<axsl:otherwise>In pattern count(Reference)=1:
   Reference must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_RESTRICTIONS)=1"/>
<axsl:otherwise>In pattern count(MOC_RESTRICTIONS)=1:
   MOC_RESTRICTIONS must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_APPLICATION_GUIDANCE)=1"/>
<axsl:otherwise>In pattern count(MOC_APPLICATION_GUIDANCE)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_COMMENT)=1"/>
<axsl:otherwise>In pattern count(MOC_COMMENT)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Attribute_Info)=1"/>
<axsl:otherwise>In pattern count(Attribute_Info)=1:
   Attribute_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Notification_Info)=1"/>
<axsl:otherwise>In pattern count(Notification_Info)=1:
   Notification_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Behaviour_Info)=1"/>
<axsl:otherwise>In pattern count(Behaviour_Info)=1:
   Behaviour_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(VMD)&lt;2"/>
<axsl:otherwise>In pattern count(VMD)&lt;2:
   VMD in Simple_MDS should appear at most once( 0 or 1) in Simple_MDS
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Clock)&lt;2"/>
<axsl:otherwise>In pattern count(Clock)&lt;2:
   Clock in Simple_MDS should appear at most once( 0 or 1)
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Patient_Demographics)&lt;2"/>
<axsl:otherwise>In pattern count(Patient_Demographics)&lt;2:
   Patient_Demographics in Simple_MDS should appear at most once( 0 or 1)
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="-1" match="text()"/>
<axsl:template mode="M3" priority="4000" match="Hydra_MDS">
<axsl:choose>
<axsl:when test="count(OBJECT_NAME)=1"/>
<axsl:otherwise>In pattern count(OBJECT_NAME)=1:
   OBJECT_NAME must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(OBJECT_ID)=1"/>
<axsl:otherwise>In pattern count(OBJECT_ID)=1:
   OBJECT_ID in Hydra_MDS must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(TERM_CODE)=1"/>
<axsl:otherwise>In pattern count(TERM_CODE)=1:
   TERM_CODE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_TERM_CODE)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_TERM_CODE)&lt;2:
   MOC_TYPE_TERM_CODE in Hydra_MDS should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_ID)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_ID)&lt;2:
   MOC_TYPE in Hydra_MDS should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Reference)=1"/>
<axsl:otherwise>In pattern count(Reference)=1:
   Reference must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_RESTRICTIONS)=1"/>
<axsl:otherwise>In pattern count(MOC_RESTRICTIONS)=1:
   MOC_RESTRICTIONS must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_APPLICATION_GUIDANCE)=1"/>
<axsl:otherwise>In pattern count(MOC_APPLICATION_GUIDANCE)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_COMMENT)=1"/>
<axsl:otherwise>In pattern count(MOC_COMMENT)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Attribute_Info)=1"/>
<axsl:otherwise>In pattern count(Attribute_Info)=1:
   Attribute_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Notification_Info)=1"/>
<axsl:otherwise>In pattern count(Notification_Info)=1:
   Notification_Infomust appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Behaviour_Info)=1"/>
<axsl:otherwise>In pattern count(Behaviour_Info)=1:
   Behaviour_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Clock)&lt;2"/>
<axsl:otherwise>In pattern count(Clock)&lt;2:
   Clock in Simple_MDS should appear at most once( 0 or 1)
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Patient_Demographics)&lt;2"/>
<axsl:otherwise>In pattern count(Patient_Demographics)&lt;2:
   Patient_Demographics in Simple_MDS should appear at most once( 0 or 1)
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M3"/>
</axsl:template>
<axsl:template mode="M3" priority="-1" match="text()"/>
<axsl:template mode="M4" priority="4000" match="Patient_Archive">
<axsl:choose>
<axsl:when test="count(OBJECT_ID)=1"/>
<axsl:otherwise>In pattern count(OBJECT_ID)=1:
   OBJECT_ID must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(TERM_CODE)=1"/>
<axsl:otherwise>In pattern count(TERM_CODE)=1:
   TERM_CODE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_TERM_CODE)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_TERM_CODE)&lt;2:
   MOC_TYPE_TERM_CODE in Patient_Archiveshould appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_ID)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_ID)&lt;2:
   MOC_TYPE in Patient_Archive should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Reference)=1"/>
<axsl:otherwise>In pattern count(Reference)=1:
   Reference must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_RESTRICTIONS)=1"/>
<axsl:otherwise>In pattern count(MOC_RESTRICTIONS)=1:
   MOC_RESTRICTIONS must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_APPLICATION_GUIDANCE)=1"/>
<axsl:otherwise>In pattern count(MOC_APPLICATION_GUIDANCE)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_COMMENT)=1"/>
<axsl:otherwise>In pattern count(MOC_COMMENT)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Attribute_Info)=1"/>
<axsl:otherwise>In pattern count(Attribute_Info)=1:
   Attribute_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Notification_Info)=1"/>
<axsl:otherwise>In pattern count(Notification_Info)=1:
   Attribute_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Patient_Demographics)&lt;2"/>
<axsl:otherwise>In pattern count(Patient_Demographics)&lt;2:
   Patient_Demographics in Patient Archive should appear at most once( 0 or 1)
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M4"/>
</axsl:template>
<axsl:template mode="M4" priority="-1" match="text()"/>
<axsl:template mode="M5" priority="4000" match="Session_Archive">
<axsl:choose>
<axsl:when test="count(OBJECT_ID)=1"/>
<axsl:otherwise>In pattern count(OBJECT_ID)=1:
   OBJECT_ID must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(TERM_CODE)=1"/>
<axsl:otherwise>In pattern count(TERM_CODE)=1:
   TERM_CODE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_TERM_CODE)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_TERM_CODE)&lt;2:
   MOC_TYPE_TERM_CODE in Session_Archive should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_ID)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_ID)&lt;2:
   MOC_TYPE in Session_Archive should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Reference)=1"/>
<axsl:otherwise>In pattern count(Reference)=1:
   Reference must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_RESTRICTIONS)=1"/>
<axsl:otherwise>In pattern count(MOC_RESTRICTIONS)=1:
   MOC_RESTRICTIONS must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_APPLICATION_GUIDANCE)=1"/>
<axsl:otherwise>In pattern count(MOC_APPLICATION_GUIDANCE)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_COMMENT)=1"/>
<axsl:otherwise>In pattern count(MOC_COMMENT)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Attribute_Info)=1"/>
<axsl:otherwise>In pattern count(Attribute_Info)=1:
   Attribute_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Notification_Info)=1"/>
<axsl:otherwise>In pattern count(Notification_Info)=1:
   Attribute_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Patient_Demographics)&lt;2"/>
<axsl:otherwise>In pattern count(Patient_Demographics)&lt;2:
   Patient_Demographics in Patient Archive should appear at most once( 0 or 1)
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M5"/>
</axsl:template>
<axsl:template mode="M5" priority="-1" match="text()"/>
<axsl:template mode="M6" priority="4000" match="Session_Test">
<axsl:choose>
<axsl:when test="count(OBJECT_ID)=1"/>
<axsl:otherwise>In pattern count(OBJECT_ID)=1:
   OBJECT_ID must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(TERM_CODE)=1"/>
<axsl:otherwise>In pattern count(TERM_CODE)=1:
   TERM_CODE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_TERM_CODE)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_TERM_CODE)&lt;2:
   MOC_TYPE_TERM_CODE in Session_Test should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_ID)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_ID)&lt;2:
   MOC_TYPE in Session_Test should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Reference)=1"/>
<axsl:otherwise>In pattern count(Reference)=1:
   Reference must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_RESTRICTIONS)=1"/>
<axsl:otherwise>In pattern count(MOC_RESTRICTIONS)=1:
   MOC_RESTRICTIONS must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_APPLICATION_GUIDANCE)=1"/>
<axsl:otherwise>In pattern count(MOC_APPLICATION_GUIDANCE)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_COMMENT)=1"/>
<axsl:otherwise>In pattern count(MOC_COMMENT)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Attribute_Info)=1"/>
<axsl:otherwise>In pattern count(Attribute_Info)=1:
   Attribute_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Notification_Info)=1"/>
<axsl:otherwise>In pattern count(Notification_Info)=1:
   Attribute_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M6"/>
</axsl:template>
<axsl:template mode="M6" priority="-1" match="text()"/>
<axsl:template mode="M7" priority="4000" match="PM-Store">
<axsl:choose>
<axsl:when test="count(OBJECT_ID)=1"/>
<axsl:otherwise>In pattern count(OBJECT_ID)=1:
   OBJECT_ID must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(TERM_CODE)=1"/>
<axsl:otherwise>In pattern count(TERM_CODE)=1:
   TERM_CODE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_TERM_CODE)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_TERM_CODE)&lt;2:
   MOC_TYPE_TERM_CODE in PM-Store should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_ID)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_ID)&lt;2:
   MOC_TYPE in PM-Store should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Reference)=1"/>
<axsl:otherwise>In pattern count(Reference)=1:
   Reference must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_RESTRICTIONS)=1"/>
<axsl:otherwise>In pattern count(MOC_RESTRICTIONS)=1:
   MOC_RESTRICTIONS must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_APPLICATION_GUIDANCE)=1"/>
<axsl:otherwise>In pattern count(MOC_APPLICATION_GUIDANCE)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_COMMENT)=1"/>
<axsl:otherwise>In pattern count(MOC_COMMENT)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Attribute_Info)=1"/>
<axsl:otherwise>In pattern count(Attribute_Info)=1:
   Attribute_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Notification_Info)=1"/>
<axsl:otherwise>In pattern count(Notification_Info)=1:
   Attribute_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Behaviour_Info)=1"/>
<axsl:otherwise>In pattern count(Behaviour_Info)=1:
   Behaviour_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M7"/>
</axsl:template>
<axsl:template mode="M7" priority="-1" match="text()"/>
<axsl:template mode="M8" priority="4000" match="SCO">
<axsl:choose>
<axsl:when test="count(OBJECT_ID)=1"/>
<axsl:otherwise>In pattern count(OBJECT_ID)=1:
   OBJECT_ID must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(TERM_CODE)=1"/>
<axsl:otherwise>In pattern count(TERM_CODE)=1:
   TERM_CODE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_TERM_CODE)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_TERM_CODE)&lt;2:
   MOC_TYPE_TERM_CODE in SCO should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_ID)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_ID)&lt;2:
   MOC_TYPE in SCO should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Reference)=1"/>
<axsl:otherwise>In pattern count(Reference)=1:
   Reference must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_RESTRICTIONS)=1"/>
<axsl:otherwise>In pattern count(MOC_RESTRICTIONS)=1:
   MOC_RESTRICTIONS must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_APPLICATION_GUIDANCE)=1"/>
<axsl:otherwise>In pattern count(MOC_APPLICATION_GUIDANCE)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_COMMENT)=1"/>
<axsl:otherwise>In pattern count(MOC_COMMENT)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Attribute_Info)=1"/>
<axsl:otherwise>In pattern count(Attribute_Info)=1:
   Attribute_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Notification_Info)=1"/>
<axsl:otherwise>In pattern count(Notification_Info)=1:
   Notification_Infomust appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Behaviour_Info)&lt;2"/>
<axsl:otherwise>In pattern count(Behaviour_Info)&lt;2:
   Behaviour_Info should appear at most once( 0 or 1)
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M8"/>
</axsl:template>
<axsl:template mode="M8" priority="-1" match="text()"/>
<axsl:template mode="M9" priority="4000" match="VMD">
<axsl:choose>
<axsl:when test="count(OBJECT_ID)=1"/>
<axsl:otherwise>In pattern count(OBJECT_ID)=1:
   OBJECT_ID must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(TERM_CODE)=1"/>
<axsl:otherwise>In pattern count(TERM_CODE)=1:
   TERM_CODE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_TERM_CODE)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_TERM_CODE)&lt;2:
   MOC_TYPE_TERM_CODE in VMD should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_ID)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_ID)&lt;2:
   MOC_TYPE in VMD should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Reference)=1"/>
<axsl:otherwise>In pattern count(Reference)=1:
   Reference must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_RESTRICTIONS)=1"/>
<axsl:otherwise>In pattern count(MOC_RESTRICTIONS)=1:
   MOC_RESTRICTIONS must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_APPLICATION_GUIDANCE)=1"/>
<axsl:otherwise>In pattern count(MOC_APPLICATION_GUIDANCE)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_COMMENT)=1"/>
<axsl:otherwise>In pattern count(MOC_COMMENT)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Attribute_Info)=1"/>
<axsl:otherwise>In pattern count(Attribute_Info)=1:
   Attribute_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Notification_Info)=1"/>
<axsl:otherwise>In pattern count(Notification_Info)=1:
   Notification_Infomust appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M9"/>
</axsl:template>
<axsl:template mode="M9" priority="-1" match="text()"/>
<axsl:template mode="M10" priority="4000" match="Channel">
<axsl:choose>
<axsl:when test="count(OBJECT_ID)=1"/>
<axsl:otherwise>In pattern count(OBJECT_ID)=1:
   OBJECT_ID must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(TERM_CODE)=1"/>
<axsl:otherwise>In pattern count(TERM_CODE)=1:
   TERM_CODE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_TERM_CODE)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_TERM_CODE)&lt;2:
   MOC_TYPE_TERM_CODE in CHANNEL should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_TYPE_ID)&lt;2"/>
<axsl:otherwise>In pattern count(MOC_TYPE_ID)&lt;2:
   MOC_TYPE in CHANNEL should appear at most once( 0 or 1
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Reference)=1"/>
<axsl:otherwise>In pattern count(Reference)=1:
   Reference must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_RESTRICTIONS)=1"/>
<axsl:otherwise>In pattern count(MOC_RESTRICTIONS)=1:
   MOC_RESTRICTIONS must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_APPLICATION_GUIDANCE)=1"/>
<axsl:otherwise>In pattern count(MOC_APPLICATION_GUIDANCE)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(MOC_COMMENT)=1"/>
<axsl:otherwise>In pattern count(MOC_COMMENT)=1:
   MOC_APPLICATION_GUIDANCE must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Attribute_Info)=1"/>
<axsl:otherwise>In pattern count(Attribute_Info)=1:
   Attribute_Info must appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(Notification_Info)=1"/>
<axsl:otherwise>In pattern count(Notification_Info)=1:
   Notification_Infomust appear one time
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M10"/>
</axsl:template>
<axsl:template mode="M10" priority="-1" match="text()"/>
<axsl:template priority="-1" match="text()"/>
</axsl:stylesheet>
