/**
 * JTableModifyGeneralICS
 * @author maria
 */

package modifyIcs;

import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;


public class JTableModifyGeneralICS extends JTableModifyICS{
    
    /** Creates a new instance of JTableModifyGeneralICS */
    public JTableModifyGeneralICS( AbstractTableModel model) {
        super(model);
        setDefaultEditor(String.class, new MyCellEditor());
    }
    /**
     * MyCellEditor
     * @author maria
     *
     */
    public class MyCellEditor extends AbstractCellEditor implements TableCellEditor 
    {
        JTextArea jTextArea;
        JScrollPane pan;
        int Row;
        int Col;
        
        /**
         * MyCellEditor
         *
         */
        public MyCellEditor()
        {
             
             jTextArea = new JTextArea();
             jTextArea.setLineWrap(true);
             jTextArea.setWrapStyleWord(true);
             pan = new JScrollPane(jTextArea);
             pan.setBorder(BorderFactory.createLineBorder(Color.RED));
             jTextArea.getDocument().addDocumentListener(new DocumentListener() {
                 public void changedUpdate(DocumentEvent e) {
                     getModel().setValueAt(jTextArea.getText(), Row, Col);
                 }
                 public void insertUpdate(DocumentEvent e) {
                    getModel().setValueAt(jTextArea.getText(), Row, Col);
                 }
                 public void removeUpdate(DocumentEvent e) {
                    getModel().setValueAt(jTextArea.getText(), Row, Col);
                 }
             });
        }
        /**
         * @see javax.swing.CellEditor#getCellEditorValue()
         */         
        public Object getCellEditorValue() {
            return jTextArea.getText();
        }
        /**
         * @see TableCellEditor#getTableCellEditorComponent(javax.swing.JTable, java.lang.Object, boolean, int, int)
         */ 
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column)
        {
            Row = row;
            Col = column;
            String val = getValueAt(row, column).toString();
            val = val.replaceAll("<html>","");
            val = val.replaceAll("</html>","");
            jTextArea.setText(val);
            return pan;
        }
    
    } 
    
}
