

package icsTables;

import icsDyn.ICSMDSPanel;
import icsDyn.ICSManagementView;
import java.awt.Color;
import java.security.acl.Owner;
import javax.swing.JFrame;
import org.w3c.dom.*;

/**
 * this class represents the window displayed wich shows the selected ICS Tables
 * @author    maria
 */
public class ICSFrame extends javax.swing.JFrame 
{
	
	private javax.swing.JTabbedPane jTabbedPane1;
	
    private ICSManagementView parent;
    
    /** Creates new form ICSFrame 
     * @param strXMLFile the path of the XML file containing the data
     * @param bTables ICS tables that will appear DIMMOC, MOCAttribute, MOCBehaviour, MOCNotification
     * 
     * */
    public ICSFrame(ICSManagementView parentIn, String strXMLFile, boolean [] bTables) {       
        initComponents();
        setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        setSize(600,600);
        ICSTablePanel obj;
        parent = parentIn;
        
        
        if(bTables[2] == true)
        {
        	obj = new ICSTablePanel(new ICSDIMMOCTableModel(strXMLFile));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[3] == true)
        {
        	obj = new ICSTablePanel(new ICSMOCAttributeTableModel(strXMLFile));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[4] == true)
        {
        	obj = new ICSTablePanel(new ICSMOCNotificationTableModel(strXMLFile));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[5] == true)
        {
        	obj = new ICSTablePanel(new ICSMOCBehaviourTableModel(strXMLFile));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
    }
    
    /**
     * Creates new form ICSFrame 
     * @param doc a dom document containing the data for the ICSTables
     * @param bTables ICS tables that will appear DIMMOC, MOCAttribute, MOCBehaviour, MOCNotification
     */
    public ICSFrame(ICSManagementView parentIn, Document doc, Document docGeneralIn, Document docServiceIn, boolean [] bTables) {       
        initComponents();
        setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        setSize(600,600);
        ICSTablePanel obj;
        this.parent = parentIn;
        setLocationRelativeTo(parent);
        if(bTables[0] == true)
        {
        	obj = new ICSTablePanel(new ICSGeneralTableModel(docGeneralIn));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[1] == true)
        {
        	obj = new ICSTablePanel(new ICSServiceTableModel(docServiceIn));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[2] == true)
        {
        	obj = new ICSTablePanel(new ICSDIMMOCTableModel(doc));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[3] == true)
        {
        	obj = new ICSTablePanel(new ICSMOCAttributeTableModel(doc));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[4] == true)
        {
        	obj = new ICSTablePanel(new ICSMOCNotificationTableModel(doc));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[5] == true)
        {
        	obj = new ICSTablePanel(new ICSMOCBehaviourTableModel(doc));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * 
     */
    private void initComponents() {
        jTabbedPane1 = new javax.swing.JTabbedPane();

        getContentPane().setLayout(new java.awt.GridLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("ICS Tables");
        getContentPane().add(jTabbedPane1);
       

        pack();
    }
   
    
   
    
}
