/**
 * Behaviour Information 
 */
// JDK
package icsDyn;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

/**
 * @author  maria
 */
public class AddBehaviourDialog extends JDialog implements  Observer, ActionListener {

    private JTextField txtIndex;
    private JTextField txtStatus;
    private JTextField txtFeature;
    private JTextField txtReference;
    private JTextField txtBehaviourName;
    private JTextField txtRestrictions;
    private JTextArea textComments;
    private JTextField txtQual;

    private JPanel pMultipleValue;
    private JPanel p6;

    private JList lstValue;
    private JScrollPane lstValueScrollPane;
    private JButton btnAdd;
    private JButton btnClose;

    private Vector vListModel;
    private DIMMOC pn;
    private MOCNode mocNode;
    private Object attrSelected;
    
    private ICSModel icsModel;

     /**
     * Constructor
     * @param frame A frame
     */
    public AddBehaviourDialog (JFrame frame, Object selection, MOCNode selectedMoc, ICSModel model) {
	super(frame, "Add a Behaviour", true);	
	attrSelected = selection;
	setICSModel(model);	
	BoxLayout layout = new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS);
	getContentPane().setLayout(layout);
	
	JPanel p0 = new JPanel();
	p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));
	JLabel lblIndex = new JLabel("Method Id: ");
	p0.add(Box.createRigidArea(new Dimension(20, 0)));
	lblIndex.setPreferredSize(new Dimension(130, 0));
	p0.add(lblIndex);
	txtIndex = new JTextField();
	txtIndex.setEditable(false);
	txtIndex.setBackground(Color.WHITE);
	p0.add(txtIndex);
	p0.add(Box.createRigidArea(new Dimension(20, 0)));
	
	JPanel p1 = new JPanel();
	p1.setLayout(new BoxLayout(p1, BoxLayout.LINE_AXIS));
	JLabel lblBehaviourName = new JLabel("Method Name: ");
	lblBehaviourName.setPreferredSize(new Dimension(130, 0));
	p1.add(Box.createRigidArea(new Dimension(20, 0)));
	p1.add(lblBehaviourName);
	txtBehaviourName = new JTextField();
	txtBehaviourName.setEditable(true);
	txtBehaviourName.setBackground(Color.WHITE);
	p1.add(txtBehaviourName);
	p1.add(Box.createRigidArea(new Dimension(20, 0)));

	JPanel p2 = new JPanel();
	p2.setLayout(new BoxLayout(p2, BoxLayout.LINE_AXIS));
	JLabel lblReference = new JLabel("Reference: ");
	lblReference.setPreferredSize(new Dimension(130, 0));
	p2.add(Box.createRigidArea(new Dimension(20, 0)));
	p2.add(lblReference);
	txtReference = new JTextField();
	txtReference.setEditable(false);
	txtReference.setBackground(Color.WHITE);
	p2.add(txtReference);
	p2.add(Box.createRigidArea(new Dimension(20, 0)));
	
	JPanel p22 = new JPanel();
	p22.setLayout(new BoxLayout(p22, BoxLayout.LINE_AXIS));
	JLabel lblQual = new JLabel("Status: ");
	lblQual.setPreferredSize(new Dimension(130, 0));
	p22.add(Box.createRigidArea(new Dimension(20, 0)));
	p22.add(lblQual);
	txtQual = new JTextField();
	txtQual.setEditable(false);
	txtQual.setBackground(Color.WHITE);
	p22.add(txtQual);
	p22.add(Box.createRigidArea(new Dimension(20, 0)));

	JPanel p6 = new JPanel();
	p6.setLayout(new BoxLayout(p6, BoxLayout.LINE_AXIS));
	JLabel lblRestrictions = new JLabel("Restrictions: ");
	lblRestrictions.setPreferredSize(new Dimension(130, 0));
	p6.add(Box.createRigidArea(new Dimension(20, 0)));
	p6.add(lblRestrictions);
	txtRestrictions = new JTextField();
	txtRestrictions.setEditable(true);
	txtRestrictions.setBackground(Color.WHITE);
	p6.add(txtRestrictions);
	p6.add(Box.createRigidArea(new Dimension(20, 0)));

	JPanel p7 = new JPanel();
	p7.setLayout(new BoxLayout(p7, BoxLayout.LINE_AXIS));
	p7.add(Box.createRigidArea(new Dimension(20, 0)));
        textComments = new JTextArea();
        textComments.setEditable(true);
        textComments.setFont(new Font("Serif", Font.ITALIC, 16));
        textComments.setLineWrap(true);
        textComments.setWrapStyleWord(true);
        JScrollPane areaScrollPane = new JScrollPane(textComments);
        areaScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        areaScrollPane.setPreferredSize(new Dimension(0, 150));
        areaScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Comments"),
                            BorderFactory.createEmptyBorder(5,5,5,5)),areaScrollPane.getBorder()));
        p7.add(areaScrollPane);
	p7.add(Box.createRigidArea(new Dimension(20, 0)));
	
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p0);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p1);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p2);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p22);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p6);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p7);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 10)));
//	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
//	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
//	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));

	pMultipleValue = new JPanel();
	pMultipleValue.setLayout(new BoxLayout(pMultipleValue, BoxLayout.LINE_AXIS));

	JPanel p10 = new JPanel();
	p10.setLayout(new BoxLayout(p10, BoxLayout.PAGE_AXIS));
	lstValue = new JList();
	lstValueScrollPane = new JScrollPane(lstValue);
	p10.add(lstValueScrollPane);
	p10.add(Box.createRigidArea(new Dimension(0, 5)));

	JPanel p8 = new JPanel();
	p8.setLayout(new BorderLayout());
	btnAdd = new JButton("Add");
	btnAdd.addActionListener(this);
	btnAdd.setBackground(new Color(204, 204, 255));
	p8.add(btnAdd, BorderLayout.WEST);
	p8.add(Box.createRigidArea(new Dimension(0, 5)));
	
	btnClose = new JButton("Close");
	btnClose.addActionListener((ActionListener) this);
	btnClose.setBackground(new Color(204, 204, 255));
	p8.add(btnClose, BorderLayout.EAST);

	pMultipleValue.add(Box.createRigidArea(new Dimension(20, 0)));
	//pMultipleValue.add(Box.createRigidArea(new Dimension(10, 0)));
	pMultipleValue.add(p8);
	pMultipleValue.add(Box.createRigidArea(new Dimension(20, 0)));
	getContentPane().add(pMultipleValue);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 10)));
	
	init();
	
	if(icsModel != null ) {		

           int mocIdNumber = selectedMoc.getMocIdNumber();
	   int index = icsModel.getcurVMoc().indexOf(selectedMoc);
	   mocNode = (MOCNode)icsModel.getcurVMoc().get(index);
           int tempmocIdNumber = mocNode.getMocIdNumber();

           while (tempmocIdNumber != mocIdNumber) {
              index = icsModel.getcurVMoc().indexOf(selectedMoc,index+1);
              mocNode = (MOCNode)icsModel.getcurVMoc().get(index);
              tempmocIdNumber = mocNode.getMocIdNumber();
           }
			
	   Vector vBehaviour = mocNode.getBehaviour();
	   for (int ac = 0; ac < vBehaviour.size(); ac++) {
	      BehaviourNode behaviourNode = (BehaviourNode)vBehaviour.get(ac);
    	      if (behaviourNode.getMethodName().equals(selection.toString())){
    	         txtReference.setText(behaviourNode.getBehaviourReference());
    	         txtIndex.setText(behaviourNode.getMethodId());
    		 txtBehaviourName.setText(behaviourNode.getMethodName());
    		 txtQual.setText(behaviourNode.getBehaviourQual());  	
    		 txtRestrictions.setText(behaviourNode.getBehaviourRestrictions());
                 textComments.setText(behaviourNode.getBehaviourComment());
    	      }
           }
    	         
	}
    }

   
    /**
     * Handles a click event
     * @param evt The event
     */
    public void actionPerformed(ActionEvent evt) {
	if(evt.getSource() == btnAdd) {
	   String error = "";
	   String index = txtIndex.getText();
	   String restrictions = txtRestrictions.getText();
	   String qual = txtQual.getText();
           String comment = textComments.getText();
	 
           MOCNode selMoc = icsModel.getMOCNode();

           int mocIdNumber = selMoc.getMocIdNumber();
	   int inx = icsModel.getcurVMoc().indexOf(selMoc);
	   mocNode = (MOCNode)icsModel.getcurVMoc().get(inx);
           int tempmocIdNumber = mocNode.getMocIdNumber();

           while (tempmocIdNumber != mocIdNumber) {
              inx = icsModel.getcurVMoc().indexOf(selMoc,inx+1);
              mocNode = (MOCNode)icsModel.getcurVMoc().get(inx);
              tempmocIdNumber = mocNode.getMocIdNumber();
           }
   
	   Vector vBehaviour = mocNode.getBehaviour();
		
	   for (int ac = 0; ac < vBehaviour.size(); ac++) {
	      BehaviourNode behaviourNode = (BehaviourNode)vBehaviour.get(ac);
	      if (behaviourNode.getMethodName().equals(attrSelected.toString())){
		 behaviourNode.setBehaviourRestrictions(txtRestrictions.getText());
                 behaviourNode.setBehaviourComment(textComments.getText());					
	      }
           }
	    
           txtBehaviourName.setText("");
	   txtIndex.setText("");
	   txtReference.setText("");
	   txtQual.setText("");
	   txtRestrictions.setText("");	
           textComments.setText("");    
	}
	else if(evt.getSource() == btnClose) {
	   setVisible(false);
	    
	}
	
    }
   
    public void update(Observable o, Object arg) {
    	if(o instanceof ICSModel) {
    	    if(arg instanceof MVCArg) {
    		if("node".equals(((MVCArg)arg).getName())) {
    			btnAdd.setEnabled(true);
    		    Object obj = ((MVCArg)arg).getOValue();
    		    if(obj instanceof DIMMOC) {
    			pn = (DIMMOC)obj;
    			
    	            }
    	        }
            }
    	}
    }
    
    /**
     * Set the model
     * @param model The model
     */
    public void setICSModel(ICSModel model) {
	icsModel = model;
    }

    private void init() {
    	btnAdd.setEnabled(true);
    	vListModel = new Vector();    	
    }
}
