package transport;


import java.util.Vector;

import javax.swing.tree.DefaultMutableTreeNode;

import org.w3c.dom.Node;


public class TransportTableModel extends AbstractTreeTableModel implements TreeTableModel{

	
//	 Names of the columns.
    static protected String[]  cNames = {"Function", "BCC", "DCC", "Supported"};

    // Types of the columns.
    static protected Class[]  cTypes = {TreeTableModel.class, String.class, String.class, String.class};
    
	public TransportTableModel(TableNode root) {
		super(root);
		
	}

	public int getColumnCount() {
		return cNames.length;
	}

	public String getColumnName(int column) {
		return cNames[column];
	}

	public Object getValueAt(Object node, int column) {
		String val = "";
		if(((TableNode)node).row[column] != null)
			val = ((TableNode)node).row[column];
		if(column == 3)
			return node;
		return val;
	}

	public void setValueAt(Object aValue, Object node, int column) {
		TableNode n = (TableNode) node;
		n.row[column] = aValue.toString();
	}
	public int getChildCount(Object node) { 
		Vector children = getChildren(node); 
		return (children == null) ? 0 : children.size();
	}

	protected Vector getChildren(Object node) {
		TableNode tNode = (TableNode)node;
		return tNode.getChildren();
	}

	public Object getChild(Object arg0, int arg1) {
		return getChildren(arg0).get(arg1);
	}
	public Class getColumnClass(int column) {
		return cTypes[column]; 
	}
	
	public boolean isCellEditable(Object node, int column) {
		boolean editable = super.isCellEditable(node, column);
		if(column == 3)
			editable = true;
		return editable;
	}
	
	

}


