package icsDyn;

import javax.swing.tree.DefaultMutableTreeNode;
 /* This class represents an argument for the update method used for MVC
 */

public class MVCArg {

    private String name;
    private String value;
    private Object oValue;
    private boolean bValue;
    private DefaultMutableTreeNode nValue;

    /**
     * Constructor
     * @param name The name of the argument
     * @param value The value of the argument
     */
    public MVCArg(String name, String value) {
	this.name = name;
	this.value = value;
    }

    /**
     * Constructor
     * @param name The name of the argument
     * @param value The value of the argument
     */
    public MVCArg(String name, DefaultMutableTreeNode value) {
	this.name = name;
	this.nValue = value;
    }
    
    /**
     * Constructor
     * @param name The name of the argument
     * @param value The value of the argument
     */
    public MVCArg(String name, Object value) {
	this.name = name;
	this.oValue = value;
    }

    /**
     * Constructor
     * @param name The name of the argument
     * @param value The value of the argument
     */
    public MVCArg(String name, boolean value) {
	this.name = name;
	this.bValue = value;
    }
    
    /**
     * Get the name of the argument
     * @return The name of the argument
     */
    public String getName() {
	return name;
    }

    /**
     * Get the value of the argument
     * @return The value of the argument
     */
    public String getValue() {
	return value;
    }

    /**
     * Get the value of the argument
     * @return The value of the argument
     */
    public Object getOValue() {
	return oValue;
    }
    
    /**
     * Get the value of the argument
     * @return The value of the argument
     */
    public boolean getBValue() {
	return bValue;
    }
    
    /**
     * Get the value of the argument
     * @return The value of the argument
     */
    public DefaultMutableTreeNode getTValue() {
	return nValue;
    }
}
