

package icsDyn;

/**
 * 
 */


import icsTables.ViewICSTablesPanel;

import java.awt.CardLayout;
import java.awt.GridLayout;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class ICSManagementView extends JPanel implements Observer {
    private JPanel rightPane ;
    JSplitPane sp;
    public ICSModel im;
    RightValuePanel rvp;
    public ICSGenerationPanel igp;
    public ViewICSTablesPanel icsTablepanel;

    //Optionally play with line styles.  Possible values are
    //"Angled" (the default), "Horizontal", and "None".
    private static boolean playWithLineStyle = false;
    private static String lineStyle = "Horizontal";
    
     public ICSManagementView() throws SAXException, IOException, ParserConfigurationException, TransformerConfigurationException, TransformerException  {
        super(new GridLayout(1,0));
        
        setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
        ICSMDSPanel imp = new ICSMDSPanel();
    	add(imp);
     	
     	ICSTreePanel itp = new ICSTreePanel();
     	rvp = new RightValuePanel();
     	
     	rightPane = new JPanel(new CardLayout());
    	rightPane.add(new JPanel(), "Blank");
    	rightPane.add(rvp, "ElementValue");
         
        //	 SplitPane 
        JPanel p0 = new JPanel();
        p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));
        JSplitPane sp = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, itp, rightPane);
        sp.setDividerLocation(200);
       
        p0.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));

        p0.add(sp);
        add(p0);
        icsTablepanel = new ViewICSTablesPanel(this);
        add(icsTablepanel);
        igp = new ICSGenerationPanel();
        add(igp);
        ICSDisplayPanel idp = new ICSDisplayPanel();
    	add(idp);
//      Create the Model
        im = new ICSModel();
        
        
        im.addObserver(itp);
        im.addObserver(this);
        im.addObserver(rvp);
        im.addObserver(igp);
        im.addObserver(idp);
        im.addObserver(icsTablepanel);
        
//      Set the Model
        imp.setICSModel(im);
        itp.setICSModel(im);
        igp.setICSModel(im);
        rvp.setICSModel(im);
       
    }
   
    

    /**
     * MVC
     * @param o The observable object
     * @param arg An argument passed to the notifyObservers method
     */
    public void update(Observable o, Object arg) {
	if(o instanceof ICSModel) {
		
	    if(arg instanceof MVCArg) {
		if("node".equals(((MVCArg)arg).getName())) {
		    Object obj = ((MVCArg)arg).getOValue();
			CardLayout cl = (CardLayout)(rightPane.getLayout());
			cl.show(rightPane, "ElementValue");
		}
		else if("nodeBlank".equals(((MVCArg)arg).getName())) {
		    CardLayout cl = (CardLayout)(rightPane.getLayout());
		    cl.show(rightPane, "Blank");
		}
		else if("init".equals(((MVCArg)arg).getName())) {
		    CardLayout cl = (CardLayout)(rightPane.getLayout());
		    cl.show(rightPane, "Blank");
		}
	    }
	}
    }
}


