/**
 * This dialog allows the user to add attributes
*/

// JDK
package icsDyn;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

/**
 * @author  maria
 */
public class AddAttrDialog extends JDialog implements Observer, ActionListener, ItemListener {

    private JTextField txtAttrId;
    private JComboBox cbAttributeAccess;
    private JTextField txtReference;
    private JTextField txtAttrName;
    private JTextField txtRestrictions;
    private JTextField txtApplicationGuidance;
    private JTextField txtValueRange;
    private JTextField txtQual;
    private JTextArea textComments;

    private JPanel pMultipleValue;
    private JPanel p6;

    private JList lstValue;
    private JScrollPane lstValueScrollPane;
    private JButton btnAdd;
    private JButton btnClose;

    private Vector vListModel;
    private DIMMOC pn;
    private MOCNode mocNode ;
    private Object attrSelected;
    
    private ICSModel icsModel;

    private JCheckBox GET;
    private JCheckBox GET_GRP;
    private JCheckBox SET;
    private JCheckBox SCAN;
    private JCheckBox SCAN_GRP;
    private JCheckBox ER;
    private JCheckBox CR_ER;    


     /**
     * Constructor
     * @param frame A frame
     */
    public AddAttrDialog(JFrame frame, Object selection, MOCNode selectedMoc, ICSModel model) {
    	
	super(frame, "Add an attribute ", true);
	

	attrSelected = selection;
	setICSModel(model);
	
	BoxLayout layout = new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS);
	getContentPane().setLayout(layout);
	
	JPanel p0 = new JPanel();
	p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));
	p0.add(Box.createRigidArea(new Dimension(20, 0)));
	JLabel lblAttrId = new JLabel("Attribute Id: ");
	lblAttrId.setPreferredSize(new Dimension(130,0));
	p0.add(lblAttrId);
	txtAttrId = new JTextField();
	txtAttrId.setEditable(false);
	txtAttrId.setBackground(Color.WHITE);
	p0.add(txtAttrId);
	p0.add(Box.createRigidArea(new Dimension(20, 0)));
	
	JPanel p1 = new JPanel();
	p1.setLayout(new BoxLayout(p1, BoxLayout.LINE_AXIS));
	p1.add(Box.createRigidArea(new Dimension(20, 0)));
	JLabel lblAttrName = new JLabel("Atrribute Name: ");
	lblAttrName.setPreferredSize(new Dimension(130,0));
	p1.add(lblAttrName);
	txtAttrName = new JTextField();
	txtAttrName.setEditable(false);
	txtAttrName.setBackground(Color.WHITE);
	p1.add(txtAttrName);
	p1.add(Box.createRigidArea(new Dimension(20, 0)));

	JPanel p2 = new JPanel();
	p2.setLayout(new BoxLayout(p2, BoxLayout.LINE_AXIS));
	p2.add(Box.createRigidArea(new Dimension(20, 0)));
	JLabel lblReference = new JLabel("Reference: ");
	lblReference.setPreferredSize(new Dimension(130,0));
	p2.add(lblReference);
	txtReference = new JTextField();
	txtReference.setEditable(false);
	txtReference.setBackground(Color.WHITE);
	p2.add(txtReference);
	p2.add(Box.createRigidArea(new Dimension(20, 0)));
	
	JPanel p22 = new JPanel();
	p22.setLayout(new BoxLayout(p22, BoxLayout.LINE_AXIS));
	p22.add(Box.createRigidArea(new Dimension(20, 0)));
	JLabel lblQual = new JLabel("Status: ");
	lblQual.setPreferredSize(new Dimension(130,0));
	p22.add(lblQual);
	txtQual = new JTextField();
	txtQual.setEditable(false);
	txtQual.setBackground(Color.WHITE);
	p22.add(txtQual);
	p22.add(Box.createRigidArea(new Dimension(20, 0)));
	
	JPanel p6 = new JPanel();
	p6.setLayout(new BoxLayout(p6, BoxLayout.LINE_AXIS));
	p6.add(Box.createRigidArea(new Dimension(20, 0)));
	JLabel lblSupport = new JLabel("Support");
	//lblSupport.setPreferredSize(new Dimension(130,0));
	p6.add(lblSupport);
	JPanel p61 = new JPanel();
	p61.setLayout(new BoxLayout(p61, BoxLayout.LINE_AXIS));
	p61.add(Box.createRigidArea(new Dimension(20, 0)));
	JLabel lblRestrictions = new JLabel("Restrictions: ");
	lblRestrictions.setPreferredSize(new Dimension(130,0));
	p61.add(lblRestrictions);
	txtRestrictions = new JTextField();
	txtRestrictions.setEditable(true);
	txtRestrictions.setBackground(Color.WHITE);
	p61.add(txtRestrictions);
	p61.add(Box.createRigidArea(new Dimension(20, 0)));

	JPanel p612 = new JPanel();
	p612.setLayout(new BoxLayout(p612, BoxLayout.LINE_AXIS));
	p612.add(Box.createRigidArea(new Dimension(20, 0)));
	JLabel lblApplicationGuidance = new JLabel("Application Guidance: ");
	lblApplicationGuidance.setPreferredSize(new Dimension(130,0));
	p612.add(lblApplicationGuidance);
	txtApplicationGuidance = new JTextField();
	txtApplicationGuidance.setEditable(true);
	txtApplicationGuidance.setBackground(Color.WHITE);
	p612.add(txtApplicationGuidance);
	p612.add(Box.createRigidArea(new Dimension(20, 0)));
	
	JPanel p611 = new JPanel();
	p611.setLayout(new BoxLayout(p611, BoxLayout.LINE_AXIS));
	p611.add(Box.createRigidArea(new Dimension(20, 0)));
	JLabel lblAttributeAccess = new JLabel("Attribute Access:");
	lblAttributeAccess.setPreferredSize(new Dimension(130,0));
	
	p611.add(lblAttributeAccess);
	

	
        GET = new JCheckBox("<html>GET</html>");
        GET.setSelected(false);
        GET_GRP = new JCheckBox("<html>GET-GRP</html>");
        GET_GRP.setSelected(false);
        SET = new JCheckBox("<html>SET</html>");
        SET.setSelected(false);
        SCAN = new JCheckBox("<html>SCAN</html>");
        SCAN.setSelected(false);
        SCAN_GRP = new JCheckBox("<html>SCAN-GRP</html>");
        SCAN_GRP.setSelected(false);
        ER = new JCheckBox("<html>ER</html>");
        ER.setSelected(false); 
        CR_ER = new JCheckBox("<html>CR-ER</html>");
        CR_ER.setSelected(false);

        GET.addItemListener(this);
        GET_GRP.addItemListener(this);
        SET.addItemListener(this);
        SCAN.addItemListener(this);
        SCAN_GRP.addItemListener(this);
        ER.addItemListener(this);
        CR_ER.addItemListener(this);

        p611.add(GET);
        p611.add(GET_GRP);
        p611.add(SET);
        p611.add(SCAN);
        p611.add(SCAN_GRP);
        p611.add(ER);
        p611.add(CR_ER);
        p611.add(Box.createRigidArea(new Dimension(20, 0)));

	JPanel p62 = new JPanel();
	p62.setLayout(new BoxLayout(p62, BoxLayout.LINE_AXIS));
	p62.add(Box.createRigidArea(new Dimension(20, 0)));
	JLabel lblValueRange = new JLabel("Value range: ");
	lblValueRange.setPreferredSize(new Dimension(130,0));
	p62.add(lblValueRange);
	txtValueRange = new JTextField();
	txtValueRange.setEditable(true);
	txtValueRange.setBackground(Color.WHITE);
	p62.add(txtValueRange);
	p62.add(Box.createRigidArea(new Dimension(20, 0)));
		
	JPanel p7 = new JPanel();
	p7.setLayout(new BoxLayout(p7, BoxLayout.LINE_AXIS));
	p7.add(Box.createRigidArea(new Dimension(20, 0)));
        textComments = new JTextArea();
        textComments.setEditable(true);
        textComments.setFont(new Font("Serif", Font.ITALIC, 16));
        textComments.setLineWrap(true);
        textComments.setWrapStyleWord(true);
        JScrollPane areaScrollPane = new JScrollPane(textComments);
        areaScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        areaScrollPane.setPreferredSize(new Dimension(150, 150));
        areaScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Comments"),
                            BorderFactory.createEmptyBorder(5,5,5,5)),areaScrollPane.getBorder()));
        p7.add(areaScrollPane);
	p7.add(Box.createRigidArea(new Dimension(20, 0)));
	
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p0);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p1);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p2);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p22);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
//	getContentPane().add(p6);
//	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p61);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p612);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p611);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p62);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p7);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));	
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));


	pMultipleValue = new JPanel();
	pMultipleValue.setLayout(new BoxLayout(pMultipleValue, BoxLayout.LINE_AXIS));

	JPanel p10 = new JPanel();
	p10.setLayout(new BoxLayout(p10, BoxLayout.PAGE_AXIS));
	lstValue = new JList();
	lstValueScrollPane = new JScrollPane(lstValue);
	p10.add(lstValueScrollPane);
	p10.add(Box.createRigidArea(new Dimension(0, 5)));

	JPanel p8 = new JPanel();
	p8.setLayout(new BorderLayout());
	btnAdd = new JButton("Add");
	btnAdd.addActionListener(this);
	btnAdd.setBackground(new Color(204, 204, 255));
	p8.add(btnAdd, BorderLayout.WEST);
	
	
	btnClose = new JButton("Close");
	btnClose.addActionListener((ActionListener) this);
	btnClose.setBackground(new Color(204, 204, 255));
	p8.add(btnClose, BorderLayout.EAST);
	//p8.setBorder(BorderFactory.createEmptyBorder(20,20,20,20));

	pMultipleValue.add(Box.createRigidArea(new Dimension(100, 0)));
	pMultipleValue.add(Box.createRigidArea(new Dimension(10, 0)));
	pMultipleValue.add(p8);
	pMultipleValue.add(Box.createRigidArea(new Dimension(100, 0)));
	getContentPane().add(pMultipleValue);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	init();
	
	if(icsModel != null ) {

           int mocIdNumber = selectedMoc.getMocIdNumber();
	   int index = icsModel.getcurVMoc().indexOf(selectedMoc);
	   mocNode = (MOCNode)icsModel.getcurVMoc().get(index);
           int tempmocIdNumber = mocNode.getMocIdNumber();

           while (tempmocIdNumber != mocIdNumber) {
              index = icsModel.getcurVMoc().indexOf(selectedMoc,index+1);
              mocNode = (MOCNode)icsModel.getcurVMoc().get(index);
              tempmocIdNumber = mocNode.getMocIdNumber();
           }			

	   Vector vAttribute = mocNode.getAttribute();
			
	   for (int ac = 0; ac < vAttribute.size(); ac++) {
	      AttributeNode atrributeNode = (AttributeNode)vAttribute.get(ac);
    	      if (atrributeNode.getAttributeName().equals(selection.toString())){
    		 txtReference.setText(atrributeNode.getAttributeReference());
    		 txtAttrId.setText(atrributeNode.getAttributeId());
    		 txtAttrName.setText(atrributeNode.getAttributeName());
    		 txtQual.setText(atrributeNode.getAttributeQual());
    		 txtRestrictions.setText(atrributeNode.getAttributeRestrictions());
                 txtApplicationGuidance.setText(atrributeNode.getAttributeApplicationGuidance());
    	         txtValueRange.setText(atrributeNode.getAttributeValueRange());
                 textComments.setText(atrributeNode.getAttributeComment());

                 String attributeaccess = atrributeNode.getAttributeAccess();

                 if (attributeaccess != null) {
                    Vector vattributeaccess = new Vector();
                    StringTokenizer stringtoken = new StringTokenizer(attributeaccess," ");
                    String token = null;
                    while (stringtoken.hasMoreTokens()) {
                        token = stringtoken.nextToken();
                        vattributeaccess.add(token);
                    }

                    for (int i = 0; i < vattributeaccess.size(); i++) {
                       if (vattributeaccess.get(i).equals("GET")) {
                          GET.setSelected(true);
                       }
                       else if (vattributeaccess.get(i).equals("GET-GRP")) {
                          GET_GRP.setSelected(true);
                       }
                       else if (vattributeaccess.get(i).equals("SET")) {
                          SET.setSelected(true);
                       }
                       else if (vattributeaccess.get(i).equals("SCAN")) {
                          SCAN.setSelected(true);
                       }
                       else if (vattributeaccess.get(i).equals("SCAN-GRP")) {
                          SCAN_GRP.setSelected(true);
                       }
                       else if (vattributeaccess.get(i).equals("ER")) {
                          ER.setSelected(true);
                       }
                       else if (vattributeaccess.get(i).equals("CR-ER")) {
                          CR_ER.setSelected(true);
                       }
                    }
                 }				
    	      }
	   }
    	         
        }
    }

    /**
     * Set the model
     * @param model The model
     */
    public void setICSModel(ICSModel model) {
	icsModel = model;
    }
    /**
     * Handles a click event
     * @param evt The event
     */
    public void actionPerformed(ActionEvent evt) {
	if(evt.getSource() == btnAdd) {
	    String error = "";
	    String restrictions = txtRestrictions.getText();
	    String attrName = txtAttrName.getText();
	    String qual = txtQual.getText();
	    String attrId = txtAttrId.getText();
	    String reference = txtReference.getText();
            String attrapplicationguidance = txtApplicationGuidance.getText();
            String valuerange = txtValueRange.getText();
            String comment = textComments.getText();

            MOCNode selMoc = icsModel.getMOCNode();

            int mocIdNumber = selMoc.getMocIdNumber();
	    int inx = icsModel.getcurVMoc().indexOf(selMoc);
	    mocNode = (MOCNode)icsModel.getcurVMoc().get(inx);
            int tempmocIdNumber = mocNode.getMocIdNumber();

            while (tempmocIdNumber != mocIdNumber) {
               inx = icsModel.getcurVMoc().indexOf(selMoc,inx+1);
               mocNode = (MOCNode)icsModel.getcurVMoc().get(inx);
               tempmocIdNumber = mocNode.getMocIdNumber();
            }
	  
	    Vector vAttribute = mocNode.getAttribute();
		
	    for (int ac = 0; ac < vAttribute.size(); ac++) {
	       AttributeNode atrributeNode = (AttributeNode)vAttribute.get(ac);
	       if (atrributeNode.getAttributeName().equals(attrSelected.toString())) {
		  atrributeNode.setAttributeRestrictions(txtRestrictions.getText());
                  atrributeNode.setAttributeApplicationGuidance(txtApplicationGuidance.getText());
                  atrributeNode.setAttributeValueRange(txtValueRange.getText());
                  atrributeNode.setAttributeComment(textComments.getText());
                
                  String attributeaccess = "";
                  boolean comma_flag = false;

                  if (GET.isSelected()) { 
                     comma_flag = true;
                     attributeaccess = "GET";
                  }
                  if (GET_GRP.isSelected()) {
                     if (comma_flag) {
                        attributeaccess = attributeaccess+" "+"GET-GRP";
                     }
                     else {
                        attributeaccess = "GET-GRP";
                        comma_flag = true;
                     }
                  }
                  if (SET.isSelected()) {
                     if (comma_flag) {
                        attributeaccess = attributeaccess+" "+"SET";
                     }
                     else {
                        attributeaccess = "SET";
                        comma_flag = true;
                     }
                  }
                  if (SCAN.isSelected()) {
                     if (comma_flag) {
                        attributeaccess = attributeaccess+" "+"SCAN";
                     }
                     else {
                        attributeaccess = "SCAN";
                        comma_flag = true;
                     }
                  }
                  if (SCAN_GRP.isSelected()) {
                     if (comma_flag) {
                        attributeaccess = attributeaccess+" "+"SCAN-GRP";
                     }
                     else {
                        attributeaccess = "SCAN-GRP";
                        comma_flag = true;
                     }
                  }
                  if (ER.isSelected()) {
                     if (comma_flag) {
                        attributeaccess = attributeaccess+" "+"ER";
                     }
                     else {
                        attributeaccess = "ER";
                        comma_flag = true;
                     }
                  }
                  if (CR_ER.isSelected()) {
                     if (comma_flag) {
                        attributeaccess = attributeaccess+" "+"CR-ER";
                     }
                     else {
                        attributeaccess = "CR-ER";
                        comma_flag = true;
                     }
                  }
                  atrributeNode.setAttributeAccess(attributeaccess);                  					
	       }
	    }	 
	}
	else if(evt.getSource() == btnClose) {
	    setVisible(false);
	}
    }
   
    public void update(Observable o, Object arg) {
    	if(o instanceof ICSModel) {
    	    if(arg instanceof MVCArg) {
    		if("node".equals(((MVCArg)arg).getName())) {
    		    btnAdd.setEnabled(true);
    		    Object obj = ((MVCArg)arg).getOValue();
    		    if(obj instanceof DIMMOC) {
    			pn = (DIMMOC)obj;
    	            }
    	        }
            }
    	}
    }
    /**
     * Handles a list click event
     * @param evt The event
     */

    private void init() {
    	btnAdd.setEnabled(true);
    	vListModel = new Vector();
    }

    public void itemStateChanged(ItemEvent e) {
    }
}
