package transport;

import icsDyn.MVCArg;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import modifyIcs.ICSDocuments;

public class TransportSelectionPanel extends JPanel implements ActionListener{
	private Component parent;
	private ButtonGroup grpRBtnLevel1;
	private ButtonGroup grpRBtnLevel2;
	private JRadioButton[] rBtnLevel1;
	private JRadioButton[] rBtnLevel2;
	private String[] strLevel1;
	private String[][] strLevel2;

	 private ICSDocuments icsDocs;
	 
	 protected int selectedL1 = -1;
	 protected int selectedL2 = -1;
	
	public TransportSelectionPanel(Component p, String[] level1, String[][] level2){
		super();
		parent = p;
		strLevel1 = level1;
		strLevel2 = level2;
		init();
	}
	public TransportSelectionPanel(){
		super();
	}
	public void init(){
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		JPanel p1 = new JPanel();
		p1.setLayout(new BoxLayout(p1, BoxLayout.Y_AXIS));
		rBtnLevel1 = createGrpButton(strLevel1, p1);
		grpRBtnLevel1 = new ButtonGroup();
		for(int i = 0; i < rBtnLevel1.length; i++)
			grpRBtnLevel1.add(rBtnLevel1[i]);
		
		add(p1);
		
	}
	public void setICSDocs(ICSDocuments obj)
    {
        icsDocs = obj;
    }
	
	public JRadioButton[] createGrpButton(String[] names, JPanel p){
		JRadioButton[] btnGrp = new JRadioButton[names.length];
		for(int i = 0; i < names.length; i++){
			JRadioButton jrBtn = new JRadioButton(names[i]);
			jrBtn.addActionListener(this);
			jrBtn.setSelected(false);
			p.add(jrBtn);
			btnGrp[i] = jrBtn;
			
		}
		return btnGrp;
	}

	public void actionPerformed(ActionEvent arg0) {
		for(int i = 0; i < rBtnLevel1.length; i++)
			if(arg0.getSource() == rBtnLevel1[i]){
				JPanel p2 = new JPanel();
				p2.setLayout(new BoxLayout(p2, BoxLayout.PAGE_AXIS));
				rBtnLevel2 = createGrpButton(strLevel2[i], p2);
				grpRBtnLevel2 = new ButtonGroup();
				for(int j = 0; j < rBtnLevel2.length; j++)
					grpRBtnLevel2.add(rBtnLevel2[j]);
				
				add(p2);
				validate();
				parent.validate();
				selectedL1 = i;
			}
		
		for(int i = 0; i < rBtnLevel2.length; i++)
		if(arg0.getSource() == rBtnLevel2[i]){
			selectedL2 = i;
			if(icsDocs != null)
				icsDocs.fireEvent(new MVCArg("select Transport", ""));
			
			System.out.println(i);
		}
	}
	
}


