
package icsDyn;
import java.util.Vector;

public class MOCNode extends DIMMOC {

   public Vector vAttribute;
   private Vector vBehaviour;
   private Vector vNotification;

   public MOCNode() {
      vAttribute = new Vector();
      vBehaviour = new Vector();
      vNotification = new Vector();
   }
  
   public MOCNode(MOCNode mn) {
      this();
      object_name               = mn.getObjectName();
      mocIdNumber               = mn.getMocIdNumber();
      object_name_label         = mn.getObjectNameLabel();
      object_id                 = mn.getObjectId();
      moc_termcode              = mn.getMocTermCode();
      moc_services_supported    = mn.getMocServicesSupported();
      moc_comment		= mn.getMocComment();
      moc_restrictions		= mn.getMocRestrictions();
      moc_ref                   = mn.getReference();
      status                    = mn.getStatus();
      attribute_name            = mn.getAttributeName();
      attr_grpname              = mn.getAttributeGroupName();
      attr_grpid                = mn.getAttributeGroupId();  
      attr_grptermcode          = mn.getAttributeGroupTermCode(); 
      attr_derivedfrom          = mn.getAttributeDerivedFrom();
      attr_keynum               = mn.getAttributeKeyNumber(); 
      attribute_id              = mn.getAttributeId();
      attribute_type            = mn.getAttributeType();
      attr_ref                  = mn.getAttributeReference();
      attr_qual                 = mn.getAttributeQual();
      attr_status               = mn.getAttributeStatus();
      attr_access               = mn.getAttributeAccess();
      attr_value_range          = mn.getAttributeValueRange();
      attr_restrictions         = mn.getAttributeRestrictions();
      attr_application_guidance = mn.getAttributeApplicationGuidance();
      attr_comment              = mn.getAttributeComment();
   }

   public String toString() {
      return object_name;
   }

   public Vector getAttribute() {
      return vAttribute;
   }

   public Vector getBehaviour() {
      return vBehaviour;
   }

   public Vector getNotification() {
      return vNotification;
   }

   public void addAttribute(AttributeNode attribute) {
      if (attribute != null) {
         vAttribute.add(attribute);
      }
   }

   public void addBehaviour(BehaviourNode behaviour) {
      if (behaviour != null) {
         vBehaviour.add(behaviour);
      }
   }

   public void addNotification(NotificationNode notification) {
      if (notification != null) {
         vNotification.add(notification);
      }
   }

}
