package icsDyn;
/**
 * This panel displays the tree structure of the batch message
 */

// JDK

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;



/**
 * @author  maria
 */
public class ICSTreePanel extends JPanel implements Observer, ActionListener, TreeSelectionListener{

    private JTree icsTree;
    private JScrollPane icstScrollPane;
    private JButton btnAddMOC;
    private JButton btnRemoveMOC;
    private JButton btnAddAttribute;
    private JButton btnAddNotification;
    private JButton btnAddBehaviour;
    private AddMOCDialog dlgAddMoc;   
    private ICSModel icsModel;
    private AddRemoveAttr addremattr; 
    private AddRemoveBehavior addrembehav;
    private AddRemoveNotification addremnoti; 

    public MOCNode pn;

    /**
     * Constructor
     * @throws IOException
     * @throws SAXException
     * @throws ParserConfigurationException
     */
    public ICSTreePanel() throws ParserConfigurationException, SAXException, IOException {
	setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));

	JPanel p0 = new JPanel();
	p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));
	icsTree = new JTree(new Vector());
	icsTree.addTreeSelectionListener(this);
	icstScrollPane = new JScrollPane(icsTree);
	icstScrollPane.setPreferredSize(new Dimension(100, 100));
	p0.add(icstScrollPane);
	
	JPanel p1 = new JPanel();
	p1.setLayout(new BoxLayout(p1, BoxLayout.LINE_AXIS));
	btnAddMOC = new JButton("Add MOC");
        btnAddMOC.setBackground(new Color(204, 204, 255));
        btnAddMOC.addActionListener(this);
	p1.add(btnAddMOC);
	p1.add(Box.createRigidArea(new Dimension(10, 0)));
	btnRemoveMOC = new JButton("Remove MOC");
	btnRemoveMOC.setBackground(new Color(204, 204, 255));
	btnRemoveMOC.addActionListener(this);
	p1.add(btnRemoveMOC);
        
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, BoxLayout.LINE_AXIS));
        btnAddAttribute = new JButton("Update attributes...");
        btnAddAttribute.setBackground(new Color(204, 204, 255));
        btnAddAttribute.addActionListener(this);
        p2.add(btnAddAttribute);
        
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, BoxLayout.LINE_AXIS));
        btnAddBehaviour = new JButton("Update behaviours...");
        btnAddBehaviour.setBackground(new Color(204, 204, 255));
        btnAddBehaviour.addActionListener(this);
        p3.add(btnAddBehaviour);
        
        JPanel p4 = new JPanel();
        p4.setLayout(new BoxLayout(p4, BoxLayout.LINE_AXIS));
        btnAddNotification = new JButton("Update notifications...");
        btnAddNotification.setBackground(new Color(204, 204, 255));
        btnAddNotification.addActionListener(this);
        p4.add(btnAddNotification);

	add(p0);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p1);
        add(Box.createRigidArea(new Dimension(0, 5)));
	add(p2);
	add(p3);
	add(p4);
	setBorder(BorderFactory.createEmptyBorder(5,5,5,5));

	dlgAddMoc = new AddMOCDialog(null);
	init();


    }

    /**
     * Handles a click event
     * @param evt The event
     * @throws IOException
     * @throws SAXException
     * @throws ParserConfigurationException
     */
    public void actionPerformed(ActionEvent evt) {
    	TreePath path = icsTree.getSelectionPath();
    	DefaultMutableTreeNode node = (DefaultMutableTreeNode)icsTree.getLastSelectedPathComponent();
	if(evt.getSource() == btnAddMOC) {
	    
	    dlgAddMoc.init(node);
	    dlgAddMoc.pack();
		// Center the window
		dlgAddMoc.setLocationRelativeTo(this);
		dlgAddMoc.setVisible(true);
		DefaultTreeModel model = new DefaultTreeModel(icsModel.getTree());
		icsTree.setModel(model);
		btnAddMOC.setEnabled(false);
		btnRemoveMOC.setEnabled(false);
		icsModel.setGenerateEnable(true);
		
	}
	else if(evt.getSource() == btnRemoveMOC) {
	    
	    if(node != null) {
		icsModel.removeMOC(node);
		DefaultTreeModel model = new DefaultTreeModel(icsModel.getTree());
		icsTree.setModel(model);
	    }
	    btnAddMOC.setEnabled(false);
	    btnRemoveMOC.setEnabled(false);
	    icsModel.setGenerateEnable(true);
	}
        else if(evt.getSource() == btnAddAttribute) {
            
            if(node != null) {
                Vector defvmoc = icsModel.getVMoc();
                Vector dynvmoc = icsModel.getcurVMoc();
                addremattr = new AddRemoveAttr(this);
                addremattr.setICSModel(icsModel);
                addremattr.mn(addremattr,dynvmoc,defvmoc,node);
                DefaultTreeModel model = new DefaultTreeModel(icsModel.getTree());
                icsTree.setModel(model);
            }
        }
        else if(evt.getSource() == btnAddBehaviour) {
            
            if(node != null) {
                Vector defvmoc = icsModel.getVMoc();
                Vector dynvmoc = icsModel.getcurVMoc();
                addrembehav = new AddRemoveBehavior(this);
                addrembehav.setICSModel(icsModel);
                addrembehav.mn(addrembehav,dynvmoc,defvmoc,node);
                DefaultTreeModel model = new DefaultTreeModel(icsModel.getTree());
                icsTree.setModel(model);
            }	
        }
        else if(evt.getSource() == btnAddNotification) {
            
            if(node != null) {
                Vector defvmoc = icsModel.getVMoc();
                Vector dynvmoc = icsModel.getcurVMoc();
                addremnoti = new AddRemoveNotification(this);
                addremnoti.setICSModel(icsModel);
                addremnoti.mn(addremnoti,dynvmoc,defvmoc,node);
                DefaultTreeModel model = new DefaultTreeModel(icsModel.getTree());
                icsTree.setModel(model);
            }        	
        }
	icsTree.setSelectionPath(path);
	
    }
    /**
     * Handles a tree click event
     * @param evt The event
     */
    public void valueChanged(TreeSelectionEvent evt) {
	btnAddMOC.setEnabled(false);
	btnRemoveMOC.setEnabled(false);
        btnAddAttribute.setEnabled(true);
        btnAddBehaviour.setEnabled(true);
        btnAddNotification.setEnabled(true);
	DefaultMutableTreeNode node = (DefaultMutableTreeNode)icsTree.getLastSelectedPathComponent();
	icsModel.fireEvent(new MVCArg("node tree", node));
	if(node == null) {
	    btnAddMOC.setEnabled(true);
	    btnRemoveMOC.setEnabled(true);
            btnAddAttribute.setEnabled(true);
            btnAddBehaviour.setEnabled(true);
            btnAddNotification.setEnabled(true);
	    icsModel.fireEvent(new MVCArg("nodeBlank",""));
	    return;
	}
	btnAddMOC.setEnabled(true);
        btnRemoveMOC.setEnabled(true);
        btnAddAttribute.setEnabled(true);
        btnAddBehaviour.setEnabled(true);
        btnAddNotification.setEnabled(true);
    
	Object nodeInfo = node.getUserObject();
	if(nodeInfo instanceof MOCNode) {
	}
	icsModel.fireEvent(new MVCArg("node", nodeInfo));
    }

    /**
     * MVC
     * @param o The observable object
     * @param arg An argument passed to the notifyObservers method
     */
    public void update(Observable o, Object arg) {
	if(o instanceof ICSModel) {
		if("tree status".equals(((MVCArg)arg).getName())) {
			TreePath path = icsTree.getSelectionPath();
			DefaultTreeModel model = new DefaultTreeModel(icsModel.getTree());
			icsTree.setModel(model);
			icsTree.setSelectionPath(path);
		}
		if("mdsType".equals(((MVCArg)arg).getName())) {
			
		    try {
			DefaultTreeModel model = new DefaultTreeModel(icsModel.getMainTree(((MVCArg)arg).getValue()));
			icsTree.setModel(model);
			icsTree.setRootVisible(true);
			icsModel.setGenerateEnable(true);
		    }
		    catch(ParserConfigurationException pce) {
			System.err.println("ParserConfigurationException " + pce.getMessage());
			pce.printStackTrace();
		    }
		    catch(SAXException saxe) {
			System.err.println("SAXException " + saxe.getMessage());
			saxe.printStackTrace();
		    }
		    catch(IOException ioe) {
			System.err.println("IOException " + ioe.getMessage());
			ioe.printStackTrace();
		    }
		}
	    
		 if("init".equals(((MVCArg)arg).getName())) {
		    init();
		}
	    }	
    }
	
    /**
     * Set the model
     * @param model The model
     */
   public void setICSModel(ICSModel model) {
   	icsModel = model;
   	dlgAddMoc.setICSModel(model);
    }

    /**
     * Init the panel
     */
    private void init() {
		btnAddMOC.setEnabled(false);
		btnRemoveMOC.setEnabled(false);
                btnAddAttribute.setEnabled(false);
                btnAddBehaviour.setEnabled(false);
                btnAddNotification.setEnabled(false);
    }
    
}
