/**
 * 
 */

// JDK
package icsDyn;
import java.util.Calendar;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;

// AWT
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

// Swing
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.BoxLayout;
import javax.swing.Box;
import javax.swing.BorderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;

public class ICSMDSPanel extends JPanel implements ActionListener {

    private JTextField txtStructure;
    private JButton btnHydra;
    private JButton btnNewICS;
    private JButton btnReloadICS;
    private JButton btnSimple;

    private ICSModel icsModel;
    
    private Calendar today;
    /**
     * Constructor
     */
    public ICSMDSPanel() {
    	
    	setLayout(new BoxLayout(this, BoxLayout.LINE_AXIS));
    	JPanel p00 = new JPanel();
      	
    	JPanel p11 = new JPanel();
    	JPanel p22 = new JPanel();
    	
    	JLabel icslbl = new JLabel("Select ICS: ");
      	p11.add(icslbl);
      	p11.add(Box.createRigidArea(new Dimension(10, 0)));

      	btnNewICS = new JButton("New");
      	btnNewICS.setBackground(new Color(204, 204, 255));
      	btnNewICS.setEnabled(true);
      	btnNewICS.addActionListener(this);
      	p11.add(btnNewICS);
      	p11.add(Box.createRigidArea(new Dimension(10, 0)));
      	
      	btnReloadICS = new JButton("Reload");
      	btnReloadICS.setBackground(new Color(204, 204, 255));
      	btnReloadICS.setEnabled(true);
      	btnReloadICS.addActionListener(this);
      	p11.add(btnReloadICS);
      	p11.add(Box.createRigidArea(new Dimension(10, 0)));
      	setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
      	
      	JLabel lbl = new JLabel("Select MDS: ");
      	p22.add(lbl);
      	p22.add(Box.createRigidArea(new Dimension(10, 0)));

      	btnSimple = new JButton("Simple");
      	btnSimple.setBackground(new Color(204, 204, 255));
      	btnSimple.setEnabled(false);
      	btnSimple.addActionListener(this);
      	p22.add(btnSimple);
      	p22.add(Box.createRigidArea(new Dimension(10, 0)));
      	
      	btnHydra = new JButton("Hydra");
      	btnHydra.setBackground(new Color(204, 204, 255));
      	btnHydra.setEnabled(false);
      	btnHydra.addActionListener(this);
      	p22.add(btnHydra);
      	p22.add(Box.createRigidArea(new Dimension(10, 0)));
      	setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
      	
      	
        JSplitPane sp = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, p11, p22);
        sp.setDividerLocation(250);
        
        p00.add(sp); 
    	
	add(p00);
	setBorder(BorderFactory.createEmptyBorder(5,5,5,5));

	init();
    }

    /**
     * Handles a click event
     * @param evt The event
     */
    public void actionPerformed(ActionEvent evt) {
		if(evt.getSource() == btnHydra) {
		   icsModel.setMDS("Hydra");	
		   btnSimple.setEnabled(false);
		   btnHydra.setEnabled(false);
		   btnNewICS.setEnabled(false);
		   btnReloadICS.setEnabled(false);		
		}
		if (evt.getSource() == btnSimple) {
		   icsModel.setMDS("Simple");
		   btnHydra.setEnabled(false);
		   btnSimple.setEnabled(false);
		   btnNewICS.setEnabled(false);
		   btnReloadICS.setEnabled(false);
		}
		if (evt.getSource() == btnNewICS) {
                   icsModel.setMode("New");
		   icsModel.setICS("ICS-Tool.xml");
		   btnHydra.setEnabled(true);
		   btnSimple.setEnabled(true);
	           btnNewICS.setEnabled(false);
		   btnReloadICS.setEnabled(false);		
		}
		if (evt.getSource() == btnReloadICS) {				    	
                   icsModel.setMode("Reload");
		   btnHydra.setEnabled(true);
		   btnSimple.setEnabled(true);												
		   JFileChooser fc = new JFileChooser();
		   // Set the chooser to accept only XML files.
	           fc.addChoosableFileFilter(new XMLFileFilter());
		   fc.setAcceptAllFileFilterUsed(false);
			    
		   try {
		      // Create a File object containing the canonical path of the
		      // desired directory
		      File f = new File(new File("C:\\ICS\\xml").getCanonicalPath());			    
		      // Set the current directory
		      fc.setCurrentDirectory(f);			    
                      } 
                      catch (IOException e) {
	              }
		      fc.setSelectedFile(new File("ICS-Tool.xml"));
		      int returnVal = fc.showOpenDialog(this);
		      File f = null;
		      if(returnVal == JFileChooser.APPROVE_OPTION) {
			 btnNewICS.setEnabled(false);
			 btnReloadICS.setEnabled(false);
			 f = fc.getSelectedFile();
			 icsModel.setICS(f.getName());
		      }
		      else if (returnVal == JFileChooser.CANCEL_OPTION){
			 btnHydra.setEnabled(false);
			 btnSimple.setEnabled(false);
		      }
		 }
	    }

    /**
     * Set the model
     * @param model The model
     */
    public void setICSModel(ICSModel model) {
	icsModel = model;
    }

    /**
     * Init the panel
     */
    public void init() {
	btnSimple.setEnabled(false);
	btnHydra.setEnabled(false);
    }
}


