package comparingDevices;

import java.io.File;
import java.util.Vector;

/**
 * this class will compare the devices
 * @author maria
 *
 */
public class CompareDevices {
	public Vector vectDevices;
	public Device megaDevice;
	public Vector vectCompareMOC;
	public Vector vectCompareAtt;
	public Vector vectCompareNotif;
	public Vector vectCompareBehav;
	
	public CompareDevices()
	{
		vectDevices = new Vector();
		megaDevice = null;
		vectCompareAtt = new Vector();
		vectCompareBehav = new Vector();
		vectCompareMOC = new Vector();
		vectCompareNotif = new Vector();
	}
	public CompareDevices(Vector vectFiles){
		vectDevices = new Vector();
		megaDevice = null;
		vectCompareAtt = new Vector();
		vectCompareBehav = new Vector();
		vectCompareMOC = new Vector();
		vectCompareNotif = new Vector();
		
		for(int i = 0; i< vectFiles.size(); i++)
		{
			String fileName = (String)vectFiles.get(i);
			vectDevices.add(new Device(new File(fileName)));
		}
	}
	public void addDevice(Device device){
		vectDevices.add(device);
	}
	private void buildMegaDevice(){
		megaDevice = new Device();
		for(int i = 0; i<vectDevices.size(); i++){
			Device device = (Device)vectDevices.get(i);
			device.setOwner(i);
			megaDevice.addListMOC(device.vectMOC);
		}
		
		megaDevice.sortMOC();
	}
	public void compareMOC()
	{
		//build megadevice containing all the MOC objects
		buildMegaDevice();		
		
		// fill vectCompareMOC
		for(int i = 0; i<megaDevice.vectMOC.size(); i++){
			MOC objMoc = (MOC) megaDevice.vectMOC.get(i);
			Boolean [] array = new Boolean [vectDevices.size() + 1];
			
			for(int j = 0; j<array.length; j++)
				array[j] = new Boolean(false);
			
			if(objMoc.isPrivate){
				array[vectDevices.size()] = new Boolean(true);
			}
			
			for(int j = 0; j<objMoc.vectOwners.size(); j++){
				Integer index = (Integer)objMoc.vectOwners.get(j);
				array[index.intValue()] = new Boolean(true);
			}
			vectCompareMOC.add(array);
							
		}
	}
	public void compareAttributes(int index)
	{
		//build megadevice containing all the MOC objects
		if(megaDevice == null)
			buildMegaDevice();
		
		MOC objMOC = (MOC) megaDevice.vectMOC.get(index);
		
		// fill vectCompareAttr
		for(int i = 0; i<objMOC.vectAttributes.size(); i++){
			Attribute objAttr = (Attribute) objMOC.vectAttributes.get(i);
			Boolean [] array = new Boolean [vectDevices.size() + 1];
			for(int j = 0; j<array.length; j++)
				array[j] = new Boolean(false);
			for(int j = 0; j<objAttr.vectOwners.size(); j++){
				Integer k = (Integer)objAttr.vectOwners.get(j);
				array[k.intValue()] = new Boolean(true);
			}
			if(objAttr.isPrivate)
				array[vectDevices.size()] = new Boolean(true);
			vectCompareAtt.add(array);
							
		}
		
	}
	public Vector getVectAttributes(int indexMOC){
		return ((MOC)megaDevice.vectMOC.get(indexMOC)).vectAttributes;
	}
	public Vector getVectNotifications(int indexMOC){
		return ((MOC)megaDevice.vectMOC.get(indexMOC)).vectNotifications;
	}
	public Vector getVectBehaviours(int indexMOC){
		return ((MOC)megaDevice.vectMOC.get(indexMOC)).vectBehaviors;
	}
	public void compareBehaviours(int index){
		//build megadevice containing all the MOC objects
		if(megaDevice == null)
			buildMegaDevice();
		
		MOC objMOC = (MOC) megaDevice.vectMOC.get(index);
		
		// fill vectCompareAttr
		for(int i = 0; i<objMOC.vectBehaviors.size(); i++){
			Behavior objbehav = (Behavior) objMOC.vectBehaviors.get(i);
			Boolean [] array = new Boolean [vectDevices.size() + 1];
			for(int j = 0; j<array.length; j++)
				array[j] = new Boolean(false);
			
			if(objbehav.isPrivate)
				array[vectDevices.size()] = new Boolean(true);
			for(int j = 0; j<objbehav.vectOwners.size(); j++){
				Integer k = (Integer)objbehav.vectOwners.get(j);
				array[k.intValue()] = new Boolean(true);
			}
			vectCompareBehav.add(array);
							
		}
	}
	public void compareNotifications(int index){
		//build megadevice containing all the MOC objects
		if(megaDevice == null)
			buildMegaDevice();
		
		MOC objMOC = (MOC) megaDevice.vectMOC.get(index);
		
		// fill vectCompareAttr
		for(int i = 0; i<objMOC.vectNotifications.size(); i++){
			Notification objNotif = (Notification) objMOC.vectNotifications.get(i);
			Boolean [] array = new Boolean [vectDevices.size() + 1];
			for(int j = 0; j<array.length; j++)
				array[j] = new Boolean(false);
			
			if(objNotif.isPrivate)
				array[vectDevices.size()] = new Boolean(true);
			
			for(int j = 0; j<objNotif.vectOwners.size(); j++){
				Integer k = (Integer)objNotif.vectOwners.get(j);
				array[k.intValue()] = new Boolean(true);
			}
			vectCompareNotif.add(array);
							
		}
	}

}
