package transport;

import java.awt.Color;
import java.awt.Component;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TransportTreeTable extends JTreeTable {

	public TransportTreeTable(TreeTableModel treeTableModel) {
		super(treeTableModel);
		setDefaultRenderer(String.class, new TransportCellRendrer());
		setDefaultEditor(String.class, new TransportCellEditor());
		 //To disable reordering columns
        getTableHeader().setReorderingAllowed(false);
	}

}

class TransportCellRendrer extends DefaultTableCellRenderer implements TableCellRenderer{

	protected JPanel panel;
	protected JCheckBox[] checkBox;
	protected JTextField txtFd;
	
	public Component getTableCellRendererComponent(JTable t, Object v, boolean arg2, boolean arg3, int row, int col) {
		Component c = super.getTableCellRendererComponent(t, v, arg2, arg3, row, col);
		panel = new JPanel();
		
		panel.setBackground(c.getBackground());
		if(col == 3){
			TableNode node = (TableNode) v;
			panel = new JPanel();			
			panel.setBackground(c.getBackground());
			panel.setLayout(new BoxLayout(panel, BoxLayout.LINE_AXIS));
			String val = node.defaultValues;
			String[] selVal = getSelVal(val);
			ButtonGroup grp = new ButtonGroup();
			for(int  i = 0; i < selVal.length; i++){
				if(!selVal[i].equals("")){
					JCheckBox chb = new JCheckBox(selVal[i]);
					if(node.row[3].indexOf(selVal[i]) != -1)
						chb.setSelected(true);
					else
						chb.setSelected(false);
					
					chb.setBackground(c.getBackground());
					
					if(selVal[i].equals("Yes")){
						grp.add(chb);
						
					}
					if(selVal[i].equals("No")){
						grp.add(chb);
					}
					
					panel.add(chb);
				}
			}
			c = panel;			
		}
		else{
			panel.setLayout(new GridBagLayout());
			txtFd = new JTextField(v.toString());
			txtFd.setBackground(c.getBackground());
			txtFd.setAlignmentX(JTextField.CENTER_ALIGNMENT);
			txtFd.setBorder(BorderFactory.createEmptyBorder());
			panel.add(txtFd);
			c = panel;
		}
			
		return c;
	}
	
	private String[] getSelVal(String v){
		return v.split(",");
	}
}

class TransportCellEditor extends AbstractCellEditor implements TableCellEditor{
	protected JPanel panel;
	protected JCheckBox[] checkBox = null;
	
	
	public TransportCellEditor(){
		super();
		panel = new JPanel();
	}
	public Component getTableCellEditorComponent(JTable t, Object v, boolean isSelected, int row, int col) {
		Component c = null;
		panel.setBackground(Color.WHITE);
		if(col == 3 && isSelected){
			TableNode node = (TableNode) v;
			String val = node.defaultValues;
			ButtonGroup grp = new ButtonGroup();
			panel.setLayout(new BoxLayout(panel, BoxLayout.LINE_AXIS));
			panel.setBorder(BorderFactory.createLineBorder(t.getSelectionBackground()));
			String[] selVal = getSelVal(val);
			checkBox = new JCheckBox[selVal.length];
			for(int  i = 0; i < selVal.length; i++){
				if(!selVal[i].equals("")){
					JCheckBox chb = new JCheckBox(selVal[i]);
					chb.setBackground(Color.WHITE);
					
					if(selVal[i].equals("Yes")){
						grp.add(chb);
						
					}
					if(selVal[i].equals("No")){
						grp.add(chb);
					}
					if(node.row[3].indexOf(selVal[i]) != -1)
						chb.setSelected(true);
					else
						chb.setSelected(false);
					
					checkBox[i] = chb;
					panel.add(chb);
					
					chb.addActionListener(new ActionListener(){

						public void actionPerformed(ActionEvent arg0) {
							fireEditingStopped();							
						}
						
					});
				}
			}
			c = panel;			
		}
		
		return c;
	}
	public boolean stopCellEditing() {
		boolean ret = super.stopCellEditing();
		fireEditingStopped();
		return ret;
	}
	private String[] getSelVal(String v){
		return v.split(",");
	}
	
	public Object getCellEditorValue() {
		String val = "";
		
		for(int i = 0; i < checkBox.length; i++){
			if(checkBox[i] != null && checkBox[i].isSelected()){
				val += checkBox[i].getText();
				if(i != checkBox.length - 1)
					val += ",";
			}
		}
		panel.removeAll();
		return val;
	}

}