/**
 * JTableModifyServiceICS
 * @author maria
 */

package modifyIcs;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;


public class JTableModifyServiceICS extends JTableModifyICS{
    
    /** Creates a new instance of JTableModifyServiceICS */
    public JTableModifyServiceICS(AbstractTableModel model) {
        super(model);
        setDefaultEditor(String.class, new MyCellEditor());
        setDefaultRenderer(String.class, new CellRenderer());
    }
    /**
     * MyCellEditor
     * @author maria
     *
     */
    public class MyCellEditor extends AbstractCellEditor implements TableCellEditor 
    {
        JCheckBox jCheckBox;
        JTextArea jTextArea;
        JScrollPane pan;
        int Row;
        int Col;
        /**
         * MyCellEditor
         */
        public MyCellEditor()
        {
        	jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            pan = new JScrollPane(jTextArea);
            pan.setBorder(BorderFactory.createLineBorder(Color.RED));
            jTextArea.getDocument().addDocumentListener(new DocumentListener() {
                public void changedUpdate(DocumentEvent e) {
                    getModel().setValueAt(jTextArea.getText(), Row, Col);
                }
                public void insertUpdate(DocumentEvent e) {
                   getModel().setValueAt(jTextArea.getText(), Row, Col);
                }
                public void removeUpdate(DocumentEvent e) {
                   getModel().setValueAt(jTextArea.getText(), Row, Col);
                }
            });
            
             jCheckBox = new JCheckBox();
             jCheckBox.setHorizontalAlignment(JCheckBox.CENTER);
             jCheckBox.setSelected(false);
             jCheckBox.addActionListener(new ActionListener() {
                 public void actionPerformed(ActionEvent e) {
                     stopCellEditing();
                 }
             });
        }
        /**
         * @see javax.swing.CellEditor#getCellEditorValue()
         */
        public Object getCellEditorValue() 
        {
        	if(Col == 4)
        	{
               boolean bool = jCheckBox.isSelected();
               if(bool)
                    return "yes";
               else
                    return "no";
        	}
        	else
               return jTextArea.getText();
        }
        /**
         * @see javax.swing.table.TableCellEditor#getTableCellEditorComponent(javax.swing.JTable, java.lang.Object, boolean, int, int)
         */
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column)
        {
        	Row = row;
            Col = column;
        	if(column == 4)
        	{
               String val = value.toString();

               if(val.indexOf("<html>yes</html>") != -1)
                   jCheckBox.setSelected(true);
               else
                   jCheckBox.setSelected(false);
               return jCheckBox;
        	}
        	else
        	{        		
                String val = getValueAt(row, column).toString();
                val = val.replaceAll("<html>","");
                val = val.replaceAll("</html>","");
                jTextArea.setText(val);
                return pan;
        	}
        }
    }
    /**
     * CellRenderer
     * @author maria
     *
     */ 
    public class CellRenderer extends MyCellRenderer implements TableCellRenderer
    {
    	/**
    	 * CellRenderer
    	 */
        public CellRenderer()
        {
            super();
        }
        /**
         * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
         */
        public Component getTableCellRendererComponent(JTable table,Object value,boolean isSelected,boolean hasFocus,int row,int col)
        {
            Component c = super.getTableCellRendererComponent( table, value,isSelected,hasFocus,row,col);
            if(col == 4)
            {
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setHorizontalAlignment(JCheckBox.CENTER);
                if(value.toString().indexOf("<html>yes</html>") != -1)
                    jCheckBox.setSelected(true);
                else
                    jCheckBox.setSelected(false);
                jCheckBox.setBackground(c.getBackground());
                c = jCheckBox;
            }
            
            return c; 
        }
    }
    
} 
