/**
 * DomToTableModelAdapter
 * @author maria
 */

package modifyIcs;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.*;


/**
 * @author  maria
 */
public class DomToTableModelAdapter extends AbstractTableModel{
    
    private ArrayList columnNames;
    private ArrayList data;
    /**
	 * @uml.property  name="doc"
	 */
    private Document doc;
    
    /** Creates a new instance of DomToTableModelAdapter */
    public DomToTableModelAdapter(Document docIn) {
        columnNames = new ArrayList();
        data = new ArrayList();
        doc = docIn;
        fillData();
    }
    /**
	 * getDoc
	 * @return
	 * @uml.property  name="doc"
	 */
    public Document getDoc()
    {
        return doc;
    }
    /**
     * fillData
     * constuct the data model for the table from a DOM document
     */
    private void fillData()
    {
        Element racine = doc.getDocumentElement();
        if(racine.hasChildNodes())
        {
            NodeList list = racine.getChildNodes();
            boolean first = true;
            for(int i = 0; i < list.getLength(); i++)
            {
                Node raw = list.item(i);
                if(raw.getNodeType() == Node.ELEMENT_NODE)
                {
                    NodeList list2 = raw.getChildNodes();
                    ArrayList strList = new ArrayList();
                    for(int j = 0; j < list2.getLength(); j++)
                    {
                        Node column = list2.item(j);
                        if(column.getNodeType() == Node.ELEMENT_NODE)
                        {
                            if(first)
                            {
                                String name = column.getNodeName();
                                columnNames.add(name);
                            }
                            
                            Node child = column.getFirstChild();
	                        while(child != null && child.getNodeType() != Node.TEXT_NODE)
	                        	child = child.getNextSibling();
	                        String text = "";
	                        if(child != null)
	                        {
	                        	text = child.getNodeValue();
	                        }
	                        strList.add(text);
	                       
                        }
                    }
                    if(first)
                        first = false;
                    data.add(strList);
                }                
            }
        }
        
    }
    /**
     * 
     * @see javax.swing.table.TableModel#getRowCount()
     */
    public int getRowCount() 
    {
        return data.size();
    }
    /**
     * getColumnCount
     * @return int
     */
    public int getColumnCount() 
    {
        return columnNames.size();
    }
    /**
     * @see javax.swing.table.TableModel#getValueAt(int, int)
     */   
    public Object getValueAt(int rowIndex, int columnIndex) {
    	ArrayList row;
    	String res = ""; 
    	if(data.size() > rowIndex)
    	{
    		row = (ArrayList)data.get(rowIndex);
    		if(row.size() > columnIndex)
    			res = (String)row.get(columnIndex);
    	}
        res = "<html>"+res+"</html>";
        return res;
    }
    /**
     * @see javax.swing.table.TableModel#getColumnName(int)
     */
    public String getColumnName(int column) {
        return (String)columnNames.get(column);
    }
    /**
     * @see javax.swing.table.TableModel#isCellEditable(int, int)
     */
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean bool = false;
        if(columnIndex == 4 || columnIndex == 5)
        {
            bool = true;
        }
        return bool;
    }
    /**
     * @see javax.swing.table.TableModel#setValueAt(java.lang.Object, int, int)
     */
    public void setValueAt(Object value, int row, int col) {
        ArrayList  list = new ArrayList();
        list = (ArrayList)data.get(row);
        String res = value.toString();
        res = res.replaceAll("<html>","");
        res = res.replaceAll("</html>","");
        list.set(col, res);
        data.set(row, list);
        fireTableCellUpdated(row, col);
    }
    /**
     * @see javax.swing.table.TableModel#getColumnClass(int)
     */
    public Class getColumnClass(int columnIndex) {
        return String.class;
    }
    

}

