<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="xml" indent="yes"/>
	
	<xsl:key name="objName" match="//OBJECT_NAME" use="../OBJECT_NAME"/>

	<xsl:template match="/">
			<Table>
     				<xsl:for-each select="//OBJECT_NAME">
     					<xsl:sort select="../OBJECT_NAME"/>     				
					<xsl:call-template name="row">
						<xsl:with-param name="obj" select="position()"></xsl:with-param>
					</xsl:call-template>     				
     				 </xsl:for-each>
   			</Table>
	</xsl:template>
	<xsl:template name="row">
		<xsl:param name="obj"></xsl:param>
		<xsl:for-each select="../*/*[NOTIFICATION_NAME]">		
			<tr >
				<td>NOTI-<xsl:value-of select="$obj"/>-<xsl:value-of select="position()"/></td>
		       		<td><b><xsl:value-of select="NOTIFICATION_NAME"/></b><br>
      	 			<xsl:value-of select="NOTIFICATION_ID"/></br></td>
		      		<td align="center"><xsl:value-of select="substring-after(Reference, 'clause')"/></td>
		      		<td ><xsl:value-of select="Qual"/></td>
	      			<td>
			      		<xsl:if test="NOTIFICATION_Restrictions!=''">
			     		<br><b><i>Restrictions: </i></b><xsl:value-of select="NOTIFICATION_Restrictions"/></br>
			     		</xsl:if>
		      		</td>
      				<td><xsl:value-of select="BEHAVIOUR_COMMENT"/></td>			
      			</tr>
			</xsl:for-each>					
		</xsl:template>
</xsl:stylesheet>





