package transport;

import icsDyn.MVCArg;
import icsTables.ErrorDialog;
import icsTables.XMlXSLTClass;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.ScrollPane;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

import org.w3c.dom.Document;

import modifyIcs.ICSDocuments;
import modifyIcs.JPanelGeneration;
import modifyIcs.JPanelICSTable;
import modifyIcs.JPanelLoad;

public class transportManagementViewPanel extends JPanel implements Observer{
	
	protected Component parent;
	private JPanelLoad loadPanel;
	private JPanelGeneration genPanel = null;
	private ICSTransportTableModel icsTable;
	private JScrollPane tablePanel;
	private TransportSelectionPanel selPanel;
	private ICSDocuments icsDocs;
	private Document doc;
	private TransportModelsBuilder builder;
	
	protected String schemaSource = "C:\\ICS\\xsd\\TransportICS.xsd";
	
	public transportManagementViewPanel(Component p){
		super();
		parent = p;
		icsTable = new ICSTransportTableModel();
		init();
		
	}
	 public void setICSDocs(ICSDocuments obj)
	    {
	        icsDocs = obj;
	        icsDocs.addObserver(this);
	        loadPanel.setICSDocs(icsDocs);

	        selPanel.setICSDocs(icsDocs);
	    }
	private void init(){
		java.awt.GridBagConstraints gridBagConstraints;
        setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 1;
        //gridBagConstraints.weighty = 1;
        


         loadPanel = new JPanelLoad(icsTable);
         add(loadPanel, gridBagConstraints);

         selPanel = new TransportSelectionPanel();
         gridBagConstraints.weighty = 1;
         add(selPanel, gridBagConstraints);

        
         
	}

	public void update(Observable o, Object arg) {
		if(o instanceof ICSDocuments) {	
		    if(arg instanceof MVCArg) {
		        if("save".equals(((MVCArg)arg).getName())) {
		           builder.fillNode(doc.getDocumentElement(), builder.vectTransProfiles);
		          
		           genPanel.setDocument(doc);
		           icsDocs.setDocTransport(doc);
		        }
		        if("xmlFile".equals(((MVCArg)arg).getName()))
                {
                	Object obj = ((MVCArg)arg).getOValue();
                	File xmlFile = (File) obj;
                	XMlXSLTClass xClass = new XMlXSLTClass();
                	boolean validate = false;
                	Vector Error;
                	Error = xClass.XmlFileValidate(xmlFile, schemaSource);
                	if(Error.size() == 0)
                		validate =true;
                	if(validate)
                	{
                		loadPanel.disableButtons();
                		icsTable.setDocumentFromXML(xmlFile.getAbsolutePath());
                		doc = icsTable.getDocument();
                		icsDocs.setDocTransport(doc);
                		builder = new TransportModelsBuilder(xmlFile.getAbsolutePath());
                		addSelectionPanel();
                		addTablePanel();
                		
                	}
                	else
                	{
                		//error message
                		
                		ErrorMessage(xmlFile.getAbsolutePath(),Error);
                	}
                }
		        if("select Transport".equals(((MVCArg)arg).getName())) {
		        	
		        	TransportProfile profile = (TransportProfile) builder.vectTransProfiles.get(selPanel.selectedL1);
		        	TransportICS ics = (TransportICS) profile.vectTransportICS.get(selPanel.selectedL2);
		        	TransportTableModel model = new TransportTableModel(ics.root);
		    		TransportTreeTable treeTable = new TransportTreeTable(model);
		    		tablePanel.setViewportView(treeTable);
		    		validate();
		    		if(genPanel == null){
		    	         genPanel = new JPanelGeneration();
		    
		    	         genPanel.setICSDocs(icsDocs);
		    	         addGenerationPanel();
		    	         validate();
		    		}
			    }
	        }
        }
		
	}
	private void addTablePanel(){
		 GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
         gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
         gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
         gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
         gridBagConstraints.weightx = 1.0;
         gridBagConstraints.weighty = 3.0;
         
         tablePanel = new JScrollPane();
         add(tablePanel, gridBagConstraints);
	}
	private void addSelectionPanel() {
		String[] level1;
		String[][] level2;
		level1 = new String[builder.vectTransProfiles.size()];
		level2 = new String[builder.vectTransProfiles.size()][];
		for(int i = 0; i < builder.vectTransProfiles.size(); i++)
		{
			TransportProfile profile = ((TransportProfile)builder.vectTransProfiles.get(i));
			level1[i] = profile.name;
			level2[i] = new String[profile.vectTransportICS.size()];
			for(int j = 0; j < level2[i].length; j++)
				level2[i][j] = ((TransportICS)profile.vectTransportICS.get(j)).name;
		}
		remove(selPanel);
		selPanel = new TransportSelectionPanel(this, level1, level2);
		GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.CENTER;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
       // gridBagConstraints.weighty = 1.0;
        
        add(selPanel, gridBagConstraints);
        selPanel.setICSDocs(icsDocs);
		
	}
	/**
     * ErrorMessage
     * @param message
     */
    public void ErrorMessage(String message, Vector error)
    {
    	ErrorDialog d = new ErrorDialog(this, message, error);
    	d.setVisible(true);
        loadPanel.init();
        doc = null;
    }
    
    public void addGenerationPanel()
    {
        GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        try{
            //tablePanel.createTableGeneral(doc);
            add(genPanel, gridBagConstraints);
        }
        catch(Exception e)
        {
            JOptionPane.showMessageDialog(this, "Error while building the table! the XML file may be corrupted....","Error!", JOptionPane.ERROR_MESSAGE);
            e.printStackTrace();
            loadPanel.init();
            doc = null;
        }
        
    }

}
