/**
 * JPanelGeneration
 * @author maria
 */

package modifyIcs;

import icsDyn.XMLFileFilter;
import icsTables.XMlXSLTClass;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;


/**
 * @author   maria
 */
public class JPanelGeneration extends JPanel implements ActionListener
{
    public ICSDocuments icsDocs;
    private JButton btnExportXML;
    private JButton btnGenerate;
    private JButton btnSave;
    private JTextArea jTtArea;
    private Document doc;
    
    /** Creates a new instance of JPanelGeneration */
    public JPanelGeneration()
    {
        setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
		JPanel p0 = new JPanel();
		p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));
        btnSave = new JButton("Add Changes");
		btnSave.setBackground(new Color(204, 204, 255));
		btnSave.setEnabled(true);
		btnSave.addActionListener(this);
		p0.add(btnSave);
		p0.add(Box.createRigidArea(new Dimension(10, 0)));
        btnGenerate = new JButton("Generate XML File");
		btnGenerate.setBackground(new Color(204, 204, 255));
		btnGenerate.setEnabled(true);
		btnGenerate.addActionListener(this);
		p0.add(btnGenerate);
		p0.add(Box.createRigidArea(new Dimension(10, 0)));
		btnExportXML = new JButton("Export XML File...");
		btnExportXML.setBackground(new Color(204, 204, 255));
		btnExportXML.addActionListener(this);
		p0.add(btnExportXML);
		p0.add(Box.createRigidArea(new Dimension(10, 0)));
		add(p0);
	    jTtArea = new JTextArea();
        jTtArea.setEditable(false);
        JScrollPane xmlScrollPane = new JScrollPane(jTtArea);
        xmlScrollPane.setPreferredSize(new Dimension(100, 260));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, BoxLayout.LINE_AXIS));
        p1.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        p1.add(xmlScrollPane);
        add(p1);
        setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        init();
    }
    /**
     * init
     *
     */
    private void init()
    {
        btnGenerate.setEnabled(false);
        btnExportXML.setEnabled(false);
    }
	/**
	 * @see ActionListener#actionPerformed(java.awt.event.ActionEvent) 
	 */
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == btnSave) 
        {
            icsDocs.setSave();
            btnGenerate.setEnabled(true);           
		}
		if (evt.getSource() == btnGenerate) 
	        {
	            XMlXSLTClass obj = new XMlXSLTClass();
	            jTtArea.setText(obj.DomToString(doc));
	            jTtArea. moveCaretPosition(0);
	            btnExportXML.setEnabled(true);
	            btnGenerate.setEnabled(false);
		}
	        if (evt.getSource() == btnExportXML) 
	        {
	            if(export())
	            	btnExportXML.setEnabled(false);
	        }
    }
    /**
     * export
     *
     */
    private boolean export()
    {
    	boolean ret = false;
        JFileChooser chooser = new javax.swing.JFileChooser();
        chooser.setDialogType(JFileChooser.SAVE_DIALOG);
        chooser.setCurrentDirectory(new File("C:\\ICS"));
        chooser.setFileFilter(new XMLFileFilter());
        int returnVal = chooser.showSaveDialog(this);
        if( returnVal == JFileChooser.APPROVE_OPTION)
        {
        try{
                boolean save = true;
                File selFile = chooser.getSelectedFile();
                if(!selFile.getPath().endsWith(".xml"))
                {
                    selFile = new File(selFile.getPath() + ".xml");
                }
                if(selFile.exists())
                {
                   save = false;     
                   returnVal = JOptionPane.showConfirmDialog(chooser, selFile.getAbsolutePath()+" already exists. Do you want to replace it?","Warning",JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
                   if(returnVal == JOptionPane.OK_OPTION)
                       save = true;
                }
                if(save)
                {
                    XMlXSLTClass obj = new XMlXSLTClass();
                    obj.DomToFile(doc, selFile);
                    ret = true;
                }
            }
            catch(Exception e)
            {
                e.printStackTrace();
            }
        }      
        return ret;
    }
    /**
     * setICSDocs
     * @param obj
     */
    public void setICSDocs(ICSDocuments obj)
    {
        icsDocs = obj;
    }
    /**
     * setDocument
     * @param docIn
     */
    public void setDocument(Document docIn)
    {
        doc = docIn;
    }
    
}
