/**
 * This panel displays the tree structure of the batch message
 */

// JDK
import java.io.IOException;
import java.util.Observer;
import java.util.Observable;
import java.util.Vector;

// AWT
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

// Swing
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.JScrollPane;
import javax.swing.JButton;
import javax.swing.BoxLayout;
import javax.swing.Box;
import javax.swing.BorderFactory;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultMutableTreeNode;

// XML
import javax.xml.parsers.ParserConfigurationException;

// SAX
import org.xml.sax.SAXException;

//public class ICSTreePanel extends JPanel implements Observer, ActionListener, TreeSelectionListener {
public class ICSTreePanel extends JPanel implements Observer, ActionListener, TreeSelectionListener{

    private JTree icsTree;
    private JScrollPane icstScrollPane;
    private JButton btnAddMOC;
    private JButton btnRemoveMOC;
    private AddMOCDialog dlgAddMoc;

    private ICSModel icsModel;
   

    /**
     * Constructor
     * @throws IOException
     * @throws SAXException
     * @throws ParserConfigurationException
     */
    public ICSTreePanel() throws ParserConfigurationException, SAXException, IOException {
	setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));

	JPanel p0 = new JPanel();
	p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));
	icsTree = new JTree(new Vector());
	icsTree.addTreeSelectionListener(this);
	icstScrollPane = new JScrollPane(icsTree);
	icstScrollPane.setPreferredSize(new Dimension(100, 100));
	p0.add(icstScrollPane);
	
	JPanel p1 = new JPanel();
	p1.setLayout(new BoxLayout(p1, BoxLayout.LINE_AXIS));
	btnAddMOC = new JButton("Add MOC");
        btnAddMOC.setBackground(new Color(204, 204, 255));
        btnAddMOC.addActionListener(this);
	p1.add(btnAddMOC);
	p1.add(Box.createRigidArea(new Dimension(10, 0)));
	btnRemoveMOC = new JButton("Remove MOC");
	btnRemoveMOC.setBackground(new Color(204, 204, 255));
	btnRemoveMOC.addActionListener(this);
	p1.add(btnRemoveMOC);

	add(p0);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p1);
	setBorder(BorderFactory.createEmptyBorder(5,5,5,5));

	dlgAddMoc = new AddMOCDialog(null);
	init();

    }

    /**
     * Handles a click event
     * @param evt The event
     * @throws IOException
     * @throws SAXException
     * @throws ParserConfigurationException
     */
    public void actionPerformed(ActionEvent evt) {
	if(evt.getSource() == btnAddMOC) {
	    DefaultMutableTreeNode node = (DefaultMutableTreeNode)icsTree.getLastSelectedPathComponent();
	    dlgAddMoc.init(node);
	    dlgAddMoc.pack();
		// Center the window
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension windowSize = dlgAddMoc.getSize();
		dlgAddMoc.setLocation(Math.max(0,(screenSize.width -windowSize.width)/2),Math.max(0,(screenSize.height-windowSize.height)/2));
		dlgAddMoc.setVisible(true);
		DefaultTreeModel model = new DefaultTreeModel(icsModel.getTree());
		icsTree.setModel(model);
		btnAddMOC.setEnabled(false);
		btnRemoveMOC.setEnabled(false);
	}
	else if(evt.getSource() == btnRemoveMOC) {
	    DefaultMutableTreeNode node = (DefaultMutableTreeNode)icsTree.getLastSelectedPathComponent();
	    if(node != null) {
		icsModel.removeMOC(node);
		DefaultTreeModel model = new DefaultTreeModel(icsModel.getTree());
		icsTree.setModel(model);
	    }
	    btnAddMOC.setEnabled(false);
	    btnRemoveMOC.setEnabled(false);
	}
    }
    /**
     * Handles a tree click event
     * @param evt The event
     */
    public void valueChanged(TreeSelectionEvent evt) {
	btnAddMOC.setEnabled(false);
	btnRemoveMOC.setEnabled(false);
	DefaultMutableTreeNode node = (DefaultMutableTreeNode)icsTree.getLastSelectedPathComponent();
	icsModel.fireEvent(new MVCArg("node tree", node));
	if(node == null) {
	    btnAddMOC.setEnabled(true);
	    btnRemoveMOC.setEnabled(true);
	    icsModel.fireEvent(new MVCArg("nodeBlank",""));
	    return;
	}
	btnAddMOC.setEnabled(true);
    btnRemoveMOC.setEnabled(true);
    
	Object nodeInfo = node.getUserObject();
	if(nodeInfo instanceof MOCNode) {
	}
	icsModel.fireEvent(new MVCArg("node", nodeInfo));
    }

    /**
     * MVC
     * @param o The observable object
     * @param arg An argument passed to the notifyObservers method
     */
    public void update(Observable o, Object arg) {
	if(o instanceof ICSModel) {
		if("tree status".equals(((MVCArg)arg).getName())) {
			DefaultTreeModel model = new DefaultTreeModel(icsModel.getTree());
			icsTree.setModel(model);
		}
		if("mdsType".equals(((MVCArg)arg).getName())) {
			
		    try {
			DefaultTreeModel model = new DefaultTreeModel(icsModel.getMainTree(((MVCArg)arg).getValue()));
			icsTree.setModel(model);
			icsTree.setRootVisible(true);
		    }
		    catch(ParserConfigurationException pce) {
			System.err.println("ParserConfigurationException " + pce.getMessage());
			pce.printStackTrace();
		    }
		    catch(SAXException saxe) {
			System.err.println("SAXException " + saxe.getMessage());
			saxe.printStackTrace();
		    }
		    catch(IOException ioe) {
			System.err.println("IOException " + ioe.getMessage());
			ioe.printStackTrace();
		    }
		}
	    
		 if("init".equals(((MVCArg)arg).getName())) {
		    init();
		}
	    }	
    }
	
    /**
     * Set the model
     * @param model The model
     */
   public void setICSModel(ICSModel model) {
   	icsModel = model;
   	dlgAddMoc.setICSModel(model);
    }

    /**
     * Init the panel
     */
    private void init() {
	btnAddMOC.setEnabled(false);
	btnRemoveMOC.setEnabled(false);
    }
    
}
