/**
 * This panel contains buttons to generate the XML Batch File and also for the ER7 format
 */

// JDK
import java.io.File;
import java.io.IOException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Observer;
import java.util.Observable;
import java.util.Vector;

// AWT
import java.awt.Dimension;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

// Swing
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JFileChooser;
import javax.swing.BoxLayout;
import javax.swing.Box;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

// XML
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;

// XSL
import javax.xml.transform.*;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

// DOM
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

// SAX
import org.xml.sax.SAXException;

public class ICSGenerationPanel extends JPanel implements ActionListener, Observer {
	
    private ICSModel icsModel;

    private JButton btnGenerate;
    private JButton btnExportXML;
    private JButton btnExportER7;

    private final String BATCH_DEFINITION_FILE = "data/BatchSegments.xml";

    private String batchER7;
    private Vector vProfile;

    private int vIndex = 0;

    private Vector VMOC;

    /**
     * Constructor
     */
    public ICSGenerationPanel() {
    
	setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));

	JPanel p0 = new JPanel();
	p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));

	JLabel lbl = new JLabel("Generate xml file: ");
	p0.add(lbl);
	p0.add(Box.createRigidArea(new Dimension(10, 0)));

	btnGenerate = new JButton("Generate");
	btnGenerate.setBackground(new Color(204, 204, 255));
	btnGenerate.setEnabled(true);
	btnGenerate.addActionListener(this);
	p0.add(btnGenerate);
	p0.add(Box.createRigidArea(new Dimension(10, 0)));
	
	btnExportXML = new JButton("Export XML File");
	btnExportXML.setBackground(new Color(204, 204, 255));
	btnExportXML.addActionListener(this);
	p0.add(btnExportXML);
	p0.add(Box.createRigidArea(new Dimension(10, 0)));
	

	add(p0);
	setBorder(BorderFactory.createEmptyBorder(5,5,5,5));

	vProfile = new Vector();
	init();
    }

    /**
     * Handles a click event
     * @param evt The event
     */
    public void actionPerformed(ActionEvent evt) {
	if(evt.getSource() == btnGenerate) {
	   generateXML();
	   icsModel.fireEvent(new MVCArg("generateXML", doc));
           btnExportXML.setEnabled(true);		
	}
	else if(evt.getSource() == btnExportXML) {
	   // Open a JFileChooser
	   JFileChooser fc = new JFileChooser();
	   // Set the chooser to accept only XML files.
	   fc.addChoosableFileFilter(new XMLFileFilter());
	   fc.setAcceptAllFileFilterUsed(false);
	   try {
	      // Create a File object containing the canonical path of the
	      // desired directory
	      File f = new File(new File("C:\\ICS\\xml").getCanonicalPath());
	    
	      // Set the current directory
	      fc.setCurrentDirectory(f);
	   } 
           catch (IOException e) {
	   }

	   fc.setSelectedFile(new File("Batch.xml"));
	   int returnVal = fc.showSaveDialog(this);
	   File f = null;
	   if(returnVal == JFileChooser.APPROVE_OPTION) {
	      f = fc.getSelectedFile();
	      if(!f.getPath().endsWith(".xml")) {
	         f = new File(f.getPath() + ".xml");
	      }
	      if (!f.exists()){
	        writeXMLFile(f);
	      }
	      else { //file exists
	         String msg = "The file \"{0}\" already exists!\nDo you want to replace it?";
	         msg = MessageFormat.format( msg, new Object[] { f.getName() } );
		 String title = getDialogTitle();
		 int option = JOptionPane.showConfirmDialog( this, msg, title, JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE );
		 if ( option == JOptionPane.NO_OPTION ) {
		    return;
	         } 	
		 else if ( option == JOptionPane.YES_OPTION ) {
		    writeXMLFile(f);
		 } 	
	      }
	   }
	   btnExportXML.setEnabled(false);
	}
    }
    private void writeXMLFile(File f) {
	try {
	    Transformer transformer = TransformerFactory.newInstance().newTransformer();
	    DOMSource source = new DOMSource(doc);
	    StreamResult result = new StreamResult(f);
            transformer.setOutputProperty(OutputKeys.INDENT,"yes");
	    transformer.transform(source, result);
	}
	catch(TransformerConfigurationException tce) {
	    System.err.println("TransformerConfigurationException " + tce.getMessage());
	    tce.printStackTrace();
	}
	catch(TransformerException te) {
	    System.err.println("TransformerException " + te.getMessage());
	    te.printStackTrace();
	}
    }

    /**
	 * @return
	 */
	private String getDialogTitle() {
		// TODO Auto-generated method stub
		return null;
	}


    /**
     * MVC
     * @param o The observable object
     * @param arg An argument passed to the notifyObservers method
     */
    public void update(Observable o, Object arg) {
	if(o instanceof ICSModel) {
	   if(arg instanceof MVCArg) {
    	      if("isEnable".equals(((MVCArg)arg).getName())) {
    	         btnGenerate.setEnabled(((MVCArg)arg).getBValue());
    	      }	
	      if("node".equals(((MVCArg)arg).getName())) {			
	         btnExportXML.setEnabled(false);
	      }
	   }
        }
    }
    

    /**
     * Set the model
     * @param model The model
     */
    public void setICSModel(ICSModel model) {
	icsModel = model;
    }

    /**
     * Init the panel
     */
    private void init() {
	btnGenerate.setEnabled(false);
	btnExportXML.setEnabled(false);	
    }

    private Document doc;

    private String MOCName;
    private String MOCObjectName;
    private String MOCObjectId;
    private String MOCReference;
    private String MOCRestrictions;
    private String MOCApplicationGuidance;
    private String MOCComment;

    private String AttributeName;
    private String AttributeId;
    private String AttributeReference;
    private String AttributeQual;
    private String AttributeAccess;
    private String AttributeValueRange;
    private String AttributeRestrictions;
    private String AttributeApplicationGuidance;
    private String AttributeComment;

    private String BehaviourMethodName;
    private String BehaviourMethodId;
    private String BehaviourReference;
    private String BehaviourQual;
    private String BehaviourRestrictions;
    private String BehaviourComment;

    private String NotificationName;
    private String NotificationId;
    private String NotificationReference;
    private String NotificationQual;
    private String NotificationRestrictions;
    private String NotificationComment;

    private Element xmlRoot;
    
    private Element xmlMOCName;
    private Element xmlMocs;
    private Element xmlObjectName;
    private Element xmlObjectId;
    private Element xmlMOCReference;
    private Element xmlMOCRestrictions;
    private Element xmlMOCApplicationGuidance;
    private Element xmlMOCComment;

    private Element xmlAttribute;    
    private Element xmlAttributeName;
    private Element xmlAttributeId;
    private Element xmlAttributeReference;
    private Element xmlAttributeQual;
    private Element xmlAttributeAccess;
    private Element xmlAttributeValueRange;
    private Element xmlAttributeRestrictions;
    private Element xmlAttributeApplicationGuidance;
    private Element xmlAttributeComment;

    private Element xmlBehaviour;    
    private Element xmlBehaviourMethodName;
    private Element xmlBehaviourMethodId;
    private Element xmlBehaviourReference;
    private Element xmlBehaviourQual;
    private Element xmlBehaviourRestrictions;
    private Element xmlBehaviourComment;

    private Element xmlNotification;    
    private Element xmlNotificationName;
    private Element xmlNotificationId;
    private Element xmlNotificationReference;
    private Element xmlNotificationQual;
    private Element xmlNotificationRestrictions;
    private Element xmlNotificationComment;
    
    /**
     * Generate the XML batch file
     */
    public void generateXML() { 
    	DefaultMutableTreeNode root = icsModel.getTree();
        //  Create a XML Document
    	try {
    	    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    	    DocumentBuilder builder = factory.newDocumentBuilder();
    	    doc = builder.newDocument();
    	}
    	catch(ParserConfigurationException pce) {
    	    System.err.println("ParserConfigurationException " + pce.getMessage());
    	    pce.printStackTrace();
    	}
    	
        VMOC = icsModel.getVMoc();

    	DefaultMutableTreeNode DMTree = icsModel.getTree();
        Enumeration treeEnum = DMTree.preorderEnumeration();
        root = (DefaultMutableTreeNode) treeEnum.nextElement();
        xmlRoot = doc.createElement(root.toString());    	        
    	xmlRoot = generateXMLNode(root);
    
        doc.appendChild(xmlRoot);
    	
    }
    private Element generateXMLNode(DefaultMutableTreeNode node) {
    	
            Element xmlRoot1;

            Object obj = node.getUserObject();
            MOCNode mocNode = (MOCNode) obj;

            MOCName                = mocNode.getObjectName();
            MOCObjectName          = mocNode.getObjectName();
            MOCObjectId            = mocNode.getObjectId();
            MOCReference           = mocNode.getReference();
            MOCRestrictions        = mocNode.getMocRestrictions();
            MOCApplicationGuidance = mocNode.getMocApplicationGuidance();
            MOCComment             = mocNode.getMocComment();

            if (MOCRestrictions == null) {
               MOCRestrictions = "";
            }
            if (MOCApplicationGuidance == null) {
               MOCApplicationGuidance = "";
            }
            if (MOCComment == null) {
               MOCComment = "";
            }

            xmlMOCName                = doc.createElement(MOCName);
            xmlObjectName             = doc.createElement("OBJECT_NAME");
            xmlObjectId               = doc.createElement("OBJECT_ID");
            xmlMOCReference           = doc.createElement("Reference");
            xmlMOCRestrictions        = doc.createElement("MOC_RESTRICTIONS");
            xmlMOCApplicationGuidance = doc.createElement("MOC_APPLICATION_GUIDANCE");
            xmlMOCComment             = doc.createElement("MOC_COMMENT");

            xmlObjectName.appendChild(doc.createTextNode(MOCObjectName));
            xmlObjectId.appendChild(doc.createTextNode(MOCObjectId));
            xmlMOCReference.appendChild(doc.createTextNode(MOCReference));
            xmlMOCRestrictions.appendChild(doc.createTextNode(MOCRestrictions));
            xmlMOCApplicationGuidance.appendChild(doc.createTextNode(MOCApplicationGuidance));
            xmlMOCComment.appendChild(doc.createTextNode(MOCComment));
           
            xmlRoot1 = doc.createElement(MOCName);

            xmlRoot1.appendChild(xmlObjectName);
            xmlRoot1.appendChild(xmlObjectId);
            xmlRoot1.appendChild(xmlMOCReference);
            xmlRoot1.appendChild(xmlMOCRestrictions);
            xmlRoot1.appendChild(xmlMOCApplicationGuidance);
            xmlRoot1.appendChild(xmlMOCComment);

            int index = icsModel.getVMoc().indexOf(mocNode);
            MOCNode vmocNode = (MOCNode) icsModel.getVMoc().get(index);

    	    Vector vAttribute = vmocNode.getAttribute();
   
    	    for (int ac = 0; ac < vAttribute.size(); ac++) {	
    	    	xmlAttribute                    = doc.createElement("Attribute_Info");
                xmlAttributeName                = doc.createElement("ATTRIBUTE_NAME");
                xmlAttributeId                  = doc.createElement("ATTRIBUTE_ID");
    	    	xmlAttributeReference           = doc.createElement("Reference");
    	    	xmlAttributeQual                = doc.createElement("Qual");
                xmlAttributeAccess              = doc.createElement("ATTRIBUTE_ACCESS");
                xmlAttributeValueRange          = doc.createElement("ATTRIBUTE_VALUE_RANGE");
                xmlAttributeRestrictions        = doc.createElement("ATTRIBUTE_RESTRICTIONS");
                xmlAttributeApplicationGuidance = doc.createElement("ATTRIBUTE_APPLICATION_GUIDANCE");
                xmlAttributeComment             = doc.createElement("ATTRIBUTE_COMMENT");

    	    	AttributeName                = ((DIMMOC) vAttribute.get(ac)).getAttributeName();
    	    	AttributeId                  = ((DIMMOC) vAttribute.get(ac)).getAttributeId();
    	    	AttributeReference           = ((DIMMOC) vAttribute.get(ac)).getAttributeReference();
    	    	AttributeQual                = ((DIMMOC) vAttribute.get(ac)).getAttributeQual();
                AttributeAccess              = ((DIMMOC) vAttribute.get(ac)).getAttributeAccess();
                AttributeValueRange          = ((DIMMOC) vAttribute.get(ac)).getAttributeValueRange();
                AttributeRestrictions        = ((DIMMOC) vAttribute.get(ac)).getAttributeRestrictions();
                AttributeApplicationGuidance = ((DIMMOC) vAttribute.get(ac)).getAttributeApplicationGuidance();
                AttributeComment             = ((DIMMOC) vAttribute.get(ac)).getAttributeComment();

                if (AttributeAccess == null) {
                   AttributeAccess = "";
                }
                if (AttributeValueRange == null) {
                   AttributeValueRange = "";
                }
                if (AttributeRestrictions == null) {
                   AttributeRestrictions = "";
                }
                if (AttributeApplicationGuidance == null) {
                   AttributeApplicationGuidance = "";
                }
                if (AttributeComment == null) {
                   AttributeComment = "";
                }

    	    	xmlAttributeName.appendChild(doc.createTextNode(AttributeName));
    	    	xmlAttributeId.appendChild(doc.createTextNode(AttributeId));
    	    	xmlAttributeReference.appendChild(doc.createTextNode(AttributeReference));
    	    	xmlAttributeQual.appendChild(doc.createTextNode(AttributeQual));
                xmlAttributeAccess.appendChild(doc.createTextNode(AttributeAccess));
                xmlAttributeValueRange.appendChild(doc.createTextNode(AttributeValueRange));
                xmlAttributeRestrictions.appendChild(doc.createTextNode(AttributeRestrictions));
                xmlAttributeApplicationGuidance.appendChild(doc.createTextNode(AttributeApplicationGuidance));                xmlAttributeComment.appendChild(doc.createTextNode(AttributeComment));

    	    	xmlAttribute.appendChild(xmlAttributeName);
    	    	xmlAttribute.appendChild(xmlAttributeId);
    	    	xmlAttribute.appendChild(xmlAttributeReference);
    	    	xmlAttribute.appendChild(xmlAttributeQual);
                xmlAttribute.appendChild(xmlAttributeAccess);
                xmlAttribute.appendChild(xmlAttributeValueRange);
                xmlAttribute.appendChild(xmlAttributeRestrictions);
                xmlAttribute.appendChild(xmlAttributeApplicationGuidance);
                xmlAttribute.appendChild(xmlAttributeComment);

    	    	xmlRoot1.appendChild(xmlAttribute);
 	    }

    	    Vector vBehaviour = vmocNode.getBehaviour();
   
    	    for (int bc = 0; bc < vBehaviour.size(); bc++) {	
    	    	xmlBehaviour                    = doc.createElement("Behaviour_Info");
                xmlBehaviourMethodName          = doc.createElement("METHOD_NAME");
                xmlBehaviourMethodId            = doc.createElement("METHOD_ID");
    	    	xmlBehaviourReference           = doc.createElement("Reference");
                xmlBehaviourQual                = doc.createElement("Qual");
                xmlBehaviourRestrictions        = doc.createElement("BEHAVIOUR_RESTRICTIONS");
                xmlBehaviourComment             = doc.createElement("BEHAVIOUR_COMMENT");

    	    	BehaviourMethodName   = ((DIMMOC) vBehaviour.get(bc)).getMethodName();
    	    	BehaviourMethodId     = ((DIMMOC) vBehaviour.get(bc)).getMethodId();
    	    	BehaviourReference    = ((DIMMOC) vBehaviour.get(bc)).getBehaviourReference();
    	    	BehaviourQual         = ((DIMMOC) vBehaviour.get(bc)).getBehaviourQual();
                BehaviourRestrictions = ((DIMMOC) vBehaviour.get(bc)).getBehaviourRestrictions();
                BehaviourComment      = ((DIMMOC) vBehaviour.get(bc)).getBehaviourComment();

                if (BehaviourRestrictions == null) {
                   BehaviourRestrictions = "";
                }
                if (BehaviourComment == null) {
                   BehaviourComment = "";
                }

    	    	xmlBehaviourMethodName.appendChild(doc.createTextNode(BehaviourMethodName));
    	    	xmlBehaviourMethodId.appendChild(doc.createTextNode(BehaviourMethodId));
    	    	xmlBehaviourReference.appendChild(doc.createTextNode(BehaviourReference));
    	    	xmlBehaviourQual.appendChild(doc.createTextNode(BehaviourQual));
                xmlBehaviourRestrictions.appendChild(doc.createTextNode(BehaviourRestrictions));
                xmlBehaviourComment.appendChild(doc.createTextNode(BehaviourComment));

    	    	xmlBehaviour.appendChild(xmlBehaviourMethodName);
    	    	xmlBehaviour.appendChild(xmlBehaviourMethodId);
    	    	xmlBehaviour.appendChild(xmlBehaviourReference);
    	    	xmlBehaviour.appendChild(xmlBehaviourQual);
                xmlBehaviour.appendChild(xmlBehaviourRestrictions);
                xmlBehaviour.appendChild(xmlBehaviourComment);

    	    	xmlRoot1.appendChild(xmlBehaviour);
 	    }

    	    Vector vNotification = vmocNode.getNotification();

    	    for (int nc = 0; nc < vNotification.size(); nc++) {	
    	    	xmlNotification             = doc.createElement("Notification_Info");
                xmlNotificationName         = doc.createElement("NOTIFICATION_NAME");
                xmlNotificationId           = doc.createElement("NOTIFICATION_ID");
    	    	xmlNotificationReference    = doc.createElement("Reference");
                xmlNotificationQual         = doc.createElement("Qual");
                xmlNotificationRestrictions = doc.createElement("NOTIFICATION_RESTRICTIONS");
                xmlNotificationComment      = doc.createElement("NOTIFICATION_COMMENT");

    	    	NotificationName         = ((DIMMOC) vNotification.get(nc)).getNotificationName();
    	    	NotificationId           = ((DIMMOC) vNotification.get(nc)).getNotificationId();
    	    	NotificationReference    = ((DIMMOC) vNotification.get(nc)).getNotificationReference();
    	    	NotificationQual         = ((DIMMOC) vNotification.get(nc)).getNotificationQual();
                NotificationRestrictions = ((DIMMOC) vNotification.get(nc)).getNotificationRestrictions();
                NotificationComment      = ((DIMMOC) vNotification.get(nc)).getNotificationComment();

                if (NotificationRestrictions == null) {
                   NotificationRestrictions = "";
                }
                if (NotificationComment == null) {
                   NotificationComment = "";
                }

    	    	xmlNotificationName.appendChild(doc.createTextNode(NotificationName));
    	    	xmlNotificationId.appendChild(doc.createTextNode(NotificationId));
    	    	xmlNotificationReference.appendChild(doc.createTextNode(NotificationReference));
    	    	xmlNotificationQual.appendChild(doc.createTextNode(NotificationQual));
                xmlNotificationRestrictions.appendChild(doc.createTextNode(NotificationRestrictions));
                xmlNotificationComment.appendChild(doc.createTextNode(NotificationComment));

    	    	xmlNotification.appendChild(xmlNotificationName);
    	    	xmlNotification.appendChild(xmlNotificationId);
    	    	xmlNotification.appendChild(xmlNotificationReference);
    	    	xmlNotification.appendChild(xmlNotificationQual);
                xmlNotification.appendChild(xmlNotificationRestrictions);
                xmlNotification.appendChild(xmlNotificationComment);

    	    	xmlRoot1.appendChild(xmlNotification);
 	    }

            if (!node.isLeaf()) {
               Enumeration chldrn = node.children();
               while (chldrn.hasMoreElements()) {
                  DefaultMutableTreeNode tnd = (DefaultMutableTreeNode) chldrn.nextElement();
                  xmlRoot1.appendChild(generateXMLNode(tnd));                  
               }
            } 
            return xmlRoot1;
    }
}
