import java.util.Vector;
import java.util.StringTokenizer;
import java.util.Observer;
import java.util.Observable;

// AWT
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;

// Swing
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.BoxLayout;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

// MessageMaker


public class RightValuePanel extends JPanel implements Observer, ActionListener, ListSelectionListener {

    private JTextField txtIndex;
    private JComboBox cbAttribute;
    private JComboBox cbBehaviour;
    private JComboBox cbNotification;
    private JTextField txtFeature;
    private JTextField txtLabel;
    private JTextField txtReference;
    private JTextField txtAttrName ;
    private JTextField txtRestrictions;
    private JTextArea textComments;

    private JPanel pMultipleValue;
    private JPanel p6;

    private JList lstValue;
    private JList lstAttrValue;
    private JScrollPane lstValueScrollPane;
    private JScrollPane lstAttrValueScrollPane;
    private JButton btnAdd;
    private JButton btnRemove;

    private Vector vListModel;
    private Vector vComboAttrModel;
    private Vector vComboNotificationModel;
    private Vector vComboBehaviourModel;
    private Vector vAttribute;
    private Vector vBehaviour;
    private Vector vNotification;
   
    public MOCNode pn;
    public MOCNode mocNodeT;
  
    private AddAttrDialog dlgAddAttr;
    private AddNotificationDialog dlgAddNotification;
    private AddBehaviourDialog dlgAddBehaviour;
    String[] sUsage;
    private DefaultMutableTreeNode currentNode;
    
    private ICSModel icsModel;

    /**
     * Constructor
     */
    public RightValuePanel() {
	setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));

	JPanel p0 = new JPanel();
	p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));
	JLabel lblIndex = new JLabel("OBJECT ID: ");
	p0.add(Box.createRigidArea(new Dimension(100, 0)));
	p0.add(lblIndex);
	txtIndex = new JTextField();
	txtIndex.setEditable(false);
	txtIndex.setBackground(Color.WHITE);
	p0.add(txtIndex);
	p0.add(Box.createRigidArea(new Dimension(100, 0)));
	
	JPanel p1 = new JPanel();
	p1.setLayout(new BoxLayout(p1, BoxLayout.LINE_AXIS));
	JLabel lblFeatureName = new JLabel("Object Name: ");
	p1.add(Box.createRigidArea(new Dimension(100, 0)));
	p1.add(lblFeatureName);
	txtFeature = new JTextField();
	txtFeature.setEditable(true);
	txtFeature.setBackground(Color.WHITE);
	p1.add(txtFeature);
	p1.add(Box.createRigidArea(new Dimension(100, 0)));

	JPanel p2 = new JPanel();
	p2.setLayout(new BoxLayout(p2, BoxLayout.LINE_AXIS));
	JLabel lblReference = new JLabel("Reference: ");
	p2.add(Box.createRigidArea(new Dimension(100, 0)));
	p2.add(lblReference);
	txtReference = new JTextField();
	txtReference.setEditable(false);
	//txtReference.setText("7.3.1.1");
	txtReference.setBackground(Color.WHITE);
	p2.add(txtReference);
	p2.add(Box.createRigidArea(new Dimension(100, 0)));
	
	JPanel p4 = new JPanel();
	p4.setLayout(new BoxLayout(p4, BoxLayout.LINE_AXIS));
	JLabel lblAttrName = new JLabel("Attribute Name: ");
	p4.add(Box.createRigidArea(new Dimension(100, 0)));
	p4.add(lblAttrName);
	cbAttribute = new JComboBox();
	cbAttribute.setEditable( true );
	cbAttribute.addActionListener( this ); // Watch for changes
	p4.add(cbAttribute);
	p4.add(Box.createRigidArea(new Dimension(100, 0)));

	JPanel p11 = new JPanel();
	p11.setLayout(new BoxLayout(p11, BoxLayout.LINE_AXIS));
	JLabel lblBehaviourName = new JLabel("Behaviour Name: ");
	p11.add(Box.createRigidArea(new Dimension(100, 0)));
	p11.add(lblBehaviourName);
	cbBehaviour = new JComboBox();
	cbBehaviour.setEditable( true );  // Allow edits
	cbBehaviour.addActionListener( this ); //	 Watch for changes
	p11.add(cbBehaviour);
	p11.add(Box.createRigidArea(new Dimension(100, 0)));
	
	JPanel p12 = new JPanel();
	p12.setLayout(new BoxLayout(p12, BoxLayout.LINE_AXIS));
	JLabel lblNotificationName = new JLabel("Notification Name: ");
	p12.add(Box.createRigidArea(new Dimension(100, 0)));
	p12.add(lblNotificationName);
	cbNotification = new JComboBox();
	cbNotification.setEditable( true );  // Allow edits
	cbNotification.addActionListener( this ); //	 Watch for changes
	p12.add(cbNotification);
	p12.add(Box.createRigidArea(new Dimension(100, 0)));

	JPanel p6 = new JPanel();
	p6.setLayout(new BoxLayout(p6, BoxLayout.LINE_AXIS));
	JLabel lblRestrictions = new JLabel("Restrictions: ");
	p6.add(Box.createRigidArea(new Dimension(100, 0)));
	p6.add(lblRestrictions);
	txtRestrictions = new JTextField();
	txtRestrictions.setEditable(true);
	txtRestrictions.setBackground(Color.WHITE);
	p6.add(txtRestrictions);
	p6.add(Box.createRigidArea(new Dimension(100, 0)));
		
	JPanel p5 = new JPanel();
	p5.setLayout(new BoxLayout(p5, BoxLayout.LINE_AXIS));
        textComments = new JTextArea();
        textComments.setEditable(true);
        textComments.setFont(new Font("Serif", Font.ITALIC, 16));
        textComments.setLineWrap(true);
        textComments.setWrapStyleWord(true);
        JScrollPane areaScrollPane = new JScrollPane(textComments);
        areaScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        areaScrollPane.setPreferredSize(new Dimension(150, 150));
        areaScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Comments"),
                            BorderFactory.createEmptyBorder(5,5,5,5)),areaScrollPane.getBorder()));
        p5.add(areaScrollPane);
	p5.add(Box.createRigidArea(new Dimension(100, 0)));
	textComments.setText("testing");
	
	add(p0);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p1);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p2);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p4);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p11);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p12);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p6);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p5);
	add(Box.createRigidArea(new Dimension(0, 5)));	

	setBorder(BorderFactory.createEmptyBorder(10,5,5,5));  // spaces top,botton,right,left

	pMultipleValue = new JPanel();
	pMultipleValue.setLayout(new BoxLayout(pMultipleValue, BoxLayout.LINE_AXIS));

	JPanel p8 = new JPanel();
	p8.setLayout(new BoxLayout(p8, BoxLayout.PAGE_AXIS));
	btnAdd = new JButton("Add changes");
	btnAdd.addActionListener(this);
	btnAdd.setBackground(new Color(204, 204, 255));
	p8.add(btnAdd);
	p8.add(Box.createRigidArea(new Dimension(0, 5)));
	
	pMultipleValue.add(Box.createRigidArea(new Dimension(10, 0)));
	pMultipleValue.add(p8);
	pMultipleValue.add(Box.createRigidArea(new Dimension(100, 0)));
	add(pMultipleValue);	
	
	init();
    }

    
    /**
     * Set the model
     * @param model The model
     */
    public void setICSModel(ICSModel model) {
	icsModel = model;
    }
    /**
     * Handles a click event
     * @param evt The event
     */
    public void actionPerformed(ActionEvent evt) {
    	Object empty ="";
    	Object node;
	if(evt.getSource() == btnAdd) {
	    icsModel.setGenerateEnable(true);
	    String error = "";
	    String index = txtIndex.getText();
	    String feature = txtFeature.getText();
	    String reference = txtReference.getText();
	    String restrictions = txtRestrictions.getText();
	    String comments = textComments.getText();
	        
	    if (pn.getObjectName().equals(txtFeature.getText())){ // if no label was added
	    	pn.setMocComment(textComments.getText()); 
		pn.setObjectName(txtFeature.getText());
                pn.setMocRestrictions(txtRestrictions.getText());
	    }	
	    else { //if a label was added  	    		
	    	int indx = icsModel.getVMoc().indexOf(pn);
	        int attrSize = vAttribute.size();
		if (pn.getAttribute().size() == 0){
		   for (int ac = 0; ac < attrSize; ac++) {
		    	pn.addAttribute((AttributeNode)vAttribute.get(ac));
	           }
		}				
		int behaviourSize = vBehaviour.size();
		if (pn.getBehaviour().size() == 0){
		   for (int ac = 0; ac < behaviourSize; ac++) {
		      pn.addBehaviour((BehaviourNode)vBehaviour.get(ac));
	           }
		}	
			
		int notificationSize = vNotification.size();
		if (pn.getNotification().size() == 0){
		   for (int ac = 0; ac < notificationSize; ac++) {
		      pn.addNotification((NotificationNode)vNotification.get(ac));
	           }
		}	
			
	    	pn.setMocComment(textComments.getText()); 
		pn.setObjectName(txtFeature.getText()); 
                pn.setMocRestrictions(txtRestrictions.getText());   
		    
		icsModel.getVMoc().set(indx,pn);
		    
		icsModel.fireEvent(new MVCArg("tree status","tree changed"));		    
	    }
 
	    txtReference.setText("");
	    txtRestrictions.setText("");
	    textComments.setText("");
	}
	 if(evt.getSource() == btnRemove) {	  
	    btnRemove.setEnabled(false);	  
	    String sValue = "";		  
	    txtReference.setText("");	
	    textComments.setText("");
	    pn.setMocComment(""); 
	    pn.setStatus("");   // removing from the model for a particular object
	    txtRestrictions.setText("");
	    textComments.setText("");
	}
	if( evt.getSource() == cbAttribute)
	{		
	   if((cbAttribute.getSelectedItem() != null) && ((String)cbAttribute.getSelectedItem() != "") && !(cbAttribute.getSelectedItem().equals(empty))){	   	
		dlgAddAttr = new AddAttrDialog(null,cbAttribute.getSelectedItem(), pn, icsModel);
		dlgAddAttr.pack();
		
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension windowSize = dlgAddAttr.getSize();
		dlgAddAttr.setLocation(Math.max(0,(screenSize.width -windowSize.width)/2),Math.max(0,(screenSize.height-windowSize.height)/2));
		dlgAddAttr.setVisible(true);
	   }	
	}
	
	if( evt.getSource() == cbBehaviour)
	{
		if(cbBehaviour.getSelectedItem() != null && ((String)cbBehaviour.getSelectedItem() != "") && !(cbBehaviour.getSelectedItem().equals(empty))){
		dlgAddBehaviour = new AddBehaviourDialog(null,cbBehaviour.getSelectedItem(), pn, icsModel);
		dlgAddBehaviour.pack();
		
		//Position the window in the screen
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension windowSize = dlgAddBehaviour.getSize();
		dlgAddBehaviour.setLocation(Math.max(0,(screenSize.width -windowSize.width)/2),Math.max(0,(screenSize.height-windowSize.height)/2));
		dlgAddBehaviour.setVisible(true);
		}
	}
	
	if( evt.getSource() == cbNotification)
	{
		if(cbNotification.getSelectedItem() != null && ((String)cbNotification.getSelectedItem() != "") && !(cbNotification.getSelectedItem().equals(empty))){
		dlgAddNotification = new AddNotificationDialog(null,cbNotification.getSelectedItem(), pn, icsModel);
		dlgAddNotification.pack();
		
		//Position the window in the screen
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension windowSize = dlgAddNotification.getSize();
		dlgAddNotification.setLocation(Math.max(0,(screenSize.width -windowSize.width)/2),Math.max(0,(screenSize.height-windowSize.height)/2));
		dlgAddNotification.setVisible(true);
		}
	}
	
    }

   
    public void update(Observable o, Object arg) {
    	
    	
    	
    	if(o instanceof ICSModel) {
    		
    		if("node tree".equals(((MVCArg)arg).getName())) {
    		   currentNode = ((MVCArg)arg).getTValue();
    		}
    		if("node".equals(((MVCArg)arg).getName())) {
    		   cbAttribute.removeAllItems();
    		   cbBehaviour.removeAllItems();
    		   cbNotification.removeAllItems();    			
    		   btnAdd.setEnabled(true);
    		   Object obj = ((MVCArg)arg).getOValue();
    		   if(obj instanceof MOCNode) {    			
    		      pn = (MOCNode) obj;     //pn is a class object MOCNode
    		      int inx = icsModel.getVMoc().indexOf(pn);
    		    
    		      MOCNode mocNodeT = (MOCNode)icsModel.getVMoc().get(inx);
    		      txtFeature.setText(pn.getObjectName());
    		      txtReference.setText(pn.getReference());
    		      txtIndex.setText(pn.getObjectId());
    		      textComments.setText(pn.getMocComment());
                      txtRestrictions.setText(pn.getMocRestrictions());    		    			
    		      int index = icsModel.getVMoc().indexOf(pn);
    		      MOCNode mocNode = (MOCNode)icsModel.getVMoc().get(index);
    			
    		      vAttribute = mocNode.getAttribute();
    		      vBehaviour = mocNode.getBehaviour();
    		      vNotification = mocNode.getNotification();
    		
    		      for (int ac = 0; ac < vAttribute.size(); ac++) {
    	                 vComboAttrModel.add(((AttributeNode)vAttribute.get(ac)).getAttributeName());
    	              }
    			
    		      ComboBoxModel model = new DefaultComboBoxModel(vComboAttrModel); //The vector should contain all the attributes for a particular object.
    		      cbAttribute.setModel(model);
    			    			
    		      for (int ac = 0; ac < vBehaviour.size(); ac++) {    			
    			 vComboBehaviourModel.add(((BehaviourNode)vBehaviour.get(ac)).getMethodName());
    	              }
    		      ComboBoxModel bModel = new DefaultComboBoxModel(vComboBehaviourModel); //The vector should contain all the attributes for a particular object.
    		      cbBehaviour.setModel(bModel);
    		
    		      for (int ac = 0; ac < vNotification.size(); ac++) {        			
        		 vComboNotificationModel.add(((NotificationNode)vNotification.get(ac)).getNotificationName());
        	      }
    			
    		      ComboBoxModel nModel = new DefaultComboBoxModel(vComboNotificationModel); //The vector should contain all the attributes for a particular object.
    		      cbNotification.setModel(nModel);
    			
    		      updateUI();
    		   }
    		}
    	    }
    	}
        
    /**
     * Handles a list click event
     * @param evt The event
     */
    public void valueChanged(ListSelectionEvent evt) {
	btnRemove.setEnabled(true);

    }

    public void init() {
    	btnAdd.setEnabled(true);
    	vListModel = new Vector();
    	vComboAttrModel = new Vector();
    	vComboBehaviourModel = new Vector();
    	vComboNotificationModel = new Vector();    
   }	
}    
