/**
 * This class represents a node of the profile
 */

public abstract class DIMMOC {

   protected String object_name;
   protected String object_id;
   protected String moc_ref;
   protected String status;
   protected String restrictions;
   protected String additionalObj;
   protected String privateObj;
   protected String moc_restrictions;
   protected String moc_application_guidance;
   protected String moc_comment;
	   
   protected String attribute_name;
   protected String attribute_id;
   protected String attr_ref;
   protected String attr_qual;
   protected String attr_status;
   protected String attr_access;
   protected String attr_value_range;
   protected String attr_restrictions;
   protected String attr_application_guidance;
   protected String attr_comment;
 
   protected String method_name;
   protected String method_id;
   protected String behav_ref;
   protected String behav_qual;
   protected String behav_status;
   protected String behav_restrictions;
   protected String behav_comment;

   protected String notification_name;
   protected String notification_id;
   protected String noti_ref;
   protected String noti_qual;
   protected String noti_status;
   protected String noti_restrictions;
   protected String noti_comment;
	   
   protected String[] moc;

   public DIMMOC() {}

	   //
	   // MOC
	   //

	   public String getObjectName() {
	      return object_name;
	   }

	   public String getObjectId() {
	      return object_id;
	   }
	 
	   public String getReference() {
	      return moc_ref;
	   }
	   
	   public String getStatus() {
    	      return status;
           }

	   public String getAdditionalObj() {
    	      return additionalObj;
           }

	   public String getPrivateObj() {
    	      return privateObj;
           }

	   public String getMocRestrictions() {
    	      return moc_restrictions;
           }

	   public String getMocApplicationGuidance() {
    	      return moc_application_guidance;
           }

	   public String getMocComment() {
    	      return moc_comment;
           }

	   //
	   // Attribute
	   //

	   public String getAttributeName() {
	      return attribute_name;
	   }

	   public String getAttributeId() {
	      return attribute_id;
	   }
	 
	   public String getAttributeReference() {
	      return attr_ref;
	   }

	   public String getAttributeQual() {
	      return attr_qual;
	   }
	   public String getAttributeStatus(){
	      return attr_status;
	   }

	   public String getAttributeAccess(){
	      return attr_access;
	   }

	   public String getAttributeValueRange(){
	      return attr_value_range;
	   }

	   public String getAttributeRestrictions(){
	      return attr_restrictions;
	   }

	   public String getAttributeApplicationGuidance(){
	      return attr_application_guidance;
	   }

	   public String getAttributeComment() {
    	      return attr_comment;
           }

	   //
	   // Behaviour
	   //

	   public String getMethodName() {
	      return method_name;
	   }

	   public String getMethodId() {
	      return method_id;
	   }
	 
	   public String getBehaviourReference() {
	      return behav_ref;
	   }

	   public String getBehaviourQual() {
	      return behav_qual;
	   }
	   
	   public String getBehaviourStatus() {
	      return behav_status;
	   }

	   public String getBehaviourRestrictions() {
	      return behav_restrictions;
	   }

	   public String getBehaviourComment() {
              return behav_comment;
           }

	   //
	   // Notification
	   //

	   public String getNotificationName() {
	      return notification_name;
	   }

	   public String getNotificationId() {
	      return notification_id;
	   }
	 
	   public String getNotificationReference() {
	      return noti_ref;
	   }

	   public String getNotificationQual() {
	      return noti_qual;
	   }
	   
	   public String getNotificationStatus() {
	      return noti_status;
	   }

	   public String getNotificationRestrictions() {
	      return noti_restrictions;
	   }

	   public String getNotificationComment() {
    	      return noti_comment;
           }

	   //
	   // SET
	   //

	   //
	   // MOC
	   //

	   public void setObjectName(String object_name) {
	      this.object_name = object_name;
	   }

	   public void setObjectId(String object_id) {
	      this.object_id = object_id;
	   }

	   public void setReference(String moc_ref) {
	      this.moc_ref = moc_ref;
	   }

	   public void setStatus(String status) {
    	      this.status = status;
           }

	   public void setAdditionalObj(String additionalObj) {
              this.additionalObj = additionalObj;
           }

	   public void setPrivateObj(String privateObj) {
    	     this.privateObj = privateObj;
           }

	   public void setMocRestrictions(String moc_restrictions) {
    	     this.moc_restrictions =moc_restrictions;
           }

	   public void setMocApplicationGuidance(String moc_application_guidance) {
    	     this.moc_application_guidance = moc_application_guidance;
           }

	   public void setMocComment(String moc_comment) {
    	    this.moc_comment = moc_comment;
           }

	   //
	   // Attribute
	   //

	   public void setAttributeName(String attribute_name) {
	      this.attribute_name = attribute_name;
	   }

	   public void setAttributeId(String attribute_id) {
	      this.attribute_id = attribute_id;
	   }

	   public void setAttributeReference(String attr_ref) {
	      this.attr_ref = attr_ref;
	   }

	   public void setAttributeQual(String attr_qual) {
	      this.attr_qual = attr_qual;
	   }
	   
	   public void setAttributeStatus(String attr_status) {
	      this.attr_status = attr_status;
	   }

	   public void setAttributeAccess(String attr_access) {
	      this.attr_access = attr_access;
	   }

	   public void setAttributeValueRange(String attr_value_range) {
	      this.attr_value_range = attr_value_range;
	   }

	   public void setAttributeApplicationGuidance(String attr_application_guidance) {
	      this.attr_application_guidance = attr_application_guidance;
	   }

	   public void setAttributeRestrictions(String attr_restrictions) {
	      this.attr_restrictions = attr_restrictions;
	   }

	   public void setAttributeComment(String attr_comment) {
    	      this.attr_comment = attr_comment;
           }

	   //
	   // Behaviour
	   //

	   public void setMethodName(String method_name) {
	      this.method_name = method_name;
	   }

	   public void setMethodId(String method_id) {
	      this.method_id = method_id;
	   }

	   public void setBehaviourReference(String behav_ref) {
	      this.behav_ref = behav_ref;
	   }

	   public void setBehaviourQual(String behav_qual) {
	      this.behav_qual = behav_qual;
	   }
	   
	   public void setBehaviourStatus(String behav_status) {
	      this.behav_status = behav_status;
	   }

	   public void setBehaviourRestrictions(String behav_restrictions) {
	      this.behav_restrictions = behav_restrictions;
	   }

	   public void setBehaviourComment(String behav_comment) {
    	      this.behav_comment = behav_comment;
           }

	   //
	   // Notification
	   //

	   public void setNotificationName(String notification_name) {
	      this.notification_name = notification_name;
	   }

	   public void setNotificationId(String notification_id) {
	      this.notification_id = notification_id;
	   }

	   public void setNotificationReference(String noti_ref) {
	      this.noti_ref = noti_ref;
	   }

	   public void setNotificationQual(String noti_qual) {
	      this.noti_qual = noti_qual;
	   }
	   
	   public void setNotificationStatus(String noti_status) {
	      this.noti_status = noti_status;
	   }
	   
	   public void setNotificationRestrictions(String noti_restrictions) {
	      this.noti_restrictions = noti_restrictions;
	   }

	   public void setNotificationComment(String noti_comment) {
    	      this.noti_comment = noti_comment;
           }

	   public void setMOCList() {
              String[] moc = {"VMD","VMO","MDS","Metric","Channel"};
    	      this.moc = moc;
           }

	   public boolean equals(Object o) {
	      DIMMOC dn = (DIMMOC)o;
	      boolean equal = true;

	      if(object_name.compareTo(dn.getObjectName()) != 0)
		 equal = false;
		 return equal;
	      }
          }
