/**
 * This dialog allows the user to add attributes
*/

// JDK

import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;

// AWT
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

// Swing
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JComboBox;
import javax.swing.JButton;
import javax.swing.BoxLayout;
import javax.swing.Box;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class AddAttrDialog extends JDialog implements Observer, ActionListener{

    private JTextField txtAttrId;
    private JComboBox cbAttributeAccess;
    private JTextField txtStatus;
    private JTextField txtFeature;
    private JTextField txtReference;
    private JTextField txtAttrName;
    private JTextField txtComments;
    private JTextField txtRestrictions;
    private JTextField txtValueRange;
    private JTextField txtAdditionalObj;
    private JTextField txtPrivateObj;
    private JTextField txtQual;
    private JTextField txtAttributeAccess;
    private JTextArea textComments;

    private JPanel pMultipleValue;
    private JPanel p6;

    private JList lstValue;
    private JScrollPane lstValueScrollPane;
    private JButton btnAdd;
    private JButton btnClose;

    private Vector vListModel;
    private DIMMOC pn;
    private MOCNode mocNode ;
    private Object attrSelected;
    
    private ICSModel icsModel;

    String[] attributeAccess = { "GET", "GET-GRP", "SET", "SCAN", "SCAN-GRP", "ER", "CR-ER" };

     /**
     * Constructor
     * @param frame A frame
     */
    public AddAttrDialog(JFrame frame, Object selection, MOCNode selectedMoc, ICSModel model) {
    	
	super(frame, "Add an attribute ", true);
	

	attrSelected = selection;
	setICSModel(model);
	
	BoxLayout layout = new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS);
	getContentPane().setLayout(layout);
	
	JPanel p0 = new JPanel();
	p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));
	JLabel lblAttrId = new JLabel("Index: ");
	p0.add(lblAttrId);
	txtAttrId = new JTextField();
	txtAttrId.setEditable(false);
	txtAttrId.setBackground(Color.WHITE);
	p0.add(txtAttrId);
	p0.add(Box.createRigidArea(new Dimension(100, 0)));
	
	JPanel p1 = new JPanel();
	p1.setLayout(new BoxLayout(p1, BoxLayout.LINE_AXIS));
	JLabel lblAttrName = new JLabel("Atrribute Name: ");
	p1.add(lblAttrName);
	txtAttrName = new JTextField();
	txtAttrName.setEditable(true);
	txtAttrName.setBackground(Color.WHITE);
	p1.add(txtAttrName);
	p1.add(Box.createRigidArea(new Dimension(100, 0)));

	JPanel p2 = new JPanel();
	p2.setLayout(new BoxLayout(p2, BoxLayout.LINE_AXIS));
	JLabel lblReference = new JLabel("Reference: ");
	p2.add(lblReference);
	txtReference = new JTextField();
	txtReference.setEditable(false);
	txtReference.setBackground(Color.WHITE);
	p2.add(txtReference);
	p2.add(Box.createRigidArea(new Dimension(100, 0)));
	
	JPanel p22 = new JPanel();
	p22.setLayout(new BoxLayout(p22, BoxLayout.LINE_AXIS));
	JLabel lblQual = new JLabel("Qualifier: ");
	p22.add(lblQual);
	txtQual = new JTextField();
	txtQual.setEditable(false);
	txtQual.setBackground(Color.WHITE);
	p22.add(txtQual);
	p22.add(Box.createRigidArea(new Dimension(100, 0)));
	
	JPanel p3 = new JPanel();
	p3.setLayout(new BoxLayout(p3, BoxLayout.LINE_AXIS));
	JLabel lblStatus = new JLabel("Status: ");
	p3.add(lblStatus);
	txtStatus = new JTextField();
	txtStatus.setEditable(true);
	txtStatus.setBackground(Color.WHITE);
	p3.add(txtStatus);
	p3.add(Box.createRigidArea(new Dimension(100, 0)));

	JPanel p6 = new JPanel();
	p6.setLayout(new BoxLayout(p6, BoxLayout.LINE_AXIS));
	JLabel lblSupport = new JLabel("Support");
	p6.add(lblSupport);
	JPanel p61 = new JPanel();
	p61.setLayout(new BoxLayout(p61, BoxLayout.LINE_AXIS));
	JLabel lblRestrictions = new JLabel("Restrictions: ");
	p61.add(lblRestrictions);
	txtRestrictions = new JTextField();
	txtRestrictions.setEditable(true);
	txtRestrictions.setBackground(Color.WHITE);
	p61.add(txtRestrictions);
	p61.add(Box.createRigidArea(new Dimension(100, 0)));
	
	JPanel p62 = new JPanel();
	p62.setLayout(new BoxLayout(p62, BoxLayout.LINE_AXIS));
	JLabel lblValueRange = new JLabel("Value range: ");
	p62.add(lblValueRange);
	txtValueRange = new JTextField();
	txtValueRange.setEditable(true);
	txtRestrictions.setBackground(Color.WHITE);
	p62.add(txtValueRange);
	p62.add(Box.createRigidArea(new Dimension(100, 0)));
		
	JPanel p63 = new JPanel();
	p63.setLayout(new BoxLayout(p63, BoxLayout.LINE_AXIS));
	JLabel lblAttributeAccess = new JLabel("Attribute access: ");
	p63.add(Box.createRigidArea(new Dimension(100, 0)));
	p63.add(lblAttributeAccess);
	cbAttributeAccess = new JComboBox(attributeAccess);
	cbAttributeAccess.setEditable( true );  // Allow edits
	cbAttributeAccess.addActionListener( this ); //	 Watch for changes
	p63.add(cbAttributeAccess);
	p63.add(Box.createRigidArea(new Dimension(100, 0)));
	
	getContentPane().add(p0);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p1);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p2);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p22);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p3);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p6);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p61);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p63);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p62);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));


	pMultipleValue = new JPanel();
	pMultipleValue.setLayout(new BoxLayout(pMultipleValue, BoxLayout.LINE_AXIS));

	JPanel p10 = new JPanel();
	p10.setLayout(new BoxLayout(p10, BoxLayout.PAGE_AXIS));
	lstValue = new JList();
	lstValueScrollPane = new JScrollPane(lstValue);
	p10.add(lstValueScrollPane);
	p10.add(Box.createRigidArea(new Dimension(0, 5)));

	JPanel p8 = new JPanel();
	p8.setLayout(new BoxLayout(p8, BoxLayout.LINE_AXIS));
	btnAdd = new JButton("Add");
	btnAdd.addActionListener(this);
	btnAdd.setBackground(new Color(204, 204, 255));
	p8.add(btnAdd);
	p8.add(Box.createRigidArea(new Dimension(0, 5)));
	
	btnClose = new JButton("Close");
	btnClose.addActionListener((ActionListener) this);
	btnClose.setBackground(new Color(204, 204, 255));
	p8.add(btnClose);

	pMultipleValue.add(Box.createRigidArea(new Dimension(100, 0)));
	pMultipleValue.add(Box.createRigidArea(new Dimension(10, 0)));
	pMultipleValue.add(p8);
	pMultipleValue.add(Box.createRigidArea(new Dimension(100, 0)));
	getContentPane().add(pMultipleValue);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	init();
	
	if(icsModel != null ) {
	   int index = icsModel.getVMoc().indexOf(selectedMoc);
	   mocNode = (MOCNode)icsModel.getVMoc().get(index);
			
	   Vector vAttribute = mocNode.getAttribute();
			
	   for (int ac = 0; ac < vAttribute.size(); ac++) {
	      AttributeNode atrributeNode = (AttributeNode)vAttribute.get(ac);
    	      if (atrributeNode.getAttributeName().equals(selection.toString())){
    		 txtReference.setText(atrributeNode.getAttributeReference());
    		 txtAttrId.setText(atrributeNode.getAttributeId());
    		 txtAttrName.setText(atrributeNode.getAttributeName());
    		 txtQual.setText(atrributeNode.getAttributeQual());
    		 txtStatus.setText(atrributeNode.getAttributeStatus());
    		 txtRestrictions.setText(atrributeNode.getAttributeRestrictions());
    					
    	      }
	   }
    	         
        }
    }

    /**
     * Set the model
     * @param model The model
     */
    public void setICSModel(ICSModel model) {
	icsModel = model;
    }
    /**
     * Handles a click event
     * @param evt The event
     */
    public void actionPerformed(ActionEvent evt) {
	if(evt.getSource() == btnAdd) {
	    String error = "";
	    String status = txtStatus.getText();
	    String restrictions = txtRestrictions.getText();
	    String attrName = txtAttrName.getText();
	    String qual = txtQual.getText();
	    String attrId = txtAttrId.getText();
	    String reference = txtReference.getText();
	  
	    Vector vAttribute = mocNode.getAttribute();
		
	    for (int ac = 0; ac < vAttribute.size(); ac++) {
	       AttributeNode atrributeNode = (AttributeNode)vAttribute.get(ac);
	       if (atrributeNode.getAttributeName().equals(attrSelected.toString())){
		  atrributeNode.setAttributeStatus(txtStatus.getText());
		  atrributeNode.setAttributeRestrictions(txtRestrictions.getText());					
	       }
	    }
	 
	    txtAttrName.setText("");
	    txtQual.setText("");
	    txtAttrId.setText("");
	    txtReference.setText("");
	    txtStatus.setText("");
	    txtRestrictions.setText("");
	 
	}
	else if(evt.getSource() == btnClose) {
	    setVisible(false);
	}
    }
   
    public void update(Observable o, Object arg) {
    	if(o instanceof ICSModel) {
    	    if(arg instanceof MVCArg) {
    		if("node".equals(((MVCArg)arg).getName())) {
    		    btnAdd.setEnabled(true);
    		    Object obj = ((MVCArg)arg).getOValue();
    		    if(obj instanceof DIMMOC) {
    			pn = (DIMMOC)obj;
    	            }
    	        }
            }
    	}
    }
    /**
     * Handles a list click event
     * @param evt The event
     */

    private void init() {
    	btnAdd.setEnabled(true);
    	vListModel = new Vector();
    }
}
