import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.BorderFactory;
import javax.swing.JList;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

import java.net.URL;
import java.io.File;
import java.io.IOException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.*;

import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.Enumeration;

public class ICSModel extends Observable { 
	  
	   private DefaultMutableTreeNode treeNode, vecTreeNode;
	    
	   public Vector vMOC;

	   private AttributeNode curAttribute;
	   private BehaviourNode curBehaviour;
	   private NotificationNode curNotification;

	   private MOCNode curMOC;
	   private MOCNode tmpmoc;

	   private int curIndex=0;

	   String mdsType;
           String icsToLoad;
       
         boolean setEnable;
	   
	   /**
	    * Fire an event
	    * @param arg An MVCArg object
	    */
	   public void fireEvent(MVCArg arg) {
		setChanged();
		notifyObservers(arg);
	   }

         public void setGenerateEnable(boolean isEnable) {
               setEnable = isEnable;
               setChanged();
               notifyObservers(new MVCArg("isEnable", setEnable));
         }
	   
	   public void setMDS(String mds) {
	   	mdsType = mds;
		setChanged();
		notifyObservers(new MVCArg("mdsType", mdsType));
	   }

	   public void setICS(String ics) {
	   	
	   	icsToLoad = ics;
	   
		setChanged();
		notifyObservers(new MVCArg("icsToLoad", icsToLoad));
	   }

	   /**
	    * Get the structure
	    * @return The structure
	    */
	   public String getMDS() {
		return mdsType;
	   }

	   public String getICS() {
		return icsToLoad;
	   }

	   public DefaultMutableTreeNode getMainTree(String MDSType) throws SAXException, IOException, ParserConfigurationException{

	      vMOC = new Vector(); 

	      DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	      DocumentBuilder builder = factory.newDocumentBuilder();
	      Document doc = builder.parse(new File("c:/ICS/xml/"+getICS()));
	      
	      Element mdsNode; 
	      Element docroot = doc.getDocumentElement();	            

	      if (MDSType.equals("Hydra")) {                          
	           mdsNode = doc.createElement("Hydra_MDS");
	           while (docroot.hasChildNodes()) {
	               mdsNode.appendChild(docroot.getFirstChild());
	           }
	           docroot.getParentNode().replaceChild(mdsNode, docroot);
	           NodeList mdsChildren = mdsNode.getChildNodes();
	           Text objname = (Text) mdsChildren.item(1).getFirstChild();
	           objname.setData("Hydra_MDS");
	           Text objid = (Text) mdsChildren.item(3).getFirstChild();
	           objid.setData("NOM_MOC_VMS_MDS_HYD");
	           Text ref = (Text) mdsChildren.item(5).getFirstChild();
	           ref.setData("clause 7.5.4");	                                  
	      }
	      else {
	          mdsNode = docroot;
	      }

	      treeNode = processXML(mdsNode); 

	      Enumeration treeEnum = treeNode.preorderEnumeration();
	      DefaultMutableTreeNode tNode = (DefaultMutableTreeNode) treeEnum.nextElement();              
	      vecTreeNode = createVecTreeRelationship(tNode);      
	      return vecTreeNode;
	   }
	  
	   private DefaultMutableTreeNode createVecTreeRelationship(DefaultMutableTreeNode rNode) {

	      DefaultMutableTreeNode vecTreeNode = null;

	      MOCNode tmpMoc = new MOCNode();
	      tmpMoc.setObjectName(rNode.toString());
	      int index = vMOC.indexOf(tmpMoc,curIndex);
	      curIndex = index+1;
	      MOCNode mocNode = (MOCNode)vMOC.get(index);
	      vecTreeNode = new DefaultMutableTreeNode(new MOCNode(mocNode));

	      if (!rNode.isLeaf()) {
	         Enumeration chldrn = rNode.children();
	         while ( chldrn.hasMoreElements()) {
	            DefaultMutableTreeNode tnd = (DefaultMutableTreeNode) chldrn.nextElement();         
	            vecTreeNode.add(createVecTreeRelationship(tnd));  
	         }
	      }
	      return vecTreeNode;
	   }

	   private DefaultMutableTreeNode addToVecTreeRelationship(DefaultMutableTreeNode rNode) {

	      DefaultMutableTreeNode vecTreeNode = null;

	      MOCNode tmpMoc = new MOCNode();
	      tmpMoc.setObjectName(rNode.toString());
	      int index = vMOC.indexOf(tmpMoc,curIndex);
	      curIndex = index+1;
	      MOCNode mocNode = (MOCNode)vMOC.get(index);
              vMOC.add(mocNode);
	      vecTreeNode = new DefaultMutableTreeNode(new MOCNode(mocNode));

	      if (!rNode.isLeaf()) {
	         Enumeration chldrn = rNode.children();
	         while ( chldrn.hasMoreElements()) {
	            DefaultMutableTreeNode tnd = (DefaultMutableTreeNode) chldrn.nextElement();         
	            vecTreeNode.add(addToVecTreeRelationship(tnd));  
	         }
	      }
	      return vecTreeNode;
	   }

	   private DefaultMutableTreeNode processXML(Node root) {
	  
	      DefaultMutableTreeNode treeNode = null;

	      String                 name, value;

	      name = root.getNodeName();
	      value = root.getNodeValue();

	      treeNode = new DefaultMutableTreeNode(root.getNodeType() == Node.TEXT_NODE ? value : name);
	      
	      if (root.hasChildNodes()) {

	         NodeList children;

	         int numChildren;
	         Node node;
                 String nodeValue;
	        
	         children = root.getChildNodes();
	         if (children != null) {
	            numChildren = children.getLength();
	            curMOC = new MOCNode();
	            for (int j=0; j < numChildren; j++) {
	               node = children.item(j);                 
	               if (node != null) {                     
	 	          if (node.getNodeType() == Node.ELEMENT_NODE) {
		             if (node.getNodeName().equals("OBJECT_NAME")) {
	                        curMOC.setObjectName(node.getFirstChild().getNodeValue());
	                     }
	                     else if (node.getNodeName().equals("OBJECT_ID")) {
	                        curMOC.setObjectId(node.getFirstChild().getNodeValue());
	                     }      
	                     else if (node.getNodeName().equals("Reference")) { 
	                        curMOC.setReference(node.getFirstChild().getNodeValue());
	                     }
	                     else if (node.getNodeName().equals("MOC_RESTRICTIONS")) {
                                if (node.getFirstChild() == null) {
                                   curMOC.setMocRestrictions("");
                                }
                                else {
 	                           curMOC.setMocRestrictions(node.getFirstChild().getNodeValue());
                                }
	                     }
	                     else if (node.getNodeName().equals("MOC_APPLICATION_GUIDANCE")) { 
                                if (node.getFirstChild() == null) {
                                   curMOC.setMocApplicationGuidance("");
                                }
                                else {
 	                           curMOC.setMocApplicationGuidance(node.getFirstChild().getNodeValue());
                                }
	                     }
	                     else if (node.getNodeName().equals("MOC_COMMENT")) { 
                                if (node.getFirstChild() == null) {
                                   curMOC.setMocComment("");
                                }
                                else {
 	                           curMOC.setMocComment(node.getFirstChild().getNodeValue());
                                }
	                        vMOC.add(curMOC);
	                     }
	                     else if (node.getNodeName().equals("Attribute_Info")) {
	                         NodeList attrChildren = node.getChildNodes();
	                         curAttribute = new AttributeNode();
	                         for (int k = 0; k < attrChildren.getLength(); k++) {
	                             if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_NAME")) {
	                                curAttribute.setAttributeName(attrChildren.item(k).getFirstChild().getNodeValue());
	                             }
	                             else if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_ID")) {
	                                curAttribute.setAttributeId(attrChildren.item(k).getFirstChild().getNodeValue());
	                             }
	                             else if (attrChildren.item(k).getNodeName().equals("Reference")) {
	                                curAttribute.setAttributeReference(attrChildren.item(k).getFirstChild().getNodeValue());
	                             }
	                             else if (attrChildren.item(k).getNodeName().equals("Qual")) {
	                                curAttribute.setAttributeQual(attrChildren.item(k).getFirstChild().getNodeValue());
	                             }
	                             else if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_ACCESS")) {
                                        if (attrChildren.item(k).getFirstChild() == null) {
                                           curAttribute.setAttributeAccess("");
                                        }
                                        else {
 	                                   curAttribute.setAttributeAccess(attrChildren.item(k).getFirstChild().getNodeValue());
                                        }
	                             }
	                             else if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_VALUE_RANGE")) {
                                        if (attrChildren.item(k).getFirstChild() == null) {
                                           curAttribute.setAttributeValueRange("");
                                        }
                                        else {
 	                                   curAttribute.setAttributeValueRange(attrChildren.item(k).getFirstChild().getNodeValue());
                                        }
	                             }
	                             else if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_RESTRICTIONS")) {
                                        if (attrChildren.item(k).getFirstChild() == null) {
                                           curAttribute.setAttributeRestrictions("");
                                        }
                                        else {
 	                                   curAttribute.setAttributeRestrictions(attrChildren.item(k).getFirstChild().getNodeValue());
                                        }
	                             }
	                             else if (attrChildren.item(k).getNodeName().equals("ATTR_APPLICATION_GUIDANCE")) {
                                        if (attrChildren.item(k).getFirstChild() == null) {
                                           curAttribute.setAttributeApplicationGuidance("");
                                        }
                                        else {
 	                                   curAttribute.setAttributeApplicationGuidance(attrChildren.item(k).getFirstChild().getNodeValue());
                                        }
	                             }
	                             else if (attrChildren.item(k).getNodeName().equals("ATTRIBUTE_COMMENT")) {
                                        if (attrChildren.item(k).getFirstChild() == null) {
                                           curAttribute.setAttributeComment("");
                                        }
                                        else {
 	                                   curAttribute.setAttributeComment(attrChildren.item(k).getFirstChild().getNodeValue());
                                        }
	                             }
	                         }
	                         curMOC.addAttribute(curAttribute);
	                     }
	                     else if (node.getNodeName().equals("Behaviour_Info")) {
	                         NodeList behavChildren = node.getChildNodes();
	                         curBehaviour = new BehaviourNode();
	                         for (int l = 0; l < behavChildren.getLength(); l++) {
	                             if (behavChildren.item(l).getNodeName().equals("METHOD_NAME")) {
	                                curBehaviour.setMethodName(behavChildren.item(l).getFirstChild().getNodeValue());
	                             }
	                             else if (behavChildren.item(l).getNodeName().equals("METHOD_ID")) {
	                                curBehaviour.setMethodId(behavChildren.item(l).getFirstChild().getNodeValue());
	                             }
	                             else if (behavChildren.item(l).getNodeName().equals("Reference")) {
	                                curBehaviour.setBehaviourReference(behavChildren.item(l).getFirstChild().getNodeValue());
	                             }
	                             else if (behavChildren.item(l).getNodeName().equals("Qual")) {
	                                curBehaviour.setBehaviourQual(behavChildren.item(l).getFirstChild().getNodeValue());
	                             }
	                             else if (behavChildren.item(l).getNodeName().equals("BEHAVIOUR_RESTRICTIONS")) {
                                        if (behavChildren.item(l).getFirstChild() == null) {
                                           curBehaviour.setBehaviourRestrictions("");
                                        }
                                        else {
 	                                   curBehaviour.setBehaviourRestrictions(behavChildren.item(l).getFirstChild().getNodeValue());
                                        }
	                             }
	                             else if (behavChildren.item(l).getNodeName().equals("BEHAVIOUR_COMMENT")) {
                                        if (behavChildren.item(l).getFirstChild() == null) {
                                           curBehaviour.setBehaviourComment("");
                                        }
                                        else {
 	                                   curBehaviour.setBehaviourComment(behavChildren.item(l).getFirstChild().getNodeValue());
                                        }
	                             }
	                         }
	                         curMOC.addBehaviour(curBehaviour);
	                     }
	                     else if (node.getNodeName().equals("Notification_Info")) {
	                         NodeList notiChildren = node.getChildNodes();
	                         curNotification = new NotificationNode();
	                         for (int m = 0; m < notiChildren.getLength(); m++) {
	                             if (notiChildren.item(m).getNodeName().equals("NOTIFICATION_NAME")) {
	                                curNotification.setNotificationName(notiChildren.item(m).getFirstChild().getNodeValue());
	                             }
	                             else if (notiChildren.item(m).getNodeName().equals("NOTIFICATION_ID")) {
	                                curNotification.setNotificationId(notiChildren.item(m).getFirstChild().getNodeValue());
	                             }
	                             else if (notiChildren.item(m).getNodeName().equals("Reference")) {
	                                curNotification.setNotificationReference(notiChildren.item(m).getFirstChild().getNodeValue());
	                             }
	                             else if (notiChildren.item(m).getNodeName().equals("Qual")) {
	                                curNotification.setNotificationQual(notiChildren.item(m).getFirstChild().getNodeValue());
	                             }
	                             else if (notiChildren.item(m).getNodeName().equals("NOTIFICATION_RESTRICTIONS")) {
                                        if (notiChildren.item(m).getFirstChild() == null) {
                                           curNotification.setNotificationRestrictions("");
                                        }
                                        else {
 	                                   curNotification.setNotificationRestrictions(notiChildren.item(m).getFirstChild().getNodeValue());
                                        }
	                             }
	                             else if (notiChildren.item(m).getNodeName().equals("NOTIFICATION_COMMENT")) {
                                        if (notiChildren.item(m).getFirstChild() == null) {
                                           curNotification.setNotificationComment("");
                                        }
                                        else {
 	                                   curNotification.setNotificationComment(notiChildren.item(m).getFirstChild().getNodeValue());
                                        }
	                             }
	                         }
	                         curMOC.addNotification(curNotification);
	                     }	    
	                     
	                     else {  
	                        treeNode.add(processXML(node));
	                     }
	                  }
	               }
	            }
	         }
	      }
	      return treeNode;
	   } 

	 public void removeMOC(DefaultMutableTreeNode mocNode) {
	   	mocNode.removeFromParent();
	   }
	   /**
	    * Get the tree representation of the batch
	    * @return The tree representation of the batch
	    */
	   public DefaultMutableTreeNode getTree() {
		return vecTreeNode;
	   }
	   public Vector getVMoc() {
		return vMOC;
	   }
	   
	   public void addToVMoc(MOCNode moc) {
	      if (moc != null) {
	      	vMOC.add(moc);
	      }
	      }

	   public void renameMOC(DefaultMutableTreeNode mocToRename, String mocNewname) {
	   	addMOC(mocNewname,(DefaultMutableTreeNode)mocToRename.getParent());
	    }
	   
	   public void addMOC(String mocToAdd, DefaultMutableTreeNode mocHighlighted) {
	   	if (!mocToAdd.equals("No children")){
	   	mocHighlighted.add(getNode(mocToAdd,mocHighlighted));
	    }
	   }
	   
	   private DefaultMutableTreeNode getNode(String mocType, DefaultMutableTreeNode mocHighlighted) {
	      DefaultMutableTreeNode mocToAdd = null;
	      curIndex = 0;
	      
	      Enumeration enumTreeNode = mocHighlighted.children();
	      int flag =0;
	      while (flag == 0) {
	      	
	         DefaultMutableTreeNode moc2Add = (DefaultMutableTreeNode) enumTreeNode.nextElement();
	         if (moc2Add.toString().equals(mocType)) {
	            mocToAdd = addToVecTreeRelationship(moc2Add);
	            flag = 1;
	         }
	      }   
	      return mocToAdd;
	   }
	}
