/**
 * This dialog allows the user to Add Notification Info
 */

// JDK
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;

// AWT
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

// Swing
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JComboBox;
import javax.swing.JButton;
import javax.swing.BoxLayout;
import javax.swing.Box;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class AddNotificationDialog extends JDialog implements Observer, ActionListener {

    private JTextField txtIndex;
    private JTextField txtStatus;
    private JTextField txtFeature;
    private JTextField txtReference;
    private JTextField txtNotificationName;
    private JTextField txtComments;
    private JTextField txtRestrictions;
    private JTextField txtAdditionalObj;
    private JTextField txtPrivateObj;
    private JTextField txtQual;
    private JTextArea textComments;

    private JPanel pMultipleValue;
    private JPanel p6;

    private JList lstValue;
    private JScrollPane lstValueScrollPane;
    private JButton btnAdd;
    private JButton btnClose;

    private Vector vListModel;
    private DIMMOC pn;
    private MOCNode mocNode;
    private Object attrSelected;
    
    private ICSModel icsModel;

     /**
     * Constructor
     * @param frame A frame
     */
    public AddNotificationDialog(JFrame frame, Object selection, MOCNode selectedMoc, ICSModel model) {
	super(frame, "Add a Notification", true);
	
	attrSelected = selection;
	setICSModel(model);
	
	BoxLayout layout = new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS);
	getContentPane().setLayout(layout);
	
	JPanel p0 = new JPanel();
	p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));
	JLabel lblIndex = new JLabel("Index: ");
	p0.add(lblIndex);
	txtIndex = new JTextField();
	txtIndex.setEditable(false);
	txtIndex.setBackground(Color.WHITE);
	p0.add(txtIndex);
	p0.add(Box.createRigidArea(new Dimension(100, 0)));
	
	JPanel p1 = new JPanel();
	p1.setLayout(new BoxLayout(p1, BoxLayout.LINE_AXIS));
	JLabel lblNotificationName = new JLabel("Notification Name: ");
	p1.add(lblNotificationName);
	txtNotificationName = new JTextField();
	txtNotificationName.setEditable(true);
	txtNotificationName.setBackground(Color.WHITE);
	p1.add(txtNotificationName);
	p1.add(Box.createRigidArea(new Dimension(100, 0)));	

	JPanel p2 = new JPanel();
	p2.setLayout(new BoxLayout(p2, BoxLayout.LINE_AXIS));
	JLabel lblReference = new JLabel("Reference: ");
	p2.add(lblReference);
	txtReference = new JTextField();
	txtReference.setEditable(false);
	txtReference.setBackground(Color.WHITE);
	p2.add(txtReference);
	p2.add(Box.createRigidArea(new Dimension(100, 0)));
	
	JPanel p22 = new JPanel();
	p22.setLayout(new BoxLayout(p22, BoxLayout.LINE_AXIS));
	JLabel lblQual = new JLabel("Qualifier: ");
	p22.add(lblQual);
	txtQual = new JTextField();
	txtQual.setEditable(false);
	txtQual.setBackground(Color.WHITE);
	p22.add(txtQual);
	p22.add(Box.createRigidArea(new Dimension(100, 0)));
	
	JPanel p3 = new JPanel();
	p3.setLayout(new BoxLayout(p3, BoxLayout.LINE_AXIS));
	JLabel lblStatus = new JLabel("Status: ");
	//p3.add(Box.createRigidArea(new Dimension(100, 0)));
	p3.add(lblStatus);
	txtStatus = new JTextField();
	txtStatus.setEditable(true);
	txtStatus.setBackground(Color.WHITE);
	p3.add(txtStatus);
	p3.add(Box.createRigidArea(new Dimension(100, 0)));

	JPanel p6 = new JPanel();
	p6.setLayout(new BoxLayout(p6, BoxLayout.LINE_AXIS));
	JLabel lblRestrictions = new JLabel("Restrictions: ");
	p6.add(lblRestrictions);
	txtRestrictions = new JTextField();
	txtRestrictions.setEditable(true);
	txtRestrictions.setBackground(Color.WHITE);
	p6.add(txtRestrictions);
	p6.add(Box.createRigidArea(new Dimension(100, 0)));
	
	getContentPane().add(p0);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p1);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p2);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p22);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p3);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p6);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));

	pMultipleValue = new JPanel();
	pMultipleValue.setLayout(new BoxLayout(pMultipleValue, BoxLayout.LINE_AXIS));

	JPanel p10 = new JPanel();
	p10.setLayout(new BoxLayout(p10, BoxLayout.PAGE_AXIS));
	lstValue = new JList();
	lstValueScrollPane = new JScrollPane(lstValue);
	p10.add(lstValueScrollPane);
	p10.add(Box.createRigidArea(new Dimension(0, 5)));

	JPanel p8 = new JPanel();
	p8.setLayout(new BoxLayout(p8, BoxLayout.LINE_AXIS));
	btnAdd = new JButton("Add");
	btnAdd.addActionListener(this);
	btnAdd.setBackground(new Color(204, 204, 255));
	p8.add(btnAdd);
	p8.add(Box.createRigidArea(new Dimension(0, 5)));
	
	btnClose = new JButton("Close");
	btnClose.addActionListener((ActionListener) this);
	btnClose.setBackground(new Color(204, 204, 255));
	p8.add(btnClose);

	pMultipleValue.add(Box.createRigidArea(new Dimension(100, 0)));
	pMultipleValue.add(Box.createRigidArea(new Dimension(10, 0)));
	pMultipleValue.add(p8);
	pMultipleValue.add(Box.createRigidArea(new Dimension(100, 0)));
	getContentPane().add(pMultipleValue);
	init();
	
	if(icsModel != null ) {
           int index = icsModel.getVMoc().indexOf(selectedMoc);
	   mocNode = (MOCNode)icsModel.getVMoc().get(index);
			
	   Vector vNotification = mocNode.getNotification();
	   for (int ac = 0; ac < vNotification.size(); ac++) {
	   NotificationNode notificationNode = (NotificationNode)vNotification.get(ac);
    	   if (notificationNode.getNotificationName().equals(selection.toString())){
    	      txtReference.setText(notificationNode.getNotificationReference());
    	      txtIndex.setText(notificationNode.getNotificationId());
    	      txtNotificationName.setText(notificationNode.getNotificationName());
    	      txtQual.setText(notificationNode.getNotificationQual());
    	      txtStatus.setText(notificationNode.getNotificationStatus());
    	      txtRestrictions.setText(notificationNode.getNotificationRestrictions());    					
           }
        }    	         
     }
  }

    /**
     * Set the model
     * @param model The model
     */
    public void setICSModel(ICSModel model) {
	icsModel = model;
    }
    /**
     * Handles a click event
     * @param evt The event
     */
    public void actionPerformed(ActionEvent evt) {
	if(evt.getSource() == btnAdd) {
	   String error = "";
	   String index = txtIndex.getText();
	   String qual = txtQual.getText();
	   String status = txtStatus.getText();
	   String restrictions = txtRestrictions.getText();	    
	   Vector vNotification = mocNode.getNotification();
		
	   for (int ac = 0; ac < vNotification.size(); ac++) {
	      NotificationNode notificationNode = (NotificationNode)vNotification.get(ac);
	      if (notificationNode.getNotificationName().equals(attrSelected.toString())){
	         notificationNode.setNotificationStatus(txtStatus.getText());
		 notificationNode.setNotificationRestrictions(txtRestrictions.getText());
	      }
           }
	    
	   txtNotificationName.setText("");
	   txtIndex.setText("");
	   txtReference.setText("");
	   txtQual.setText("");
	   txtStatus.setText("");
	   txtRestrictions.setText("");
	    
	}
	else if(evt.getSource() == btnClose) {
           setVisible(false);
	}
    }
   
    public void update(Observable o, Object arg) {
    	if(o instanceof ICSModel) {
    	    if(arg instanceof MVCArg) {
    		if("node".equals(((MVCArg)arg).getName())) {
    			btnAdd.setEnabled(true);
    		    Object obj = ((MVCArg)arg).getOValue();
    		    if(obj instanceof DIMMOC) {
    			pn = (DIMMOC)obj;
    		    }
    		}
    	    }
    	}
    }
    /**
     * Handles a list click event
     * @param evt The event
     */

    private void init() {
    	btnAdd.setEnabled(true);
    	vListModel = new Vector();
    }

}
