/**
 * AddMOCDialog - Add Managed Object Class
 */

// JDK
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

// AWT
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

// Swing
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JComboBox;
import javax.swing.JButton;
import javax.swing.BoxLayout;
import javax.swing.Box;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

public class AddMOCDialog extends JDialog implements ActionListener {

    private JComboBox cbPosition;
    private JComboBox cbSegment;

    private JButton btnAdd;
    private JButton btnClose;

    private ICSModel icsModel;
    private boolean fhs = false, fts = false;

    private DefaultMutableTreeNode currentNode;
    Vector vMocSelectedChildren = new Vector();

    /**
     * Constructor
     * @param frame A frame
     */
    public AddMOCDialog(JFrame frame) {
	super(frame, "Add a moc", true);

	BoxLayout layout = new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS);
	getContentPane().setLayout(layout);
       
	JPanel p0 = new JPanel();
	p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));
	
	JLabel lbl1 = new JLabel("Choose MOC to add ");
	p0.add(lbl1);
	
	
	JLabel lbl2 = new JLabel(" to highlighted MOC: ");
	p0.add(lbl2);

	cbSegment = new JComboBox();
	p0.add(cbSegment);
	
	JPanel p1 = new JPanel();
	p1.setLayout(new BoxLayout(p1, BoxLayout.LINE_AXIS));
	btnAdd = new JButton("Add");
	btnAdd.addActionListener(this);
        btnAdd.setBackground(new Color(204, 204, 255));
	p1.add(btnAdd);
	p1.add(Box.createRigidArea(new Dimension(5, 0)));
	btnClose = new JButton("Close");
	btnClose.addActionListener(this);
	btnClose.setBackground(new Color(204, 204, 255));
	p1.add(btnClose);

	JPanel p2 = new JPanel();
	p2.setLayout(new BoxLayout(p2, BoxLayout.PAGE_AXIS));
	p2.add(p0);
	p2.add(Box.createRigidArea(new Dimension(0, 10)));
	p2.add(p1);
	p2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
	getContentPane().add(p2);

	init(null);
    }

    /**
     * Handles a click event
     * @param evt The event
     */
    public void actionPerformed(ActionEvent evt) {
	if(evt.getSource() == btnAdd) {
	   icsModel.addMOC((String)cbSegment.getSelectedItem(),currentNode);	
	   setVisible(false);   
	}
	else if(evt.getSource() == btnClose) {
	   setVisible(false);
	}
    }

    /**
     * Set the model
     * @param model The model
     */
    public void setICSModel(ICSModel model) {
	icsModel = model;
    }

    /**
     * Init the panel
     * @param The selected node
     */
    public void init(DefaultMutableTreeNode node) {
	cbSegment.setEnabled(true);
	cbSegment.removeAllItems();
	String noMoc = "No children";
	if(icsModel != null && node != null) {
	    currentNode = node;	
	    Enumeration childrenMocSelected = currentNode.children();

	    while (childrenMocSelected.hasMoreElements()){
               
	    	String child = childrenMocSelected.nextElement().toString();
	    	if (!(node.toString().equals("Simple_MDS")) || !(child.indexOf("VMD") != -1)) {
                      vMocSelectedChildren.add(child);
                }
	    }
	    if (vMocSelectedChildren.size() == 0){
	    	vMocSelectedChildren.add(noMoc);
	    }
	    
	    ComboBoxModel model = new DefaultComboBoxModel(vMocSelectedChildren); 
		cbSegment.setModel(model);
        }
    }
}
