import java.util.Vector;

public class MOCNode extends DIMMOC {

   public Vector vAttribute;
   private Vector vBehaviour;
   private Vector vNotification;

   public MOCNode() {
      vAttribute = new Vector();
      vBehaviour = new Vector();
      vNotification = new Vector();
   }
  
   public MOCNode(MOCNode mn) {
      this();
      object_name   = mn.getObjectName();
      object_id     = mn.getObjectId();
      moc_ref     = mn.getReference();
      status = mn.getStatus();
      attribute_name = mn.getAttributeName();
      attribute_id   = mn.getAttributeId();
      attr_ref     = mn.getAttributeReference();
      attr_qual    = mn.getAttributeQual();
      attr_status    = mn.getAttributeStatus();
      attr_access    = mn.getAttributeAccess();
      attr_value_range = mn.getAttributeValueRange();
      attr_restrictions = mn.getAttributeRestrictions();
      attr_application_guidance = mn.getAttributeApplicationGuidance();
      attr_comment = mn.getAttributeComment();
   }

   public String toString() {
      return object_name;
   }

   public Vector getAttribute() {
      return vAttribute;
   }

   public Vector getBehaviour() {
      return vBehaviour;
   }

   public Vector getNotification() {
      return vNotification;
   }

   public void addAttribute(AttributeNode attribute) {
      if (attribute != null) {
         vAttribute.add(attribute);
      }
   }

   public void addBehaviour(BehaviourNode behaviour) {
      if (behaviour != null) {
         vBehaviour.add(behaviour);
      }
   }

   public void addNotification(NotificationNode notification) {
      if (notification != null) {
         vNotification.add(notification);
      }
   }

}
