#!/bin/sh

# The purpose of this script is to check the compliance
# of an installation of NFIQ from NFIS2 CD-ROM with the
# original NFIQ developed, tested, and published by NIST.

# This script takes the path to local nfiq and runs it
# for 1145 fingerprint images in NFIQ_compliance_testset
# directory. It will generate the file my_nfiq_numbers.txt 
# which has the format "id_fingerPosition_instance.an2 nfiq" 
# and then compares this file with compliance_testset_nfiq.txt
# which is the "groundtruth" nfiq numbers of the set images
# in the compliance_testset directory. 
#

# Elham Tabassi
# NIST December 2005

# If not one and only one command line argument ...
if [ $# -ne 1 ] ; then
   # ERROR
   echo Usage\: `basename $0` \<NFIQ_PATH\>
   exit 1
fi

# Set store first argument
nfiqPath=$1

echo NFIQ COMPLIANCE TEST STARTS NOW

# run nfiq for fingerprint images in compliance test set
# and store them in my_nfiq_numbers.txt
rm -f my_nfiq_numbers.txt

cd ./NFIQ_compliance_testset
for image in `ls *.an2`
do
   # run NFIQ for each image
   echo $image" "`$nfiqPath $image | awk '{print $3}'` >> ../my_nfiq_numbers.txt 
done
cd ..

# compare nfiq numbers with what NIST has provided
# ignore changes in amount of white space.
# report only if the files differ, not the details of the differences
diff --ignore-space-change -q -s my_nfiq_numbers.txt compliance_testset_nfiq.txt

# Compute and print the confusion matrix for my_nfiq_numbers.txt 
# and compliance_testset_nfiq.txt
rm -f mk_confusion_matrix.o
gcc mk_confusion_matrix.c -o mk_confusion_matrix 
./mk_confusion_matrix compliance_testset_nfiq.txt my_nfiq_numbers.txt

echo ""
echo NFIQ COMPLIANCE TEST OF \($nfiqPath\) COMPLETED
