/************************************************************************

      FILE:     MK_CONFUSION_MATRIX.C

      AUTHORS:  Craig Watson
                cwatson@nist.gov
      DATE:     01/30/2004
       
      MODIFIED By Elham Tabassi
      DATE:       12/03/2005

*************************************************************************/

#include <stdio.h>

void procargs(int, char **, char **, char **);
int delete_comments_wsq(unsigned char **, int *, unsigned char *, int);

/******************/
/*Start of Program*/
/******************/

main(int argc, char *argv[])
{
   char *file1, *file2;
   FILE *infp;
   int len1, len2;
   int mxq1, mxq2;
   int i, j, tot, *rtot, *ctot, **q12, q1[20000], q2[20000];
   char name[100];
   float perq;

   procargs(argc, argv, &file1, &file2);
   mxq1 = 0;
   mxq2 = 0;

   if((infp = fopen(file1, "rb")) == NULL) {
      fprintf(stderr, "ERROR: main : fopen : %s\n", file1);
      exit(-2);
   }
   len1 = 0;
   while(fscanf(infp, "%s %d", name, &(q1[len1])) != EOF) {
      if(q1[len1] > mxq1)
         mxq1 = q1[len1];
      len1++;
   }

   fclose(infp);

   if((infp = fopen(file2, "rb")) == NULL) {
      fprintf(stderr, "ERROR: main : fopen : %s\n", file2);
      exit(-3);
   }
   len2 = 0;
   while(fscanf(infp, "%s %d", name, &(q2[len2])) != EOF) {
      if(q2[len2] > mxq2)
         mxq2 = q2[len2];
      len2++;
   }

   fclose(infp);

   if(len1 != len2) {
      fprintf(stderr, "ERROR! length of my_nfiq_numders.txt (%d) !=  length of compliannce_testset_nfiq.txt (%d)\n", len1, len2);
      exit(-4);
   }

   mxq1++;
   mxq2++;
   rtot = (int *)malloc(sizeof(int) * mxq1);
   ctot = (int *)malloc(sizeof(int) * mxq2);
   q12 = (int **)malloc(sizeof(int *) * mxq1);

   printf("\n Confusion Matrix for my_nfiq_numbers.txt and compliance_testset_nfiq.txt\n");
   printf("number of samples = %d\n", len1);
   //printf("mxq = %d and %d\n", mxq1-1, mxq2-1);
   printf("row = %s\n", file1);
   printf("col = %s\n", file2);
   for(i = 0; i < mxq1; i++) {
      q12[i] = (int *)malloc(sizeof(int) * mxq2);
      rtot[i] = 0;
      for(j = 0; j < mxq2; j++) {
         ctot[j] = 0;
         q12[i][j] = 0;
      }
   }

   for(i = 0; i < len1; i++) {
         rtot[q1[i]]++;
         ctot[q2[i]]++;
         q12[q1[i]][q2[i]]++;
   }


   printf("         ");
   for(i = 1; i < mxq2; i++)
      printf("%5d ", i);
   printf("  Total\n");
   printf("      --");
   for(i = 1; i < mxq2; i++)
      printf("------");
   printf("--------\n");

   for(i = 1; i < mxq1; i++) {
      printf("%6d| ", i);
      for(j = 1; j < mxq2; j++)
         printf("%6d", q12[i][j]);
      printf("%8d\n", rtot[i]);
   }
   printf("      --");
   for(i = 1; i < mxq2; i++)
      printf("------");
   printf("--------\n");
   printf(" Total| ");
   for(j = 1; j < mxq2; j++)
      printf("%6d", ctot[j]);
   printf("%8d\n", len1);

   printf("\n");


   free(rtot);
   for(i = 0; i < mxq1; i++)
      free(q12[i]);
   free(q12);
   exit(0);
}

/*****************************************************************/
void procargs(int argc, char *argv[], char **file1, char **file2)
{
   if(argc != 3){
      fprintf(stderr, "Usage: %s <quality1><quality2> ", argv[0]);
      exit(-1);
   }
   *file1 = argv[1];
   *file2 = argv[2];

   return;
}
