	PROGRAM CALCOMP
C
C	 THIS IS A REVISION OF VERSION 1 OF A FUNDAMENTAL PARAMETER
C	COMPUTER PROGRAM FOR CORRECTION OF INTERELEMENT EFFECTS FOR
C	QUANTITATIVE X-RAY SPACTROMETRY. THE ORIGINAL PROGRAM WAS
C	WRITTEN BY R.M.ROUSSEAU OF THE GEOLOGICAL SURVEY OF CANADA
C	(GSC) AND CONTAINS THE PROGRAMS ALPHA AND CARECAL WHICH WERE
C	EXTENSIVELY MODIFIED AT NBS. THE NBSGSC PROGRAM CONTAINS THE
C	COMPREHENSIVE LACHANCE ALGORITHM(COLA) FOR CORRECTION OF INTER-
C	ELEMENT EFFECTS.
C	 CALCO IS A REVISION OF ALPHA FOR CALCULATING THEORETICAL ALPHA
C	COEFFICIENTS, AND CALCOMP IS A REVISION OF CARECAL FOR CALCULA-
C	TING CONCENTRATIONS IN ANALYTE SPECIMENS.
C
C	STRUCTURE OF CALCOMP :
C	  MAIN PROGRAM-----CALCOMP
C	  SUBROUTINE-------DATAIN,CALRI,GETERR,SVLSF2,SLE
C	                 *
C	AUTHORS: G.Y. TAO  AND P.A. PELLA          DATE: 07-SEP-1984
C	  CENTER FOR ANALYTICAL CHEMISTRY, NATIONAL BUREAU OF STANDARDS
C	  GAITHERSBURG MD 20899 U.S.A.
C	         AND R.M.ROUSSEAU
C	  GEOLOGICAL SURVEY OF CANADA, OTTAWA, CANADA  K1A-0E8
C	
C	* GUEST RESEARCHER FROM SHANGHAI INSTITUTE OF CERAMICS, 
C	  ACADEMIA SINICA, THE PEOPLE'S REPUBLIC OF CHINA
C
	REAL IP(13),IX(20,13),IS(20,13)
	DIMENSION IDATE(5),ITIME(4),A1(13,13),A2(12,12),A3(12,12),
     +          AIJK(12,12,12),CS(20,13),CIM(13),SCI(13),CX(20,13),
     +          TOT(20),CX1(20,13),RX(20,13),RX1(20,12)
	DOUBLE PRECISION NOA(13),NOA1(13),NS(20),NX(20)
	COMMON K1,N6,N,M,M1,K2,KK1,KK6
	COMMON /DATSUB/CS,IS,IX,NS,IP
	COMMON /COESUB/A1,A2,A3,AIJK
	COMMON /CALSUB/RX,RX1
	COMMON /GETSUB/NOA,NOA1,NX,CX,TOT
	DATA KK6/'N '/
	CALL DATE(IDATE)
	CALL TIME(ITIME)
	WRITE(6,500)IDATE,ITIME
	WRITE(6,510)
	READ(5,*)K1
	CALL DATAIN
	N2=N6-1
	WRITE(6,520)
	READ(5,530)KK7
	IF(KK7.EQ.'Y ')WRITE(6,540)
	IF(KK7.EQ.'Y ')READ(5,*)D
	D=D*1.0E-6
	IF(K2.EQ.2)GOTO 45
	DO 40 I=1,M
	IF(KK1.EQ.'Y ')J7=0
	DO 40 J=1,N6
	DO 10 I8=1,N
	IF(NOA(J).EQ.NOA1(I8))GOTO 20
10	CONTINUE
	GOTO 30
20	IF(KK1.EQ.'Y ')J7=J7+1
	IF(KK7.EQ.'Y ')IP(J)=IP(J)/(1.0-D*IP(J))
	IF(KK7.EQ.'Y ')IX(I,J)=IX(I,J)/(1.0-D*IX(I,J))
	RX(I,J)=IX(I,J)/IP(J)
	IF(KK1.EQ.'Y ')RX1(I,J7)=RX(I,J)
	GOTO 40
30	RX(I,J)=IX(I,J)
40	CONTINUE
	GOTO 55
45	IF(KK7.EQ.'N ')GOTO 50
	DO 46 I=1,M1
	DO 46 J=1,N6
	DO 46 I8=1,N
	IF(NOA(J).EQ.NOA1(I8))IS(I,J)=IS(I,J)/(1.0-D*IS(I,J))
46	CONTINUE
	DO 48 I=1,M
	DO 48 J=1,N6
	DO 48 I8=1,N
	IF(NOA(J).EQ.NOA1(I8))IX(I,J)=IX(I,J)/(1.0-D*IX(I,J))
48	CONTINUE
50	CALL CALRI
55	WRITE(6,545)
  	DO 200 L=1,M
	IF(KK1.EQ.'Y ')WRITE(6,550)NX(L),(NOA1(I),RX1(L,I),I=1,N)
	IF(KK1.EQ.'N ')WRITE(6,550)NX(L),(NOA(I),RX(L,I),I=1,N)
	DO 60 I=1,N6
	CIM(I)=0.0
	IF(RX(L,I).LT.0.0)RX(L,I)=0.0
	CX(L,I)=RX(L,I)
60	CONTINUE
	L1=1
65	DO 130 I=1,N6
	IF(KK1.EQ.'N ')GOTO 90
	DO 70 I8=1,N
	IF(NOA(I).EQ.NOA1(I8))GOTO 90
70	CONTINUE
	GOTO 130
90	SCI(I)=0.0
	IF(ABS(CX(L,I)-CIM(I)).LE.0.0001)GOTO 130
	CM=0.0
	DO 100 I9=1,N6
	CM=CM+CX(L,I9)
100	CONTINUE
	CM=CM-CX(L,I)
	DO 110 J=1,N6
	IF(K1.EQ.3)SCI(I)=SCI(I)+CX(L,J)*A1(I,J)
	IF(K1.EQ.2)SCI(I)=SCI(I)+CX(L,J)*(A1(I,J)+A2(I,J)*CM)
	IF(K1.EQ.1)SCI(I)=SCI(I)+CX(L,J)*(A1(I,J)+A2(I,J)*CM/
     +  (1.0+A3(I,J)*(1.0-CM)))
110	CONTINUE
	IF(K1.EQ.3)GOTO 125
	DO 120 J=1,N2
	KK=J+1
	DO 120 K=KK,N6
	SCI(I)=SCI(I)+AIJK(I,K,J)*CX(L,J)*CX(L,K)
120	CONTINUE
125	CIM(I)=CX(L,I)
	CX(L,I)=RX(L,I)*(1.0+SCI(I))
130	CONTINUE
	DO 160 I=1,N6
	IF(KK1.EQ.'N ')GOTO 150
	DO 140 I8=1,N
	IF(NOA(I).EQ.NOA1(I8))GOTO 150
140	CONTINUE
	GOTO 160
150	IF(ABS(CX(L,I)-CIM(I)).LE.0.0001)GOTO 160
	GOTO 170
160	CONTINUE
	GOTO 180
170	IF(L1.LE.10)L1=L1+1
	IF(L1.LE.10)GOTO 65
	IF(L1.GT.10)PAUSE'NO. OF ITERATION > 10'
180	TOT(L)=0.0
	DO 190 I9=1,N6
	CX1(L,I9)=CX(L,I9)*100.0
	CX(L,I9)=AINT(1.0E4*CX(L,I9)+.5)/100.0
	TOT(L)=TOT(L)+CX(L,I9)
190	CONTINUE
	WRITE(6,560)L1,(NOA(I),CX1(L,I),I=1,N6)
	WRITE(6,570)TOT(L)
200	CONTINUE
	WRITE(6,572)(NOA(I),I=1,N6)
	DO 210 L=1,M
	WRITE(6,574)NX(L),TOT(L),(CX1(L,I),I=1,N6)
210	CONTINUE
	WRITE(6,580)
	READ(5,530)KK5
	IF(KK5.EQ.'Y ')CALL GETERR
	IF(M1.EQ.1.OR.K2.EQ.1)GOTO 220
	WRITE(6,590)
	READ(5,530)KK6
	IF(KK6.EQ.'Y ')GOTO 50
220	WRITE(6,600)
	STOP
500	FORMAT(///1X,'DATE:  ',5A2,6X,'TIME:  ',4A2/)
510	FORMAT(1X,'WHAT TYPE OF UNKNOWNS DO YOU WISH TO ANALYZE :'/
     +  3X,'1-ELEMENT SYSTEM    2-OXIDE SYSTEM    3-FUSED DISK SYSTEM  ?
     +  ',$)
520	FORMAT(1X,'DO YOU WANT TO CORRECT INTENSITIES FOR DEAD TIME (Y/N
     +  ) ?  ',$)
530	FORMAT(A1)
540	FORMAT(1X,'INPUT THE DEAD TIME IN MICROSECONDS :  ',$)
545	FORMAT(/' -----RESULTS OF LAST ITERATION-----'/)
550	FORMAT(/1X,'SMP.NO.=',A8,2X,'R=',6(A8,F8.5,1X)/21X,6(A8,F8.5,
     +  1X))
560	FORMAT(13X,'L=',I2,2X,'C=',6(A8,F7.3,1H%,1X)/21X,6(A8,F7.3,
     +  1H%,1X)/21X,A8,F7.3,1H%)
570	FORMAT(19X,'TOTAL=',F7.2,1H%/)
572	FORMAT(//45X,'TABULATION OF RESULTS (%)'//
     +  1X,'SMP.NO.   TOTAL   ',13A8)
574	FORMAT(/1X,A8,1X,F7.2,13(F7.3,1X))
580	FORMAT(///1X,'DO YOU WISH TO COMPARE THESE RESULTS WITH OTHER P
     +REVIOUSLY KNOWN VALUES FOR THESE SPECIMENS (Y/N) ?  ',$)
590	FORMAT(//1X,'DO YOU WANT TO TRY ANOTHER TYPE OF CALIBRATION CURV
     +E (Y/N) ?  ',$)
600	FORMAT(///)
	END
	SUBROUTINE DATAIN
C
C	MOST OF THE INPUT DATA REQUIRED FOR CALCULATING CONCENTRATIONS
C	IS HANDLED BY THIS SUBROUTINE.
C
C	NBS        05-SEP-1984
C
	REAL IP(13),IX(20,13),IS(20,13)
	DIMENSION A1(13,13),A2(12,12),A3(12,12),AIJK(12,12,12),
     +          NAMFIL(5),CS(20,13)
	DOUBLE PRECISION NOA(13),NOA1(13),NS(20),NX(20)
	COMMON K1,N6,N,M,M1,K2,KK1
	COMMON /DATSUB/CS,IS,IX,NS,IP
	COMMON /COESUB/A1,A2,A3,AIJK
	COMMON /GETSUB/NOA,NOA1,NX
	WRITE(6,500)
	READ(5,510)KK1
	IF(KK1.EQ.'Y ')WRITE(6,520)
	IF(KK1.EQ.'Y ')READ(5,*)N6,N,M
	IF(KK1.EQ.'N ')WRITE(6,530)
	IF(KK1.EQ.'N ')READ(5,*)N,M
	IF(KK1.EQ.'N ')N6=N
	IF(KK1.EQ.'Y ')WRITE(6,540)
	IF(KK1.EQ.'Y ')READ(5,550)(NOA(I),I=1,N6)
	WRITE(6,560)
	READ(5,550)(NOA1(I),I=1,N)
	IF(KK1.EQ.'Y ')GOTO 20
	DO 10 I=1,N6
	NOA(I)=NOA1(I)
10	CONTINUE
20	WRITE(6,570)
	READ(5,*)K4
	IF(K4.EQ.1)GOTO 30
	WRITE(6,580)
	IF(K1.EQ.1)READ(5,*)((A1(I,J),J=1,N6),(A2(I,J),J=1,N6),
     +  (A3(I,J),J=1,N6),((AIJK(I,J,K),K=1,N6),J=1,N6),I=1,N6)
	IF(K1.EQ.2)READ(5,*)((A1(I,J),J=1,N6),(A2(I,J),J=1,N6),
     +  ((AIJK(I,J,K),K=1,N6),J=1,N6),I=1,N6)
	IF(K1.EQ.3)READ(5,*)((A1(I,J),J=1,N6),I=1,N6)
	GOTO 50
30	WRITE(6,590)
	READ(5,600)NAMFIL
	CALL ASSIGN(3,NAMFIL,10)
	IF(K1.EQ.1)READ(3,*,ERR=40)((A1(I,J),J=1,N6),(A2(I,J),J=1,N6),
     +  (A3(I,J),J=1,N6),((AIJK(I,J,K),K=1,N6),J=1,N6),I=1,N6)
	IF(K1.EQ.2)READ(3,*,ERR=40)((A1(I,J),J=1,N6),(A2(I,J),J=1,N6),
     +  ((AIJK(I,J,K),K=1,N6),J=1,N6),I=1,N6)
	IF(K1.EQ.3)READ(3,*,ERR=40)((A1(I,J),J=1,N6),I=1,N6)
40	CALL CLOSE(3)
50	WRITE(6,610)
	READ(5,*)K2
	IF(K2.EQ.2)WRITE(6,620)
	IF(K2.EQ.2)READ(5,*)M1
	IF(K2.EQ.2)GOTO 70
	IF(KK1.EQ.'Y ')WRITE(6,630)
	IF(KK1.EQ.'N ')WRITE(6,635)
	DO 60 I=1,N6
	DO 55 I8=1,N
	IF(NOA(I).EQ.NOA1(I8))GOTO 57
55	CONTINUE
	GOTO 60
57	WRITE(6,640)NOA(I)
	READ(5,*)IP(I)
60	CONTINUE
	GOTO 100
70	WRITE(6,650)
	DO 80 I=1,M1
	WRITE(6,660)I
	READ(5,670)NS(I)
80	CONTINUE
	WRITE(6,680)
	DO 90 I=1,M1
	WRITE(6,690)I,NS(I)
	READ(5,*)(CS(I,J),J=1,N6)
90	CONTINUE
	IF(KK1.EQ.'Y ')WRITE(6,695)
	IF(KK1.EQ.'N ')WRITE(6,697)
	DO 96 I=1,M1
  	WRITE(6,690)I,NS(I)
	READ(5,*)(IS(I,J),J=1,N6)
96	CONTINUE
100	WRITE(6,700)
	DO 110 I=1,M
	WRITE(6,660)I
	READ(5,670)NX(I)
110	CONTINUE
	IF(KK1.EQ.'Y ')WRITE(6,710)
	IF(KK1.EQ.'N ')WRITE(6,720)
	DO 120 I=1,M
	WRITE(6,690)I,NX(I)
	READ(5,*)(IX(I,J),J=1,N6)
120	CONTINUE
	RETURN
500	FORMAT(1X,'DO YOU WANT TO INPUT KNOWN CONCENTRATIONS OF UNANALYZ
     +ED ELEMENTS (Y/N)?  ',$)
510	FORMAT(A1)
520	FORMAT(1X,'INPUT N6(NUMBER OF ALL CONSTITUENTS), N(NUMBER OF ANA
     +LYTES) AND'/3X,'M(NUMBER OF SPECIMENS TO BE ANALYZED) :',10X,$)
530	FORMAT(1X,'INPUT N(NUMBER OF ANALYTES) & M(NUMBER OF SPECIMENS T
     +O BE ANALYZED) :  ',$)
540	FORMAT(' INPUT NAMES OF CONSTITUENTS(XXXXXXXX)(MAX.=8/LINE) :'/)
550	FORMAT(8A8)
560	FORMAT(1X,'INPUT NAMES OF ANALYTES(XXXXXXXX)(MAX.=8/LINE) :'/)
570	FORMAT(' DO YOU WANT TO INPUT ALPHA COEFFICIENTS BY: 1-DATAFILE
     +  2-KEYBOARD  ?  ',$)
580	FORMAT(1X,'TYPE IN THE ALPHA COEFFICIENTS :'/)
590	FORMAT(1X,'INPUT DATAFILE NAME OF ALPHA COEFFICIENTS(XXXXXX.XXX)
     + :  ',$)
600	FORMAT(5A2)
610	FORMAT(' WHAT TYPE OF STANDARDS ARE AVAILABLE: 1-PURE STANDARDS  
     +  2-MULTIELEMENT STANDARDS  ?  ',$)
620	FORMAT(1X,'INPUT M1(NUMBER OF STANDARDS) :  ',$)
630	FORMAT(1X,'INPUT NET PURE INTENSITIES FOR EACH ANALYTE FOLLOWED 
     +BY A PERIOD AND'/3X,'ENTER 0.0 FOR EACH UNANALYZED ELEMENT:'/)
635	FORMAT(1X,'INPUT NET PURE INTENSITIES FOR EACH ANALYTE FOLLOWED 
     +BY A PERIOD :'/)
640	FORMAT(2X,A2,4X,$)
650	FORMAT(1X,'INPUT I.D. OF STANDARDS (<=8 CHARACTERS) :'/)
660	FORMAT(2X,'I=',I2,4X,$)
670	FORMAT(A8)
680	FORMAT(' INPUT CONCENTRATIONS(WEIGHT FRACTION) OF STANDARDS :'/)
690	FORMAT(2X,'I=',I2,4X,A8,2X,$)
695	FORMAT(1X,'INPUT NET INTENSITIES FOLLOWED BY A PERIOD FOR THE AN
     +ALYTE ELEMENTS IN STANDARDS AND'/3X,'ENTER 0.0 FOR EACH UNANALYZED
     + ELEMENT:'/)
697	FORMAT(1X,'INPUT NET INTENSITIES FOLLOWED BY A PERIOD FOR THE AN
     +ALYTE ELEMENTS IN STANDARDS :')
700	FORMAT(1X,'INPUT I.D. OF SPECIMENS TO BE ANALYZED :'/)
710	FORMAT(1X,'INPUT NET INTENSITIES FOR ANALYTES IN SPECIMENS AND'/ 
     +3X,'ENTER CONCENTRATIONS(WEIGHT FRACTION) FOR UNANALYZED ELEMENTS:
     +'	/)
720	FORMAT(' INPUT NET INTENSITIES OF SPECIMENS TO BE ANALYZED :'/)
	END
	SUBROUTINE CALRI
C
C	THIS SUBROUTINE CALCULATES RELATIVE INTENSITIES OF ANALYTE
C	SPECIMENS USING MULTIELEMENT STANDARD(S) AND THE COLA
C	EQUATION.
C
C	NBS      05-SEP-1984
C
	REAL IP1(20,13),IS(20,13),IP11(20,13),IPP(12),IP(13),IX(20,13)
	DIMENSION SCI(13),CS(20,13),A1(13,13),A2(12,12),A3(12,12),
     +  AIJK(12,12,12),RS(20,13),RS1(20,12),RX(20,13),RX1(20,12)
	DOUBLE PRECISION NOA(13),NOA1(13),NS(20),
     +  X(20),Y(20),S(4),A(12,3),AA(11,3)
	COMMON K1,N6,N,M,M1,K2,KK1,KK6
	COMMON /DATSUB/CS,IS,IX,NS
	COMMON /COESUB/A1,A2,A3,AIJK
	COMMON /LSFSUB/X,Y
	COMMON /CALSUB/RX,RX1
	COMMON /GETSUB/NOA,NOA1
	EQUIVALENCE (X(1),IP11(1,1)),(Y(1),IP11(1,3)),(A(1,1),IP11(1,5))
     +  ,(AA(1,1),IP11(1,9)),(IP1,RX),(RS1,RX1)
	IF(KK6.EQ.'Y ')GOTO 210
	N2=N6-1
	DO 90 L=1,M1
	IF(KK1.EQ.'Y ')J7=0
	DO 90 I=1,N6
	IF(KK1.EQ.'N ')GOTO 30
	DO 10 I8=1,N
	IF(NOA(I).EQ.NOA1(I8))GOTO 20
10	CONTINUE
	GOTO 90
20	J7=J7+1
30	SCI(I)=0.0
	CM=0.0
	DO 40 I9=1,N6
	CM=CM+CS(L,I9)
40	CONTINUE
	CM=CM-CS(L,I)
	DO 50 J=1,N6
	IF(K1.EQ.3)SCI(I)=SCI(I)+CS(L,J)*A1(I,J)
	IF(K1.EQ.2)SCI(I)=SCI(I)+CS(L,J)*(A1(I,J)+A2(I,J)*CM)
	IF(K1.EQ.1)SCI(I)=SCI(I)+CS(L,J)*(A1(I,J)+A2(I,J)*CM/
     +  (1.0+A3(I,J)*(1.0-CM)))
50	CONTINUE
	IF(K1.EQ.3)GOTO 70
	DO 60 J=1,N2
	KK=J+1
	DO 60 K=KK,N6
	SCI(I)=SCI(I)+AIJK(I,K,J)*CS(L,J)*CS(L,K)
60	CONTINUE
70	RS(L,I)=CS(L,I)/(1.0+SCI(I))
	IF(RS(L,I).EQ.0.0)GOTO 80
	IP1(L,I)=IS(L,I)/RS(L,I)
80	IF(KK1.EQ.'Y ')RS1(L,J7)=RS(L,I)
	IF(KK1.EQ.'Y ')IP11(L,J7)=IP1(L,I)
90	CONTINUE
	IF(KK6.EQ.'Y ')GOTO 160
	WRITE(6,500)
	READ(5,510)KK3
	IF(KK3.EQ.'N ')GOTO 160
	IF(KK1.EQ.'Y ')WRITE(6,520)(NOA1(J),J=1,N)
	IF(KK1.EQ.'N ')WRITE(6,520)(NOA(J),J=1,N)
	DO 100 I=1,M1
	IF(KK1.EQ.'Y ')WRITE(6,530)NS(I),(RS1(I,J),J=1,N)
	IF(KK1.EQ.'N ')WRITE(6,530)NS(I),(RS(I,J),J=1,N)
100	CONTINUE
	IF(KK1.EQ.'Y ')J7=0
	DO 140 I=1,N6
	M11=M1
	DO 110 I8=1,N
	IF(NOA(I).EQ.NOA1(I8))GOTO 120
110	CONTINUE
	GOTO 140
120	IF(KK1.EQ.'Y ')J7=J7+1
	IP(I)=0.0
	DO 130 L=1,M1
	IF(CS(L,I).EQ.0.0)K11=1
	IF(CS(L,I).EQ.0.0)M11=M11-1
	IF(CS(L,I).EQ.0.0)GOTO 130
	IP(I)=IP(I)+IP1(L,I)
130	CONTINUE
	IF(K11.NE.1)IP(I)=IP(I)/FLOAT(M1)
	IF(K11.EQ.1)IP(I)=IP(I)/FLOAT(M11)
	IF(K11.EQ.1)K11=2
	IF(KK1.EQ.'Y ')IPP(J7)=IP(I)
140	CONTINUE
	IF(KK1.EQ.'Y ')WRITE(6,540)(NOA1(J),J=1,N)
	IF(KK1.EQ.'N ')WRITE(6,540)(NOA(J),J=1,N)
	DO 150 I=1,M1
	IF(KK1.EQ.'Y ')WRITE(6,550)NS(I),(IP11(I,J),J=1,N)
	IF(KK1.EQ.'N ')WRITE(6,550)NS(I),(IP1(I,J),J=1,N)
150	CONTINUE
	IF(KK1.EQ.'Y ')WRITE(6,555)(IPP(J),J=1,N)
	IF(KK1.EQ.'N ')WRITE(6,555)(IP(J),J=1,N)
160	IF(M1.NE.1)GOTO 210
	WRITE(6,557)
	K3=3
	GOTO 215
210	WRITE(6,560)
	READ(5,*)K3
215	IF(K3.EQ.1.OR.K3.EQ.3)N9=1
	IF(K3.EQ.2.OR.K3.EQ.4)N9=2
	WRITE(6,570)
	READ(5,510)KK4
	IF(KK1.EQ.'Y ')J7=0
	DO 270 L=1,N6
	IF(KK1.EQ.'N ')GOTO 240
	DO 220 I8=1,N
	IF(NOA(L).EQ.NOA1(I8))GOTO 230
220	CONTINUE
	GOTO 270
230	J7=J7+1
240	DO 250 I=1,M1
	X(I)=IS(I,L)
	Y(I)=RS(I,L)
250	CONTINUE
	CALL SVLSF2(S,K3,N9,M1)
	DO 260 I=1,3
	A(L,I)=S(I)
	IF(KK1.EQ.'Y ')AA(J7,I)=A(L,I)
260	CONTINUE
270	CONTINUE
	DO 320 L=1,M
	IF(KK1.EQ.'Y ')J7=0
	DO 320 I=1,N6
	IF(KK1.EQ.'N ')GOTO 300
	DO 280 I8=1,N
	IF(NOA(I).EQ.NOA1(I8))GOTO 290
280	CONTINUE
	GOTO 310
290	J7=J7+1
300	IF(IX(L,I).EQ.0.0)IX(L,I)=1.0E-20
	RX(L,I)=A(I,1)+A(I,2)*IX(L,I)+A(I,3)*IX(L,I)*IX(L,I)
	IF(KK1.EQ.'Y ')RX1(L,J7)=RX(L,I)
	GOTO 320
310	IF(KK1.EQ.'Y ')RX(L,I)=IX(L,I)
320	CONTINUE
	IF(KK4.EQ.'N ')RETURN
	WRITE(6,580)
	DO 330 I=1,N
	IF(KK1.EQ.'Y ')WRITE(6,590)NOA1(I),(AA(I,J),J=1,3)
	IF(KK1.EQ.'N ')WRITE(6,590)NOA(I),(A(I,J),J=1,3)
330	CONTINUE
	RETURN
500	FORMAT(1X,'DO YOU WANT TO PRINT OUT CALCULATED RELATIVE INTENSIT
     +IES OF STANDARDS &'/2X,' CALCULATED PURE INTENSITIES FROM STANDARD
     +S (Y/N) ?  ',$)
510	FORMAT(A1)
520	FORMAT(/1X,'CALCULATED RELATIVE INTENSITIES OF STANDARDS :',/
     +  19X,12(1X,A8))
530	FORMAT(1X,'STD.NO.=',A8,2X,12(F8.5,1X))
540	FORMAT(/1X,'CALCULATED PURE INTENSITIES FROM STANDARDS :',/
     +  19X,12(1X,A8))
550	FORMAT(1X,'STD.NO.=',A8,2X,12F9.0)
555	FORMAT(/1X,'AVERAGE VALUES',4X,12F9.0)
557	FORMAT(/1X,'BECAUSE ONLY ONE STANDARD IS AVAILABLE, THE ONLY CHO
     +ICE FOR LSF CALIBRATION CURVE IS:  Y=A1*X.')
560	FORMAT(/1X,'WHAT TYPE OF LSF CURVES DO YOU WANT TO USE FOR CALIB
     +RATION :' /3X,'(1) Y=A0+A1*X      (2) Y=A0+A1*X+A2*X*X'
     +  /3X,'(3) Y=A1*X         (4) Y=A1*X+A2*X*X       ?   ',$)
570	FORMAT(' DO YOU WANT TO PRINT OUT LSF COEFFICIENTS (Y/N) :  ',$)
580  	FORMAT(/15X,'TABULATION OF CALCULATED LSF COEFFICIENTS',/
     +  19X,'(X=MEAS.INT.  ;  Y=CALC.REL.INT.)',/)
590	FORMAT(1X,A8,2X,'A0=',E12.5,2X,'A1=',E12.5,2X,'A2=',E12.5)
	END
	SUBROUTINE GETERR
C
C	THIS SUBROUTINE COMPARES RESULTS FROM COLA WITH OTHER 
C	PREVIOUSLY KNOWN VALUES.
C
C	NBS      05-SEP-1984
C
	DIMENSION CXT(20,13),CX(20,13),TOTT(20),EA(13),ER(13),
     +  DIF(20,13),DIFR(20,13),TOT(20)
	DOUBLE PRECISION NX(20),NOA(13),NOA1(13)
	COMMON K1,N6,N,M,M1,K2,KK1,KK6
	COMMON /GETSUB/NOA,NOA1,NX,CX,TOT
	IF(KK6.EQ.'Y ')GOTO 45
	WRITE(6,500)
	DO 10 I=1,M
	WRITE(6,505)NX(I)
	READ(5,*)(CXT(I,J),J=1,N6)
10	CONTINUE
20	DO 40 L=1,M
	TOTT(L)=0.0
	DO 30 I=1,N6
	CXT(L,I)=AINT(1.0E4*CXT(L,I)+.5)/100.0
	TOTT(L)=TOTT(L)+CXT(L,I)
30 	CONTINUE
40	CONTINUE
45	DO 80 I=1,N6
	EA(I)=0.0
	ER(I)=0.0
	IF(KK1.EQ.'N ')GOTO 60
	DO 50 I8=1,N
	IF(NOA(I).EQ.NOA1(I8))GOTO 60
50	CONTINUE
	GOTO 80
60	DO 70 L=1,M
	DIF(L,I)=CX(L,I)-CXT(L,I)
	IF(CXT(L,I).EQ.0.0)DIFR(L,I)=0.0
	IF(CXT(L,I).EQ.0.0)GOTO 70
	DIFR(L,I)=100.0*DIF(L,I)/CXT(L,I)
	EA(I)=EA(I)+ABS(DIF(L,I))
	ER(I)=ER(I)+100.0*ABS(DIF(L,I))/CXT(L,I)
70	CONTINUE
	EA(I)=EA(I)/FLOAT(M)
	ER(I)=ER(I)/FLOAT(M)
80	CONTINUE
	WRITE(6,510)(NOA(I),I=1,N6)
	DO 90 L=1,M
	WRITE(6,520)NX(L),TOTT(L),(CXT(L,I),I=1,N6)
	WRITE(6,530)TOT(L),(CX(L,I),I=1,N6)
	WRITE(6,540)(DIF(L,I),I=1,N6)
	WRITE(6,550)(DIFR(L,I),I=1,N6)
90	CONTINUE
	WRITE(6,560)(EA(I),I=1,N6)
	WRITE(6,570)(ER(I),I=1,N6)
	RETURN
500	FORMAT(1X,'ENTER KNOWN CONCENTRATIONS OF SPECIMENS :'/)
505	FORMAT(1X,'SMP.NO.=',A8,2X,$)
510	FORMAT(//45X,'TABULATION OF RESULTS (%)'//
     +  1X,'SMP.NO.   TOTAL   ',13A8)
520	FORMAT(/1X,A8,1X,F7.2,13(F7.2,1X))
530	FORMAT(10X,F7.2,13(F7.2,1X))
540	FORMAT(9X,'ABS.ERR.',13(F7.2,1X))
550	FORMAT(9X,'REL.ERR.',13(F7.2,1X))
560	FORMAT(//5X,'AVG.ABS.ERR.',13(F7.2,1X))
570	FORMAT(5X,'AVG.REL.ERR.',13(F7.2,1X))
	END
	SUBROUTINE SVLSF2(S,K1,N9,N)
C
C	THE SUBROUTINE PERFORMS A LEAST-SQUARES FIT FOR
C	SINGLE VARIABLE.
C
C	NBS     24-MAY-1984
C
	DIMENSION S(4),X(20),Y(20),A(3,4),T(5)
	DOUBLE PRECISION S,A,X,Y,T1,T2,T,S1,S2,S3,V,U,P1
	COMMON /LSFSUB/X,Y
	N10=N9+1
	N11=N9+2
	N12=N9*2+1
	IF(K1.EQ.1.OR.K1.EQ.2)GOTO 15
	T1=0.0
	IF(K1.EQ.4)T2=0.0
	S1=0.0
	IF(K1.EQ.4)S2=0.0
	IF(K1.EQ.4)S3=0.0
	DO 10 I=1,N
	IF(X(I).EQ.0.0)X(I)=1.0E-20
	T1=T1+X(I)*Y(I)
	IF(K1.EQ.4)T2=T2+X(I)*X(I)*Y(I)
	S1=S1+X(I)*X(I)
	IF(K1.EQ.4)S2=S2+X(I)**3
	IF(K1.EQ.4)S3=S3+X(I)**4
10	CONTINUE
	IF(K1.EQ.3)S(1)=0.0
	IF(K1.EQ.3)S(2)=T1/S1
	IF(K1.EQ.3)S(3)=0.0
	IF(K1.EQ.3)GOTO 70
	N10=N10-1
	N11=N11-1
	A(1,1)=S1
	A(1,2)=S2
	A(1,3)=T1
	A(2,1)=S2
	A(2,2)=S3
	A(2,3)=T2
	GOTO 55
15	DO 30 I=1,N12
	V=0.0
	U=0.0
	DO 20 J=1,N
	IF(X(J).EQ.0.0)X(J)=1.0E-20
	P1=X(J)**(I-1)
	U=U+P1
	IF(I.GT.N10)GOTO 20
	V=V+Y(J)*P1
20	CONTINUE
	T(I)=U
	IF(I.GT.N10)GOTO 30
	A(I,N11)=V
30	CONTINUE
	LL=0
	DO 50 I=1,N10
	DO 40 J=1,N10
	A(I,J)=T(J+LL)
40	CONTINUE
	LL=LL+1
50	CONTINUE
55	CALL SLE(S,A,N10)
	IF(K1.EQ.1)S(3)=0.0
	IF(K1.EQ.4)GOTO 60
	GOTO 70
60	N10=N10+1
	N11=N11+1
	S(3)=S(2)
	S(2)=S(1)
	S(1)=0.0
70	RETURN
	END
	SUBROUTINE SLE(S,A,N)
C
C	THIS SUBROUTINE IS USED TO SOLVE
C	SIMULTANEOUS LINEAR EQUATIONS
C
C	NBS     22-MAY-1984
C
	INTEGER P,Q,O
	DIMENSION A(3,4),S(4),O(3)
	DOUBLE PRECISION A,E,S,R
	N1=N+1
	DO 220 I=1,N
	P=I
	Q=1
	E=A(I,1)
	DO 120 J=I,N
	DO 100 K=1,N
	IF(ABS(A(J,K)).LE.ABS(E))GOTO 100
	E=A(J,K)
	Q=K
	P=J
100	CONTINUE
120	CONTINUE
	IF(ABS(E).GT.1.0E-30)GOTO 140
C	THE LARGEST ELEMENT IS EQUAL TO ZERO
	WRITE(6,260)
	STOP
C	TO CHANGE P-TH ROW WITH I-TH ROW
140	DO 160 K=1,N1
	S(K)=A(I,K)
	A(I,K)=A(P,K)
	A(P,K)=S(K)
160	CONTINUE
C	TO ZERO OUT Q-TH COLUMN
	DO 200 J=1,N
	IF(J.EQ.I)GOTO 200
	IF(A(J,Q).EQ.0.0)GOTO 200
	R=A(J,Q)/A(I,Q)
	DO 180 K=1,N1
	A(J,K)=A(J,K)-A(I,K)*R
180	CONTINUE
200	CONTINUE
	O(I)=Q
220	CONTINUE
	DO 240 I=1,N
	Q=O(I)
	S(Q)=A(I,N1)/A(I,Q)
240	CONTINUE
	RETURN
260	FORMAT(/1X,'NO UNIQUE SOLUTION')
	END
