	PROGRAM CALCO
C
C	 THIS IS A REVISION OF VERSION 1 OF A FUNDAMENTAL PARAMETER
C	COMPUTER PROGRAM FOR CORRECTION OF INTERELEMENT EFFECTS FOR
C	QUANTITATIVE X-RAY SPECTROMETRY. THE ORIGINAL PROGRAM WAS
C	WRITTEN BY R.M.ROUSSEAU OF THE GEOLOGICAL SURVEY OF CANADA
C	(GSC) AND CONTAINS THE PROGRAMS ALPHA AND CARECAL WHICH WERE
C	EXTENSIVELY MODIFIED AT NBS. THE NBSGSC PROGRAM CONTAINS THE
C	COMPREHENSIVE LACHANCE ALGORITHM(COLA) FOR CORRECTION OF INTER-
C	ELEMENT EFFECTS.
C	 CALCO IS A REVISION OF ALPHA FOR CALCULATING THEORETICAL ALPHA
C	COEFFICIENTS, AND CALCOMP IS A REVISION OF CARECAL FOR CALCULA-
C	TING CONCENTRATIONS IN ANALYTE SPECIMENS.
C
C	OVERLAY STRUCTURE OF CALCO :
C	  MAIN PROGRAM-----CALCO
C	  SUBROUTINE-------ALPHA,APAFD,ATNUM,CHAWV,ABSEDG
C	                   JUMRAT,YIELD,AFIOX,BDCOEF,TUBDAT
C	                   CTNLIN,INFTGT,CHALIN,SBATWT
C	  REAL FUNCTION----MAC,MACFUN
C	  DATAFILE---------TGTWR.DAT,MACPRM.DAT
C	                 *
C	AUTHORS: G.Y. TAO  AND P.A. PELLA          DATE: 04-SEP-1984
C	  CENTER FOR ANALYTICAL CHEMISTRY, NATIONAL BUREAU OF STANDARDS
C	  GAITHERSBURG MD 20899 U.S.A.
C	         AND R.M.ROUSSEAU
C	  GEOLOGICAL SURVEY OF CANADA, OTTAWA, CANADA  KTA-0E8
C
C	* GUEST RESEARCHER FROM SHANGHAI INSTITUTE OF CERAMICS,
C	  ACADEMIA SINICA, THE PEOPLE'S REPUBLIC OF CHINA
C
	DIMENSION IELE(12),NE(12),NO(12),A1(12,12),A2(12,12),
     +  A3(12,12),AIJK(12,12,12),IDATE(5),ITIME(4),NAMFIL(5)
	COMMON K15,K1,N,IELE,NE,NO
	COMMON /COESUB/A1,A2,A3,AIJK
	CALL DATE(IDATE)
	CALL TIME(ITIME)
	WRITE(6,90)IDATE,ITIME
	WRITE(6,100)
	READ(5,*)K1
	WRITE(6,105)
	READ(5,*)N
	IF(K1.EQ.1)WRITE(6,110)
	IF(K1.EQ.1)READ(5,120)(IELE(I),I=1,N)
	IF(K1.NE.1)WRITE(6,130)
	IF(K1.NE.1)READ(5,140)(IELE(I),NE(I),NO(I),I=1,N)
	WRITE(6,145)
	READ(5,*)K15
	WRITE(6,150)
	READ(5,160)KK1
	IF(KK1.EQ.'N ')GOTO 10
	WRITE(6,170)
	READ(5,180)NAMFIL
10	CALL ALPHA
	IF(KK1.EQ.'N ')GOTO 20
	CALL ASSIGN(3,NAMFIL,10)
	IF(K1.EQ.3)A1(1,3)=0.0
	IF(K1.EQ.3)WRITE(3,*,ERR=15)A1(1,3),(A1(I,2),I=1,N),(A1(I,1),
     +  (A2(I,J),J=1,N),I=1,N)
	IF(K1.EQ.1)WRITE(3,*,ERR=15)((A1(I,J),J=1,N),(A2(I,J),J=1,N),
     +  (A3(I,J),J=1,N),((AIJK(I,J,K),K=1,N),J=1,N),I=1,N)
	IF(K1.EQ.2)WRITE(3,*,ERR=15)((A1(I,J),J=1,N),(A2(I,J),J=1,N),
     +  ((AIJK(I,J,K),K=1,N),J=1,N),I=1,N)
15	CALL CLOSE(3)
20	CALL DATE(IDATE)
	CALL TIME(ITIME)
	WRITE(6,95)IDATE,ITIME
	STOP
90	FORMAT(///1X,'DATE:  ',5A2,6X,'TIME:  ',4A2/)
95	FORMAT(1H1,//1X,'DATE:  ',5A2,6X,'TIME:  ',4A2/)
100	FORMAT(1X,'WHICH SYSTEM DO YOU WISH TO ANALYZE:'/3X,
     + '1-ELEMENT SYSTEM  2-OXIDE SYSTEM  3-FUSED DISK SYSTEM  ?  ',$)
105	FORMAT(1X,'INPUT NUMBER OF ANALYTES:  ',$)
110	FORMAT(1X,'INPUT NAMES OF ANALYTES (XXS):  ',$)
120	FORMAT(12(A2,1X))
130	FORMAT(1X,'INPUT NAMES OF ANALYTES (XXNONS):  '/)
140	FORMAT(12(A2,I1,1X,I1,1X))
145	FORMAT(1X,'WHAT MASS ABS. COEF. ALGORITHM DO YOU WANT 
     +TO USE :'/3X,'1-LEROUX ALGORITHM  2-HEINRICH ALGORITHM  ?  ',$)
150	FORMAT(1X,'DO YOU WANT TO CREATE A DATAFILE FOR SAVING CALCULATE
     +D ALPHA COEFFICIENTS (Y/N)?  ',$)
160	FORMAT(A1)
170	FORMAT(1X,'INPUT DATAFILE NAME OF ALPHA COEFFICIENTS(XXXXXX.XXX) 
     +:  ',$)
180	FORMAT(5A2)
	END
	SUBROUTINE ALPHA
C
C	 THIS SUBROUTINE CALCULATES ALPHA COEFFICIENTS FOR 
C	INTERELEMENT EFFECT CORRECTION USED IN COLA EQUATION
C	FOR ELEMENT, OXIDE, OR FUSED DISK SYSTEMS.
C
C	NBS     04-SEP-1984
C
	REAL MAC,MU
	DIMENSION XINT(2,300),XINT1(2,11),IELE(12),NE(12),NO(12),
     +CL(12,4),ISR(12),IZ(12),A1(12,12),
     +A2(12,12),A3(12,12),AIJK(12,12,12),UCO(12),UC(12,12),C(5,3),
     +IE(12),G(5),ALFA(12),CAM(12),SWDB(12),SWDB1(12)
	COMMON K15,K1,N,IELE,NE,NO,KK2,CAM,IZ,ITP,ITS
	COMMON /TUBE1/XINT,XINT1,ND
	COMMON /TUBE2/IDTUBE,VOLT
	COMMON /BDSUB/TP,TS,C,CL,IE,UC,UCO,N5
	COMMON /COESUB/A1,A2,A3,AIJK
	DATA C/.001,.5,.999,.3,.3,.999,.5,.001,.7,.35,4*0.0,.35/
	IF(K1.NE.3)GOTO 4
	WRITE(6,950)
	DO 2 I=1,N
	WRITE(6,960)I,IELE(I),NE(I),NO(I)
	READ(5,*)CAM(I)
2	CONTINUE
	GOTO 5
4	IF(K1.EQ.1)GOTO 5
	C(1,1)=.2
	C(2,1)=.8
	C(1,2)=.8
	C(2,2)=.2
5	WRITE(6,1000)
	READ(5,*)ITP,ITS
	TP=1.0/SIN(FLOAT(ITP)*.0174533)
	TS=1.0/SIN(FLOAT(ITS)*.0174533)
	WRITE(6,1010)
	DO 10 I=1,N
	WRITE(6,1020)I,IELE(I)
	READ(5,*)ISR(I)
	CALL ATNUM(IELE(I),IZ(I))
	CALL CHAWV(CL(I,1),IELE(I),ISR(I))
	CALL ABSEDG(CL(I,2),IELE(I),ISR(I))
	CALL YIELD(Y,IELE(I),ISR(I))
	CALL JUMRAT(RJM,IELE(I),ISR(I))
	CL(I,3)=Y*RJM
	CL(I,4)=1.0
	IF(K1.NE.1)CALL AFIOX(CL(I,4),IELE(I),NE(I),NO(I))
	IE(I)=IELE(I)
10	CONTINUE
C
	WRITE(6,1022)
	READ(5,1024)KK2
	CALL TUBDAT
	IF(K1.EQ.3)CALL APAFD
	IF(K1.EQ.3) RETURN
	DO 170 II=1,N
	IF(K1.EQ.1.AND.KK2.EQ.'Y ')WRITE(6,1030)IDTUBE,VOLT,ITP,ITS,
     +IELE(II),IZ(II)
	IF(K1.EQ.2.AND.KK2.EQ.'Y ')WRITE(6,1040)IDTUBE,VOLT,ITP,ITS,
     +IELE(II),NE(II),NO(II),IZ(II)
	IF(KK2.EQ.'Y ')WRITE(6,1050)(IZ(I),I=1,N)
	IF(K1.EQ.1.AND.KK2.EQ.'Y ')WRITE(6,1060)(IELE(I),I=1,N)
	IF(K1.EQ.2.AND.KK2.EQ.'Y ')WRITE(6,1070)(IELE(I),NE(I),NO(I),
     +I=1,N)
	DO 15 J=1,4
	Z=CL(1,J)
	CL(1,J)=CL(II,J)
	CL(II,J)=Z
15	CONTINUE
	NAM=IE(1)
	IE(1)=IE(II)
	IE(II)=NAM
	DO 20 I=1,N
	A1(II,I)=0.0
	A2(II,I)=0.0
	A3(II,I)=0.0
	DO 20 J=1,N
	AIJK(II,I,J)=0.0
20	CONTINUE
C
	ICAS=1
	N2=N
30	IF(ICAS.EQ.2)N2=N-1
	DO 110 M=2,N2
	DO 35 J=1,4
	Z=CL(2,J)
	CL(2,J)=CL(M,J)
	CL(M,J)=Z
35	CONTINUE
	NAM=IE(2)
	IE(2)=IE(M)
	IE(M)=NAM
	M1=M+1
	IF(ICAS.EQ.1)M1=N
	DO 100 MM=M1,N
	IF(ICAS.EQ.1)GOTO 40
	DO 38 J=1,4
	Z=CL(3,J)
	CL(3,J)=CL(MM,J)
	CL(MM,J)=Z
38	CONTINUE
	NAM=IE(3)
	IE(3)=IE(MM)
	IE(MM)=NAM
40	CONTINUE
C
	IF(ICAS.EQ.1)N5=2
	IF(ICAS.EQ.2)N5=3
	DO 50 J=1,N5
	IF(K15.EQ.1)UCO(J)=MU('O ',CL(J,1))
	IF(K15.EQ.2)UCO(J)=MAC('O ',CL(J,1))
	DO 50 K=1,N5
	IF(K15.EQ.1)UC(J,K)=MU(IE(J),CL(K,1))
	IF(K15.EQ.2)UC(J,K)=MAC(IE(J),CL(K,1))
50	CONTINUE
	I1=1
	I2=4
	IF(ICAS.EQ.2)I1=5
	IF(ICAS.EQ.2)I2=5
	DO 90 I=I1,I2
	SW1=0.0
	SWDB1(1)=0.0
	KK5=1
	IF(IDTUBE.EQ.'CR'.AND.IE(1).EQ.'CR')KK5=2
	IF(IDTUBE.EQ.'CR'.AND.IE(1).EQ.'MN')KK5=2
	K12=0
	DO 60 K=1,ND
	IF(XINT(1,K).GT.CL(1,2))GOTO 70
	CALL BDCOEF(SW,SWDB,SWLOI,I,XINT(1,K),XINT(2,K),K1,KK5,K15,K12)
	SW1=SW1+SW
	SWDB1(1)=SWDB1(1)+SWDB(1)
60	CONTINUE
70	DO 80 K=1,11
	IF(XINT1(1,K).EQ.0.0)GOTO 80
	IF(XINT1(1,K).GT.CL(1,2))GOTO 80
	CALL BDCOEF(SW,SWDB,SWLOI,I,XINT1(1,K),XINT1(2,K),K1,KK5,
     +            K15,K12)
	SW1=SW1+SW
	SWDB1(1)=SWDB1(1)+SWDB(1)
80	CONTINUE
C
	G(I)=(SW1/SWDB1(1)-1.0)/C(I,2)
90	CONTINUE
C
	IF(ICAS.EQ.1)GOTO 100
	AIJK(II,MM,M)=(G(5)*C(5,2)-ALFA(M)*C(5,2)-ALFA(MM)*C(5,3))
     +/(C(5,2)*C(5,3))
	DO 95 J=1,4
	Z=CL(MM,J)
	CL(MM,J)=CL(3,J)
	CL(3,J)=Z
95	CONTINUE
	NAM=IE(MM)
	IE(MM)=IE(3)
	IE(3)=NAM
100	CONTINUE
C
	IF(ICAS.EQ.2)GOTO 110
	IF(K1.EQ.1)A1(II,M)=G(3)
	IF(K1.EQ.2)A1(II,M)=(G(1)*C(2,2)-G(2)*C(1,2))/(C(2,2)-
     +C(1,2))
	IF(K1.EQ.1)A2(II,M)=G(1)-G(3)
	IF(K1.EQ.2)A2(II,M)=(G(2)-G(1))/(C(2,2)-C(1,2))
	IF(K1.EQ.1)A3(II,M)=(G(1)-G(2))/(G(2)-G(3))-1.0
	IF(K1.EQ.2)A3(II,M)=0.0
	ALFA(M)=G(4)
110	CONTINUE
	IF(ICAS.EQ.2)GOTO 120
	IF(N.EQ.2)GOTO 120
	DO 118 I=3,N
	I1=I-1
	DO 115 J=1,4
	Z=CL(I1,J)
	CL(I1,J)=CL(I,J)
	CL(I,J)=Z
115	CONTINUE
	NAM=IE(I1)
	IE(I1)=IE(I)
	IE(I)=NAM
118	CONTINUE
	ICAS=ICAS+1
	GOTO 30
C
120	IF(II.EQ.1)GOTO 150
	DO 140 J=2,II
	JJ=J-1
	Z=A1(II,JJ)
	A1(II,JJ)=A1(II,J)
	A1(II,J)=Z
	Z=A2(II,JJ)
	A2(II,JJ)=A2(II,J)
	A2(II,J)=Z
	Z=A3(II,JJ)
	A3(II,JJ)=A3(II,J)
	A3(II,J)=Z
	DO 130 I=2,II
	I1=I-1
	Z=AIJK(II,I1,J)
	AIJK(II,I1,J)=AIJK(II,I,J)
	AIJK(II,I,J)=Z
130	CONTINUE
	DO 140 I=2,N
	Z=AIJK(II,I,JJ)
	AIJK(II,I,JJ)=AIJK(II,I,J)
	AIJK(II,I,J)=Z
140	CONTINUE
150	CONTINUE
C
	IF(KK2.EQ.'N ')GOTO 170
	WRITE(6,1080)(A1(II,J),J=1,N)
	WRITE(6,1090)(A2(II,J),J=1,N)
	IF(K1.EQ.1)WRITE(6,1100)(A3(II,J),J=1,N)
	IF(K1.EQ.1)WRITE(6,1110)IZ(1),IELE(1),AIJK(II,1,1)
	IF(K1.EQ.2)WRITE(6,1120)IZ(1),IELE(1),NE(1),NO(1),AIJK(II,1,1)
	DO 160 J=2,N
	NA=J-1
	IF(K1.EQ.1)WRITE(6,1130)IZ(J),IELE(J),(AIJK(II,J,K),K=1,NA)
	IF(K1.EQ.2)WRITE(6,1140)IZ(J),IELE(J),NE(J),NO(J),
     +(AIJK(II,J,K),K=1,NA)
160	CONTINUE
C
	N2=N-1
	IF(N2.LT.3)GOTO 170
	DO 168 I=3,N2
	I1=I-1
	DO 165 J=1,4
	Z=CL(I1,J)
	CL(I1,J)=CL(I,J)
	CL(I,J)=Z
165	CONTINUE
	NAM=IE(I1)
	IE(I1)=IE(I)
	IE(I)=NAM
168	CONTINUE
170	CONTINUE
190	RETURN
950	FORMAT(1X,'INPUT MEAN CONCENTRATIONS (WEIGHT FRACTION) OF ANALYT
     +ES IN THE SPECIMENS TO BE ANALYZED:')
960	FORMAT(3X,'I=',I2,4X,A2,I1,1HO,I1,4X,$)
1000	FORMAT(1X,'FOR SAMPLE GEOMETRY, INPUT INCIDENCE & EMERGENCE ANGL
     +ES (DEGREE-XX):  ',$)
1010	FORMAT(1X,'INPUT THE CHARACTERISTIC LINE NUMBER YOU WISH TO MEAS
     +URE (1-KA, 2-KB, 3-LA1, 4-LB1, 5-LB2):')
1020	FORMAT(1X,'I=',I2,4X,A2,4X,$)
1022	FORMAT(1X,'DO YOU WANT TO PRINT OUT CALCULATED ALPHA COEFFICIENT
     +S(Y/N):  ',$)
1024 	FORMAT(A1)
1030	FORMAT(1H1,//,41X,'BASIC ALPHA COEFFICIENTS FOR USE IN COLA 
     +EQUATION'//58X,'(ELEMENTAL SYSTEM)',////,
     +55X,'  TARGET: ',A2,2X,F5.1,' KV',/,
     +55X,'GEOMETRY: ',I2,',',I2,' DEGREES',///,
     +58X,' ANALYTE: ',A2,1X,'(',I2,')',//)
1040	FORMAT(1H1,//,41X,'HYBRID ALPHA COEFFICIENTS FOR USE IN COLA
     + EQUATION'//58X,'(OXIDE    SYSTEM)',////,
     +55X,'  TARGET: ',A2,2X,F5.1,' KV',/,
     +55X,'GEOMETRY: ',I2,',',I2,' DEGREES',///,
     +56X,' ANALYTE: ',A2,I1,'O',I1,1X,'(',I2,')',//)
1050	FORMAT(16X,16(5X,I2,1X),/)
1060	FORMAT(/17X,16(4X,A2,2X),/)
1070	FORMAT(/18X,16(2X,A2,I1,'O',I1,1X),/)
1080	FORMAT(/11X,'A1',4X,12F8.3)
1090	FORMAT(/11X,'A2',4X,12F8.3)
1100	FORMAT(/11X,'A3',4X,12F8.3)
1110	FORMAT(/5X,'AIJK  ',I2,1X,A2,1X,F8.3,1X)
1120	FORMAT(/2X,'AIJK  ',I2,1X,A2,I1,'O',I1,1X,F8.3,1X)
1130	FORMAT(/11X,I2,1X,A2,1X,12F8.3)
1140	FORMAT(/8X,I2,1X,A2,I1,'O',I1,1X,12F8.3)
	END
	SUBROUTINE APAFD
C
C	 THIS SUBROUTINE PERFORMS MOST OF THE CALCULATION FOR 
C	OBTAINING THE ALPHA COEFFICIENTS USED IN FUSED DISC
C	SYSTEM.
C
C	NBS     04-SEP-84
C
	REAL MAC,MU
	DIMENSION CAM(12),UCO(12),UCF(12),SWDB1(12),XINT(2,300),
     +          XINT1(2,11),UC(12,12),IELE(12),NE(12),NO(12),
     +          C(5,3),CL(12,4),IE(12),A1(12,12),A2(12,12)
	DIMENSION SWDB(12),IZ(12)
	COMMON K15,K1,N,IELE,NE,NO,KK2,CAM,IZ,ITP,ITS
	COMMON /COESUB/A1,A2
	COMMON /TUBE1/XINT,XINT1,ND
	COMMON /TUBE2/IDTUBE,VOLT
	COMMON /BDSUB/TP,TS,C,CL,IE,UC,UCO,N5,UCF,CA,CB,F,CLOI
	COMMON /WFRA/WLI,WB,WO,WF
	DATA CLOI/.25/
	N5=N
	WRITE(6,190)
	READ(5,*)K12
	GL=0.
	WRITE(6,180)
  180	FORMAT(' GRAMS OF SAMPLE:',$)
	READ(5,*)GS
	WRITE(6,182)
  182	FORMAT(' GRAMS OF LI2B407:',$)
	READ(5,*)GF
	IF(K12.EQ.1) GO TO 4
	IF(K12.EQ.2) WRITE(6,184)
  184	FORMAT(' GRAMS OF LIF:',$)
	IF(K12.EQ.3) WRITE(6,186)
  186	FORMAT(' GRAMS OF LIBO2:',$)
	READ(5,*)GL
    4	CONTINUE
	TWT=GF+GL
	F=GS/(TWT+GS)
	GO TO (6,7,8),K12
    6	WLI=.0821
	WB=.2557
	WF=0.
	WO=.6623
	GO TO 9
    7	WLI=(GF*.0821+GL*.2675)/TWT
	WB=GF*.2557/TWT
	WO=GF*.6623/TWT
	WF=GL*.7325/TWT
	GO TO 9
    8	WLI=(GF*.0821+GL*.1395)/TWT
	WB=(GF*.2557+GL*.2173)/TWT
	WO=(GF*.6623+GL*.6432)/TWT
	WF=0.
    9	CONTINUE
	IF(KK2.NE.'Y ')GOTO 5
	WRITE(6,192)IDTUBE,VOLT,ITP,ITS,(IZ(I),I=1,N)
	WRITE(6,194)(IELE(I),NE(I),NO(I),I=1,N)
	WRITE(6,196)(CAM(I),I=1,N)
	WRITE(6,198)
5 	DO 100 I=1,N
	CA=CAM(I)
	CB=1.0-CA
	DO 10 J=1,4
	Z=CL(1,J)
	CL(1,J)=CL(I,J)
	CL(I,J)=Z
10	CONTINUE
	NAM=IE(1)
	IE(1)=IE(I)
	IE(I)=NAM
C
	DO 20 J=1,N
	IF(K15.EQ.2) GO TO 15
C  K15 EQUALS 1
	UCO(J)=MU('O ',CL(J,1))
	UCF(J)=WLI*MU('LI',CL(J,1))+WB*
     1 MU('B ',CL(J,1))+WO*UCO(J)+WF*MU('F ',CL(J,1))
	GO TO 18
C  K15 EQUALS 2
   15	UCO(J)=MAC('O ',CL(J,1))
	UCF(J)=WLI*MU('LI',CL(J,1))+WB*
     1 MU('B ',CL(J,1))+WO*UCO(J)+WF*MU('F ',CL(J,1))
   18	CONTINUE
	SWDB1(J)=0.0
	DO 20 K=1,N
	IF(K15.EQ.1)UC(J,K)=MU(IE(J),CL(K,1))
	IF(K15.EQ.2)UC(J,K)=MAC(IE(J),CL(K,1))
20	CONTINUE
	SW1=0.0
	SWLOI1=0.0
	KK5=1
	IF(IDTUBE.EQ.'CR'.AND.IE(1).EQ.'CR')KK5=2
	IF(IDTUBE.EQ.'CR'.AND.IE(1).EQ.'MN')KK5=2
	DO 40 K=1,ND
	IF(XINT(1,K).GT.CL(1,2))GOTO 50
	CALL BDCOEF(SW,SWDB,SWLOI,1,XINT(1,K),XINT(2,K),K1,KK5,K15,K12)
	SW1=SW1+SW
	SWLOI1=SWLOI1+SWLOI
	DO 30 J=2,N
	SWDB1(J)=SWDB1(J)+SWDB(J)
30	CONTINUE
40	CONTINUE
50	DO 70 K=1,11
	IF(XINT1(1,K).EQ.0.0)GOTO 70
	IF(XINT1(1,K).GT.CL(1,2))GOTO 70
	CALL BDCOEF(SW,SWDB,SWLOI,1,XINT1(1,K),XINT1(2,K),K1,KK5,
     +              K15,K12)
	SW1=SW1+SW
	SWLOI1=SWLOI1+SWLOI
	DO 60 J=2,N
	SWDB1(J)=SWDB1(J)+SWDB(J)
60	CONTINUE
70	CONTINUE
C
	A2(I,1)=0.0
	DO 80 J=2,N
	RA=CA*SWDB1(J)/SW1
	A2(I,J)=(CA/RA-1.0)/CB
80	CONTINUE
	A1(I,1)=(SW1*(1.0-F*CLOI)/SWLOI1-1.0)/CLOI
	A1(I,2)=0.0
C
	IF(I.EQ.1)GOTO 100
	DO 90 J=2,I
	JJ=J-1
	Z=A2(I,JJ)
	A2(I,JJ)=A2(I,J)
	A2(I,J)=Z
90	CONTINUE
100	CONTINUE
C
	IF(KK2.NE.'Y ')RETURN
	DO 110 I=1,N
	WRITE(6,200)IZ(I),IELE(I),NE(I),NO(I),A1(I,1),(A2(I,J),J=1,N)
110	CONTINUE
	IF(K12.EQ.1)WRITE(6,210)GS,GF
	IF(K12.EQ.2)WRITE(6,220)GS,GF,GL
	IF(K12.EQ.3)WRITE(6,230)GS,GF,GL
	RETURN
190   FORMAT(1X,'WHAT FLUX CONDITIONS DO YOU WISH :'/
     +3X,'1-SAMPLE + LI2B4O7',/
     +3X,'2-SAMPLE + LI2B4O7 + LIF',/
     +3X,'3-SAMPLE + LI2B4O7 + LIBO2 ?  ',$)
192	FORMAT(1H1,//36X,'MODIFIED ALPHA COEFFICIENTS FOR USE IN COLA EQ
     +UATION'//57X,'(FUSED DISK SYSTEM)',////,
     +55X,'  TARGET: ',A2,2X,F5.1,' KV',/
     +55X,'GEOMETRY: ',I2,',',I2,'  DEGREES',///,
     +58X,'MATRIX CONSTITUENTS'//18X,12(6X,I2))
194	FORMAT(/15X,'LOI',3X,12(1X,A2,I1,1HO,I1,2X))
196	FORMAT(/1X,'MEAN CONC.',2X,' 25.00  ',12(2PF6.2,2X))
198	FORMAT(/3X,'ANALYTE')
200	FORMAT(/2X,I2,2X,A2,I1,1HO,I1,13F8.3)
210   FORMAT(///1X,'* FUSED DISK :',F6.4,'G SAMPLE +',F6.4,'G LI2B4O7')
220   FORMAT(///' * FUSED DISK :',F6.4,'G SAMPLE +',F6.4,'G LI2B4O7 +',
     +F6.4,'G LIF')
230   FORMAT(///1X,'* FUSED DISK :',F6.4,'G SAMPLE +',F6.4,'G LI2B4O7',
     +F6.4,'LIBO2')
	END
	SUBROUTINE ATNUM(INAM,IZ)
C
C	THIS SUBROUTINE PROVIDES THE ATOMIC NUMBER WHEN A 
C	CORRESPONDING ELEMENT NAME IS GIVEN.
C
C	NBS      04-SEP-1984
C
	DIMENSION ID(94)
	DATA ID/'H ','HE','LI','BE','B ','C ','N ','O ','F ',
     1 'NE','NA','MG','AL','SI','P ','S ','CL','AR','K ','CA',
     1 'SC','TI','V ','CR','MN','FE','CO','NI','CU','ZN','GA',
     1 'GE','AS','SE','BR','KR','RB','SR','Y ',
     1 'ZR','NB','MO','TC','RU','RH','PD','AG','CD','IN','SN',
     1 'SB','TE','I ','XE','CS','BA','LA','CE','PR','ND','PM',
     1 'SM','EU','GD','TB','DY','HO','ER','TM','YB','LU','HF',
     1 'TA','W ','RE','OS','IR','PT','AU','HG','TL','PB','BI',
     1 'PO','AT','RN','FR','RA','AC','TH','PA','U ','NP','PU'/
	DO 10 I=1,94
	 IF(INAM.EQ.ID(I)) GO TO 20
10	CONTINUE
	WRITE(6,100)INAM
	STOP
20	IZ=I
100	FORMAT(/1X,'ERROR: ',A2,' IS NOT A CORRECT ELEMENT NAME AMONG 1 
     +H-94 PU.')
   	RETURN
	END
	SUBROUTINE CHAWV(WV,IELE,ISR)
C
C	THIS SUBROUTINE PROVIDES CHARACTERISTIC LINE
C	WAVELENGTHS (KA,KB,LA1,LB1,LB2) BY MEANS OF AN
C	EMPIRICAL FIT. THIS FIT IS NOT RECOMMENDED FOR 
C	LINES BELOW 1 KEV.
C
C	NBS     04-SEP-1984
C
	DIMENSION D1(5),D2(5),D3(5)
	DATA D1/-.0199726,-.060101,-.123941,-.00322523,-.197431/
	DATA D2/2.22412,2.52781,3.29533,2.48613,4.01718/
	DATA D3/-5.1774,-5.6437,-9.75836,-8.37742,-11.3323/
	CALL ATNUM(IELE,IZ)
	ZI=IZ
	ZL=ALOG(ZI)
	WV=12.398/EXP(D1(ISR)*ZL*ZL+D2(ISR)*ZL+D3(ISR))
	RETURN
	END
	SUBROUTINE ABSEDG(WV,IELE,ISR)
C
C	THIS SUBROUTINE CALCULATES THE WAVELENGTH OF AN ABSORPTION
C	EDGE FROM THE CHARACTERISTIC LINE WAVELENGTH.
C	THIS EMPIRICAL FIT IS NOT RECOMMENDED BELOW 1 KEV.
C
C	NBS     04-SEP-1984
C
	DIMENSION C1(3),C2(3),C3(3)
	DATA C1/-.0397931,-.0865397,-.2283427/
	DATA C2/2.423000,3.323153,4.311724/
	DATA C3/5.509104,10.25054,12.00253/
	CALL ATNUM(IELE,IZ)
	ZI=IZ
	ZL=ALOG(ZI)
	IF(ISR.EQ.1.OR.ISR.EQ.2)WV=EXP(C1(1)*ZL*ZL+C2(1)*ZL-C3(1))
	IF(ISR.EQ.3.OR.ISR.EQ.5)WV=EXP(C1(3)*ZL*ZL+C2(3)*ZL-C3(3))
	IF(ISR.EQ.4)WV=EXP(C1(2)*ZL*ZL+C2(2)*ZL-C3(2))
	WV=12.398/WV
	RETURN
	END
	SUBROUTINE JUMRAT(JUMP,IELE,ISR)
C
C	THIS SUBROUTINE PROVIDES JUMP RATIOS (1-1/R)
C	FOR K OR L III ABSORPTION EDGES.
C	FROM REFERENCE: E.P.BERTIN, 'PRINCIPLES & PRACTICE OF
C	                X-RAY SPECTROMETRIC ANALYSIS' SECOND
C	                EDITION, 1975. P977-979
C
C	NBS     04-SEP-1984
C
	DIMENSION JK(94),JL(94)
	REAL JK,JL,JUMP
	DATA JK/3*1.0,.970,.965,.959,.953,.948,.943,.937,.932,.927,
     +       .921,.916,.911,.903,.895,.899,.887,.890,.883,.883,.886,
     +       .886,.884,.878,.881,.873,.874,.868,.865,.862,.861,.855,
     +       .857,.858,.854,.858,.854,.852,.860,.856,.853,.852,.847,
     +       .856,.848,.846,.840,.845,.843,.839,.838,.835,.832,.828,
     +       .835,.830,.828,.833,.831,.827,.824,.827,.819,.818,.812,
     +       .818,.813,.807,.808,.816,.801,.805,.791,.803,.807,.805,
     +       .797,.801,.795,.791,.788,2*0.0,.788,3*0.0,.772,0.0,
     +       .773,0.0,.779/
	DATA JL/27*0.0,.639,.652,.824,.824,.825,.795,.782,.782,.760,
     +       .763,.744,.752,.748,.735,.728,.722,.708,.731,.706,
     +       .690,.692,.693,.673,.660,.664,.650,.653,.649,.648,
     +       .632,.635,.629,.624,.630,.627,.633,.630,.631,.636,.650,
     +       .659,.637,.611,.618,.586,.615,.618,.626,.605,.581, 
     +	     .620,.590,.583,.600,.591,.572,2*0.0,.573,3*0.0,.581,
     +	     0.0,.562,0.0,.556/
	CALL ATNUM(IELE,IZ)
	IF(ISR.EQ.1.OR.ISR.EQ.2)JUMP=JK(IZ)
	IF(ISR.EQ.3.OR.ISR.EQ.4.OR.ISR.EQ.5)JUMP=JL(IZ)
	RETURN
	END
	SUBROUTINE YIELD(Y,IELE,ISR)
C
C	THE SUBROUTINE PROVIDES X-RAY FLUORESCENT YIELDS FOR K,
C	L II OR L III SERIES LINES BY MEANS OF EMPIRICAL FITS.
C
C	NBS     04-SEP-1984
C
	CALL ATNUM(IELE,IZ)
	ZI=IZ
	ZL=ALOG(ZI)
	IF(ISR.EQ.3.OR.ISR.EQ.5)GOTO 10
	IF(ISR.EQ.4)GOTO 20
	OM1=(.015+.0327*ZI-6.4E-7*ZI**3)**4
	Y=OM1/(1.0+OM1)
	RETURN
10	OM1=(-.901+.0466*ZI-4.961E-4*ZI*ZI+2.296E-6*ZI**3)**4
	Y=OM1/(1.0+OM1)
	RETURN
20	OM1=(.491-.010*ZI+2.55E-4*ZI*ZI-9.20E-7*ZI**3)**4
	Y=OM1/(1.0+OM1)
	RETURN
	END
	SUBROUTINE AFIOX(AFOX,IELE,NE,NO)
C
C	THIS SUBROUTINE CALCULATES THE ATOMIC FRACTION OF THE 
C	ANALYTE IN A DEFINED OXIDE.
C
C	NBS     04-SEP-1984
C
	CALL SBATWT('O ',AWO)
	CALL SBATWT(IELE,AWE)
	AFOX=AWE*FLOAT(NE)
	AFOX=AFOX/(AFOX+AWO*FLOAT(NO))
	RETURN
	END
	SUBROUTINE BDCOEF(SW,SWDB,SWLOI,I,WV1,WV2,K1,KK5,K15,K12)
C
C	 THIS SUBROUTINE CALCULATES BETA AND DELTA COEFFICIENTS
C	IN MODIFIED VERSION OF SHERMAN'S EQUATION AT A CERTAIN 
C	WAVELENGTH AND CORRESPONDING X-RAY TUBE SPECTRAL INTENSITY.
C
C	NBS     31-OCT-1984
C
	REAL MAC,MU
	DIMENSION C(5,3),CL(12,4),U(12),BETA(12),DELTA(12),UC(12,12),
     +	    IE(12),UCO(12),UCF(12),SWDB(12)
	COMMON /BDSUB/TP,TS,C,CL,IE,UC,UCO,N5,UCF,CA,CB,F,CLOI
	COMMON/WFRA/WLI,WB,WO,WF
	IF(K15.EQ.2) GO TO 4
C  K15 EQUALS 1
	UO=MU('O ',WV1)
	UF=WLI*MU('LI',WI1)+WB*MU('B ',WV1)+ WO*UO+WF*MU('  ',WV1)
	GO TO 6
   4	CONTINUE
C  K15 EQUALS 2
	UO=MAC('O ',WV1)
	UF=WLI*MAC('LI',WV1)+WB*MAC('B ',WV1)+WO*UO+WF*MAC('F ',WV1)
   6	CONTINUE
	DO 10 J=1,N5
	IF(K15.EQ.1)U(J)=MU(IE(J),WV1)
	IF(K15.EQ.2)U(J)=MAC(IE(J),WV1)
10	CONTINUE
C	
C	CALCULATION OF BETA COEFFICIENTS
C	0.081 G/CM2 AL FILTER IS USED FOR ANALYTES CR & MN
C	WHEN CR TARGET OF X-RAY TUBE IS EMPLOYED.
C
	IF(KK5.EQ.2.AND.K15.EQ.1)WV2=WV2*EXP(-.081*MU('AL',WV1))
	IF(KK5.EQ.2.AND.K15.EQ.2)WV2=WV2*EXP(-.081*MAC('AL',WV1))
	DEN=CL(1,4)*(U(1)*TP+UC(1,1)*TS)+(1.0-CL(1,4))*(UO*TP+UCO(1)*TS)
	W=U(1)*WV2/DEN
	IF(KK5.EQ.2.AND.K15.EQ.1)WV2=WV2/EXP(-.081*MU('AL',WV1))
	IF(KK5.EQ.2.AND.K15.EQ.2)WV2=WV2/EXP(-.081*MAC('AL',WV1))
	IF(K1.EQ.3)PHIF=(UF*TP+UCF(1)*TS)/DEN-1.0
	IF(K1.NE.3)SBETA=0.0
	N2=2
	IF(K1.EQ.3)N2=1
	DO 20 J=N2,N5
	BETA(J)=(CL(J,4)*(U(J)*TP+UC(J,1)*TS)+(1.0-CL(J,4))*(UO*TP+
     +	UCO(1)*TS))/DEN-1.0
	IF(K1.NE.3)SBETA=SBETA+C(I,J)*BETA(J)
20	CONTINUE
C
C	CALCULATION OF DELTA COEFFICIENTS
C
	IF(K1.NE.3)SDELTA=0.0
	DO 60 J=1,N5
	IF(WV1.GT.CL(J,2).OR.CL(J,1).GT.CL(1,2))GOTO 40
	IF(K1.EQ.3)GOTO 32
	UE=0.0
	UEI=0.0
	UEJ=0.0
	DO 30 L=1,N5
	UE=UE+(CL(L,4)*U(L)+(1.0-CL(L,4))*UO)*C(I,L)*TP
	UEI=UEI+(CL(L,4)*UC(L,1)+(1.0-CL(L,4))*UCO(1))*C(I,L)*TS
	UEJ=UEJ+(CL(L,4)*UC(L,J)+(1.0-CL(L,4))*UCO(J))*C(I,L)
30	CONTINUE
	GOTO 34
32	UE=((CL(1,4)*U(1)+(1.0-CL(1,4))*UO)*CA+(CL(J,4)*U(J)+(1.0-
     +  CL(J,4))*UO)*CB)*TP
 	UE=F*UE+(1.0-F)*UF*TP
	UEI=((CL(1,4)*UC(1,1)+(1.0-CL(1,4))*UCO(1))*CA+(CL(J,4)*
     +  UC(J,1)+(1.0-CL(J,4))*UCO(1))*CB)*TS
	UEI=F*UEI+(1.0-F)*UCF(1)*TS
	UEJ=(CL(1,4)*UC(1,J)+(1.0-CL(1,4))*UCO(J))*CA+(CL(J,4)*
     +  UC(J,J)+(1.0-CL(J,4))*UCO(J))*CB
	UEJ=F*UEJ+(1.0-F)*UCF(J)
34	T1=.5*CL(J,3)*CL(J,4)*UC(1,J)*U(J)/U(1)
	T2=(ALOG(1.0+UE/UEJ))/UE
	T3=(ALOG(1.0+UEI/UEJ))/UEI
	DELTA(J)=T1*(T2+T3)
	GOTO 50
40	DELTA(J)=0.0
50	IF(K1.NE.3)SDELTA=SDELTA+C(I,J)*DELTA(J)
60	CONTINUE
	IF(K1.EQ.3)GOTO 70
	SW=W
	SWDB(1)=W*(1.0+SDELTA)/(1.0+SBETA)
	RETURN
70	SW=W/(1.0+(1.0-F)*PHIF)
	CF=(1.0-F)/(1.0-F*CLOI)
	SWLOI=W/(1.0+CF*PHIF)
	DO 80 J=2,N5
	SWDB(J)=W*(1.0+F*CB*DELTA(J))/(1.0+F*CB*BETA(J)+(1.0-F)*PHIF)
80	CONTINUE
	RETURN
	END
	SUBROUTINE TUBDAT
C
C	 THIS SUBROUTINE PROVIDES THE X-RAY TUBE SPECTRAL DISTRIBUTION
C	NEEDED FOR CALCULATING ALPHA COEFFICIENTS BY USING EITHER THE
C	NBS ALGORITHM OR MEASURED DATA FROM THE LITERATURE.
C
C	NBS     04-SEP-1984
C
	DIMENSION XINT(2,300),IDLINE(4),DATTGT(2,11),DFSP(6),
     +  XINT1(2,11)
	COMMON K15
	COMMON /TUBE1/XINT,XINT1,ND
	COMMON /TUBE2/IDTUBE,VOLT,TOFAGL,WINTHI
	DATA IDLINE/'KA','KB','LA','LB'/
	WRITE(6,100)
	READ(5,*)K11
	WRITE(6,105)
	READ(5,125)KK11
	WRITE(6,140)
	READ(5,125)IDTUBE
	WRITE(6,150)
	READ(5,*)VOLT,TOFAGL,WINTHI
	IF(K11.EQ.1)GOTO 10
	WRITE(6,110)
	READ(5,120)DFSP
	WRITE(6,130)
	READ(5,*)ND
	OPEN(UNIT=3,NAME=DFSP,TYPE='OLD')
	READ(3,*,ERR=5)((XINT(I,J),J=1,ND),I=1,2),((XINT1(I,J),J=1,11),
     +  I=1,2)
5	CLOSE(UNIT=3)
	GOTO 50
10	WRITE(6,160)
	READ(5,*)EDGE
	WVMIN=12.398/VOLT
	ND=IFIX((EDGE-WVMIN)/.02)+1
	WV=WVMIN
	XINT(1,1)=WVMIN
	XINT(2,1)=0.0
	DO 20 I=2,ND
	WV=WV+.02
	XINT(1,I)=WV
	CALL CTNLIN(XINT(2,I),WV)
20	CONTINUE
	CALL INFTGT(K12,IDLINE,DATTGT,IDTUBE)
	DO 25 I=1,11
	XINT1(1,I)=0.0
	XINT1(2,I)=0.0
25	CONTINUE
	DO 30 I=1,4
	IF(IDLINE(I).EQ.'  ')GOTO 30
	XINT1(1,I)=DATTGT(1,I)
	CALL CHALIN(CINT,DATTGT(1,I),IDLINE(I))
	IF(IDLINE(I).EQ.'LA')RLA=CINT
	XINT1(2,I)=CINT*50.0
30	CONTINUE
	IF(K12.EQ.1)GOTO 50
	DO 40 I=5,11
	IF(K12.EQ.2.AND.I.GT.8)GOTO 50
	XINT1(1,I)=DATTGT(1,I)
	CINT=RLA*DATTGT(2,I)
	XINT1(2,I)=CINT*50.0
40	CONTINUE
50	IF(KK11.EQ.'N ')GOTO 60
	IF(K11.EQ.1)WRITE(6,180)
	IF(K11.EQ.2)WRITE(6,190)
	WRITE(6,200)IDTUBE,VOLT,TOFAGL,WINTHI,(XINT(1,I),XINT(2,I)
     +  ,I=1,ND)
	WRITE(6,210)((XINT1(I,J),J=1,11),I=1,2)
	WRITE(6,220)
60	RETURN
100	FORMAT(' WHICH X-RAY TUBE SPECTRAL DISTRIBUTION DO YOU PREFER:'
     +  /3X,'1-CALCULATED SPECTRUM FROM NBS ALGORITHM  ;  2-MEASURED SPE
     +CTRUM ?  ',$)
105	FORMAT(1X,'DO YOU WANT TO PRINT OUT THE SPECTRAL DISTRIBUTION(Y/
     +N) ?  ',$)
110	FORMAT(' INPUT THE DATAFILE NAME OF X-RAY TUBE SPECTRUM(XXXXXX.X
     +XX) :  ',$)
120	FORMAT(6A4)
125	FORMAT(A2)
130	FORMAT(1X,'INPUT TOTAL NUMBER OF WAVELENGTH INTERVALS FOR CONTIN
     +UUM (MAX.=300) :  ',$)
140	FORMAT(1X,'INPUT NAME OF X-RAY TUBE TARGET (XX) :  ',$)
150	FORMAT(' INPUT VOLTAGE(KV), TAKE-OFF ANGLE OF X-RAY FROM TUBE TA
     +RGET(DEGREE), AND'/'    WINDOW THICKNESS(MM) OF X-RAY TUBE :  ',$)
160	FORMAT(1X,'INPUT THE ENDING WAVELENGTH OF X-RAY TUBE SPECTRUM(AN
     +GSTROM) :  ',$)
180	FORMAT(1H1,////36X,'CALCULATED X-RAY TUBE SPECTRAL DISTRIBUTION
     +  ',/47X,'USING NBS ALGORITHM')
190	FORMAT(1H1,////,37X,'MEASURED X-RAY TUBE SPECTRAL DISTRIBUTION
     +  ')
200	FORMAT(//34X,'X-RAY TUBE TARGET: ',A2,4X,'KV: ',F5.1,4X,/,
     +  27X,'TAKE-OFF ANGLE(DEGREE): ',F4.1,4X,'BE WINDOW THICKNESS(MM): 
     + ',F5.3,///,3X,'LAMDA(A)',5X,'I*.02A',4X,'LAMDA(A)',5X,
     +  'I*.02A',4X,'LAMDA(A)',5X,'I*.02A',4X,'LAMDA(A)',5X,'I*.02A',
     +  4X,'LAMDA(A)',5X,'I*.02A',//(1X,5(F9.4,2X,E12.4)))
210	FORMAT(///6X,'KA',10X,'KB',10X,'LA1',9X,'LB1',9X,'LB2',
     +  9X,'LB3',9X,'LB4',9X,'LG1',9X,'LG2',9X,'LG3',9X,'LL',//
     +11(F10.4,2X)/11E12.4)
220	FORMAT(///)
	END
	SUBROUTINE CTNLIN(HINT,WV)
C
C	THIS SUBROUTINE CALCULATES THE CONTINUUM INTENSITY OF THE X-RAY 
C	TUBE SPECTRUM AT A GIVEN WAVELENGTH USING THE NBS ALGORITHM.
C	(UNIT: PHOTONS/A/E/STRD)
C
C	NBS     04-SEP-1984
C
	REAL MAC,MU
	COMMON K15
	COMMON /TUBE2/IDTUBE,VOLT,TOFAGL,WINTHI
	WVMIN=12.398/VOLT
	TB=.185*WINTHI
	R=.0174533*TOFAGL
	CALL ATNUM(IDTUBE,IZ)
	Z=FLOAT(IZ)
	IF(K15.EQ.1)PSE=MU(IDTUBE,WV)*(WVMIN**(-1.65)-WV**(-1.65))/
     +  SIN(R)
	IF(K15.EQ.2)PSE=MAC(IDTUBE,WV)*(WVMIN**(-1.65)-WV**(-1.65))/
     +  SIN(R)
	F=1.0+PSE*(1.0+(1.0+2.56E-3*Z**2)**(-1))/(1.0+2.56E3*WVMIN
     +  *Z**(-2))/(.25*PSE+1.0E4)
	HINT=2.72E-6*Z*(WV/WVMIN-1.0)*WV**(-2)*F**(-2)*
     +EXP(-.35*TB*WV**2.86)
	RETURN
	END
	SUBROUTINE INFTGT(K1,IDLINE,DATTGT,IDTUBE)
C
C	THE SUBROUTINE PROVIDES THE DATA NEEDED
C	FOR CALCULATING CHARACTERISTIC LINE INTENSITY
C	OF AN X-RAY TUBE SPECTRUM.
C
C	NBS     04-SEP-1984
C
	DIMENSION IDLINE(4),IDTGT(7),DATTGT(2,11)
	DATA IDTGT/'SC','CR','MO','RH','AG','W ','AU'/
	K1=2
	IF(IDTUBE.EQ.'SC'.OR.IDTUBE.EQ.'CR'.OR.IDTUBE.EQ.'MO')K1=1
	IF(K1.EQ.1)IDLINE(3)='  '
	IF(K1.EQ.1)IDLINE(4)='  '
	IF(IDTUBE.EQ.'W '.OR.IDTUBE.EQ.'AU')K1=3
	IF(K1.EQ.3)IDLINE(1)='  '
	IF(K1.EQ.3)IDLINE(2)='  '
	DO 10 I=1,7
	IF(IDTUBE.EQ.IDTGT(I))GOTO 20
10	CONTINUE
	WRITE(6,100)
	STOP
20	I1=I
	N1=2*I1-1
	N2=N1+1
	OPEN(UNIT=3,NAME='TGTWR.DAT',TYPE='OLD',ACCESS='DIRECT',
     +  MAXREC=14,RECORDSIZE=11)
	READ(3'N1)(DATTGT(1,J),J=1,11)
	READ(3'N2)(DATTGT(2,J),J=1,11)
	CLOSE(UNIT=3)
	RETURN
100	FORMAT(/1X,'ERRER: THE NAME OF X-RAY TUBE TARGET YOU INPUT IS NO
     +T CORRECT !'/3X,'IT SHOULD BE ONE OF THE SEVEN TARGETS: SC, CR, MO
     +, RH, AG, W & AU.')
	END
	SUBROUTINE CHALIN(CINT,WV,IDLINE)
C
C	THIS SUBROUTINE CALCULATES THE CHARACTERISTIC LINE INTENSITY 
C	OF AN X-RAY TUBE SPECTRUM USING THE NBS ALGORITHM. 
C	(UNIT: PHOTONS/E/STRD)
C
C	NBS     24-JUL-1984
C
	COMMON K15
	COMMON /TUBE2/IDTUBE,VOLT,TOFAGL,WINTHI
	CALL ATNUM(IDTUBE,IZ)
	Z=FLOAT(IZ)
	IF(IDLINE.EQ.'KA')FZ=3.22E6/(9.76E4+Z**4)-.39
	IF(IDLINE.EQ.'KB')FZ=5.13E5/(2.05E5+Z**4)-.014
	IF(IDLINE.EQ.'LA')FZ=2.02E7/(2.65E6+Z**4)+.21
	IF(IDLINE.EQ.'LB')FZ=1.76E7/(6.05E6+Z**4)-.09
	U=WV*VOLT/12.398
	R=EXP(-.5*((U-1.0)/(1.17*U+3.20))**2)
	RATIO=R*FZ*(U*ALOG(U)/(U-1.0)-1.0)
	CALL CTNLIN(HINT,WV)
	CINT=RATIO*HINT
	RETURN
	END
	SUBROUTINE SBATWT(NAME,ATWT)
C
C	THIS SUBROUTINE PROVIDES THE ATOMIC WEIGHT WHEN A
C	CORRESPONDING ELEMENT NAME IS GIVEN.
C	
C	NBS     04-SEP-1984
C
	DIMENSION AW(94)
	DATA AW/1.00797,4.0026,6.939,9.0122,10.811,12.01115,14.0067,
     1 15.9994,18.9984,20.183,22.9898,24.312,26.9815,28.086,30.9738,
     1 32.064,35.453,39.948,39.102,40.08,44.956,47.90,50.942,51.996,
     1 54.938,55.847,58.933,58.71,63.54,65.37,69.72,72.59,74.922,78.96,
     1 79.909,83.80,85.47,87.62,88.905,91.22,92.906,95.94,98.0,101.07,
     1 102.905,106.4,107.870,112.40,114.82,118.69,121.75,127.60,
     1 126.904,131.30,132.905,137.34,138.91,140.12,140.907,144.24,147.0,
     1 150.35,151.96,157.25,158.924,162.50,164.930,167.26,168.934,
     1 173.04,174.97,178.49,180.948,183.85,186.2,190.2,192.2,195.09,
     1 196.967,200.59,204.37,207.19,208.980,210.0,210.0,222.0,223.0,
     1 226.0,227.0,232.038,231.0,238.04,237.0,242.0/
	CALL ATNUM(NAME,IZ)
	ATWT=AW(IZ)
	RETURN
	END
	REAL FUNCTION MAC(INAM,WV)
C
C	THIS SUBROUTINE GENERATES MASS ABSORPTION COEFFICIENTS
C	AT A GIVEN WAVELENGTH FOR VARIOUS ELEMENTS ACCORDING
C	TO HEINRICH.
C
C	NBS     04-SEP-84
C
	DIMENSION C1(9),C2(9),C3(9),EC(9),CN(4),R(10)
	DIMENSION D1(4),D2(4),D3(4)
	DATA C1/-.0397931,-.0339160,-.0865397,-.2283427,1.251788,
     +          .8349031,.4422173,.2514096,.2729506/
	DATA C2/2.423000,2.825262,3.323153,4.311724,-7.837999,
     +	      -4.149247,-.9792409,.9319132,.6889060/
	DATA C3/5.509104,9.035256,10.25054,12.00253,-11.58026,
     +	      -3.338016,3.153478,8.035612,7.424300/
	DATA CN(3),CN(4)/2.6,2.22/
	DATA R/1.0,1.0,1.17,1.63,1.0,1.16,1.4,1.621,1.783,1.0/
	DATA D1/-.2322294,-.2544711,.2562163,1.359165/
	DATA D2/4.070053,4.769245,1.15119,-9.492116/
	DATA D3/-6.220746,-10.37878,-5.684848,18.64081/
	CALL ATNUM(INAM,IZ)
	E=12.398/WV
	ZI=IZ
	ZL=ALOG(ZI)
	DO 10 I=1,9
	EC(I)=EXP(C1(I)*ZL*ZL+C2(I)*ZL-C3(I))
10	CONTINUE
	CN(1)=EXP(-.0045522*ZL*ZL-.0068535*ZL+1.070181)
	CN(2)=2.73
	IF(IZ.LT.42)GOTO 20
	CN(2)=EXP(-.1131595*ZL*ZL+.8368829*ZL-.5459687)
20	CONTINUE
	DO 40 M=1,10
	IF(M.EQ.10)GOTO 30
	IF(E.LT.EC(M))GOTO 40
30	MI=M-M/3-M/4-M/7
	C=EXP(D1(MI)*ZL*ZL+D2(MI)*ZL+D3(MI))/R(M)
	MAC=C*WV**CN(MI)
	RETURN
40	CONTINUE
	END
	REAL FUNCTION MU(INAM,WV)
C
C	THIS SUBROUTINE GENERATES MASS ABSORPTION COEFFICIENTS AT
C	A GIVEN WAVELENGTH FOR VARIOUS ELEMENTS ACCORDING TO
C	LEROUX ALGORITHM (1979 VERSION).
C
C	NBS     04-SEP-1984
C
	IMPLICIT INTEGER (I,J)
	IMPLICIT REAL (A-H,K-Z)
	CALL ATNUM(INAM,IZ)
	E=12.3981/WV
	OPEN(UNIT=3,NAME='MACPRM.DAT',TYPE='OLD',ACCESS='DIRECT',
     1 MAXREC=94,RECORDSIZE=24)
	READ(3'IZ) C,K,NK,EP,CK1,NCK1,L1,NL1,L2,NL2,L3,NL3,M1,NM1,
     1 M2,NM2,M3,NM3,M4,NM4,M5,NM5,N1,NN1
	CLOSE(UNIT=3)
	IF(E.GT.K) GO TO 30
	IF(E.GT.L1) GO TO 40
	IF(E.GT.L2) GO TO 50
	IF(E.GT.L3) GO TO 60
	IF(E.GT.M1) GO TO 70
	IF(E.GT.M2) GO TO 80
	IF(E.GT.M3) GO TO 90
	IF(E.GT.M4) GO TO 100
	IF(E.GT.M5) GO TO 110
	IF(E.LT.N1) GO TO 120
	MU=C*N1*WV**NN1
	GO TO 150
30	IF(IZ.GT.57) GO TO 120
	IF(E.LT.EP) GO TO 35
	MU=C*K*WV**NK
	GO TO 150
35	MU=CK1*WV**NCK1
	GO TO 150
40	MU=C*L1*WV**NL1
	GO TO 150
50	MU=C*L2*WV**NL2
	GO TO 150
60	MU=C*L3*WV**NL3
	GO TO 150
70	MU=C*M1*WV**NM1
	GO TO 150
80	MU=C*M2*WV**NM2
	GO TO 150
90	MU=C*M3*WV**NM3
	GO TO 150
100	MU=C*M4*WV**NM4
	GO TO 150
110	MU=C*M5*WV**NM5
	GO TO 150
120	MU=0.
150	RETURN
	END
